//==============================================================================
//  Copyright (C) BAY9, 2013
//==============================================================================

// -----------------------------------------------------------------------------
// Simple top module including the IP core for synthesis testing
//
// Connect UART, clk, reset + 1 LED to FPGA pins and uses a dummy logic
// to prevent synthesis tools to remove other logic during optimization.
// See documenation for details

module wlanX(uartOut,
             uartIn,
             uartGnd,
             clkExt,
             resetExt,
             led0);

  // UART interface, clock input, LED
  output        uartOut;
  input         uartIn;
  output        uartGnd;
  input         clkExt;
  input         resetExt;
  output        led0;

  // Clock definition
  wire clk;

  // ---------------------------------------------------------------------------
  // Define main module + constants
  `include "def_Const_wlan.v"
  `include "wlan_0.v"

  // ---------------------------------------------------------------------------
  // Some definitions for internal dummy logic
  reg                          xOut, xIn;
  reg  [WlanAdcDacWidth_C-1:0] adcRe;
  reg  [WlanAdcDacWidth_C-1:0] adcIm;
  reg    [WlanDataWidth_C-1:0] dataTx;
  reg    [WlanGpioWidth_C-1:0] gpi;
  
  // ---------------------------------------------------------------------------
  // Assignment of inputs + outputs
  assign wlan_0_uartIn    = uartIn;
  assign uartOut          = wlan_0_uartOut;
  assign uartGnd          = 0;
  
  assign wlan_0_resetIn   = ~resetExt;    // Internal reset is active high
  assign wlan_0_ctrlSel   = 1;            // UART only
  
  assign led0             = wlan_0_statLed[0] | ~resetExt; // LED on during reset
  
  // Clock
  pllX pll(clkExt, clk);

  // ---------------------------------------------------------------------------
  // Dummy logic to keep synthesis tools from removing internal logic
  // during optimization process - connects all output to all inputs via
  // a multiplexor / demultiplexor network
  
  // Assign all outputs
  always @(*) begin
    case (wlan_0_gpo[6:0])
       0: xOut = wlan_0_resetOut;
      
       1: xOut = wlan_0_dacRe[0];
       2: xOut = wlan_0_dacRe[1];
       3: xOut = wlan_0_dacRe[2];
       4: xOut = wlan_0_dacRe[3];
       5: xOut = wlan_0_dacRe[4];
       6: xOut = wlan_0_dacRe[5];
       7: xOut = wlan_0_dacRe[6];
       8: xOut = wlan_0_dacRe[7];
       9: xOut = wlan_0_dacRe[8];
      10: xOut = wlan_0_dacRe[9];
      11: xOut = wlan_0_dacRe[10];
      12: xOut = wlan_0_dacRe[11];
      
      13: xOut = wlan_0_dacIm[0];
      14: xOut = wlan_0_dacIm[1];
      15: xOut = wlan_0_dacIm[2];
      16: xOut = wlan_0_dacIm[3];
      17: xOut = wlan_0_dacIm[4];
      18: xOut = wlan_0_dacIm[5];
      19: xOut = wlan_0_dacIm[6];
      20: xOut = wlan_0_dacIm[7];
      21: xOut = wlan_0_dacIm[8];
      22: xOut = wlan_0_dacIm[9];
      23: xOut = wlan_0_dacIm[10];
      24: xOut = wlan_0_dacIm[11];
      
      25: xOut = wlan_0_attn[0];
      26: xOut = wlan_0_attn[1];
      27: xOut = wlan_0_attn[2];
      28: xOut = wlan_0_attn[3];
      29: xOut = wlan_0_attn[4];
      30: xOut = wlan_0_attn[5];
      31: xOut = wlan_0_attn[6];
      32: xOut = wlan_0_attn[7];
      33: xOut = wlan_0_attn[8];
      34: xOut = wlan_0_attn[9];
      35: xOut = wlan_0_attn[10];
      36: xOut = wlan_0_attn[11];
      37: xOut = wlan_0_attn[12];
      38: xOut = wlan_0_attn[13];
      39: xOut = wlan_0_attn[14];
      40: xOut = wlan_0_attn[15];
      41: xOut = wlan_0_attn_or;
                
      42: xOut = wlan_0_paOn;
      43: xOut = wlan_0_txOn;
      44: xOut = wlan_0_rxOn;
      
      45: xOut = wlan_0_twbClk;
      46: xOut = wlan_0_twbDat;
      47: xOut = wlan_0_twbEn;
      
      48: xOut = wlan_0_dataRx[0];
      49: xOut = wlan_0_dataRx[1];
      50: xOut = wlan_0_dataRx[2];
      51: xOut = wlan_0_dataRx[3];
      52: xOut = wlan_0_dataRx[4];
      53: xOut = wlan_0_dataRx[5];
      54: xOut = wlan_0_dataRx[6];
      55: xOut = wlan_0_dataRx[7];
      56: xOut = wlan_0_dataRx[8];
      57: xOut = wlan_0_dataRx[9];
      58: xOut = wlan_0_dataRx[10];
      59: xOut = wlan_0_dataRx[11];
      60: xOut = wlan_0_dataRx[12];
      61: xOut = wlan_0_dataRx[13];
      62: xOut = wlan_0_dataRx[14];
      63: xOut = wlan_0_dataRx[15];
      64: xOut = wlan_0_dataRx_or;
      65: xOut = wlan_0_dataTx_ir;

      66: xOut = wlan_0_statLed[0];
      67: xOut = wlan_0_statLed[1];
      68: xOut = wlan_0_statLed[2];
      69: xOut = wlan_0_statLed[3];
      70: xOut = wlan_0_statLed[4];
      71: xOut = wlan_0_statLed[5];
      72: xOut = wlan_0_statLed[6];
      73: xOut = wlan_0_statLed[7];
      
      74: xOut = wlan_0_gpo[13];
      75: xOut = wlan_0_gpo[14];
      76: xOut = wlan_0_gpo[15];
      
      default: xOut = 0;
    endcase       
  end
  
  // Register this pseudo-output, use as input
  always @(posedge clk) begin
    xIn <= xOut;
  end    
      
  // Distribute input
  always @(*) begin
    
    // Set everything to 0
    adcRe = 0;
    adcIm = 0;
    dataTx = 0;
    gpi   = 0;
    
    case (wlan_0_gpo[12:7])
       0: adcRe[ 0]  = xIn;
       1: adcRe[ 1]  = xIn;
       2: adcRe[ 2]  = xIn;
       3: adcRe[ 3]  = xIn;
       4: adcRe[ 4]  = xIn;
       5: adcRe[ 5]  = xIn;
       6: adcRe[ 6]  = xIn;
       7: adcRe[ 7]  = xIn;
       8: adcRe[ 8]  = xIn;
       9: adcRe[ 9]  = xIn;
      10: adcRe[10]  = xIn;
      11: adcRe[11]  = xIn;
       
      12: adcIm[ 0]  = xIn;
      13: adcIm[ 1]  = xIn;
      14: adcIm[ 2]  = xIn;
      15: adcIm[ 3]  = xIn;
      16: adcIm[ 4]  = xIn;
      17: adcIm[ 5]  = xIn;
      18: adcIm[ 6]  = xIn;
      19: adcIm[ 7]  = xIn;
      20: adcIm[ 8]  = xIn;
      21: adcIm[ 9]  = xIn;
      22: adcIm[10]  = xIn;
      23: adcIm[11]  = xIn;
       
      24: dataTx[ 0] = xIn;
      25: dataTx[ 1] = xIn;
      26: dataTx[ 2] = xIn;
      27: dataTx[ 3] = xIn;
      28: dataTx[ 4] = xIn;
      29: dataTx[ 5] = xIn;
      30: dataTx[ 6] = xIn;
      31: dataTx[ 7] = xIn;
      32: dataTx[ 8] = xIn;
      33: dataTx[ 9] = xIn;
      34: dataTx[10] = xIn;
      35: dataTx[11] = xIn;
      36: dataTx[12] = xIn;
      37: dataTx[13] = xIn;
      38: dataTx[14] = xIn;
      39: dataTx[15] = xIn;
      
      40: gpi[ 0]    = xIn;
      41: gpi[ 1]    = xIn;
      42: gpi[ 2]    = xIn;
      43: gpi[ 3]    = xIn;
      44: gpi[ 4]    = xIn;
      45: gpi[ 5]    = xIn;
      46: gpi[ 6]    = xIn;
      47: gpi[ 7]    = xIn;
      48: gpi[ 8]    = xIn;
      49: gpi[ 9]    = xIn;
      50: gpi[10]    = xIn;
      51: gpi[11]    = xIn;
      52: gpi[12]    = xIn;
      53: gpi[13]    = xIn;
      54: gpi[14]    = xIn;
      55: gpi[15]    = xIn;
 
    endcase
  end  

  // Assign all inputs
  assign  wlan_0_adcRe  = adcRe;
  assign  wlan_0_adcIm  = adcIm;
  assign  wlan_0_dataTx = dataTx;
  assign  wlan_0_gpi    = gpi;

  // Assume data is constantly fed into / read from phy
  assign  wlan_0_adc_or     = 1;
  assign  wlan_0_dac_ir     = 1;
  assign  wlan_0_dataTx_or  = 1;

endmodule

// =============================================================================

