function cfm = sendMsg(id, req, nCfm)
%===============================================================================
%  Copyright (C) BAY9, 2015
%===============================================================================
%
% Syntax:
%   cfm = sendMsg(id, req, nCfm)
%
% Inputs:
%   id      - Target identifier - not used
%   req     - Request message
%   nCfm    - Number of expected confirms
%
% Outputs:
%   cfm     - Confirm message
%
% Description:
%   Send message to WLAN subsystem via the UART device file interface.
%
%   Note that generally, 'id' is a parameter with arbritrary fields, e.g.
%   'core' to specify the current IP core type, 'inst' to specify an instance
%   of the IP core (in case there are several) etc... . This feature can be
%   used with more complicated setups including several different IP cores.
%   The sendMsg function must be adapted accordingly then.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Auto init UART connection if not yet established
  persistent uartFid;
  if (isempty(uartFid))
    uartFid = uartInit();
  end

  % ------------------------------------
  % Send request
  if (isempty(req)==0)
    fwrite(uartFid, mod(req, 2^16), 'uint16');
    fflush(uartFid);
  end

  % Read confirm message
  if (nCfm)
    cfm = fread(uartFid, nCfm, 'uint16')';
  else
    cfm = [];
  end

% ==============================================================================

