//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   wdfTpaV2
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module wdfTpaV2(b1, b1_or, b1_ff, b1_we, 
                b2, b2_or, b2_ff, b2_we, 
                a1, a1_ir, a1_fe, a1_re, 
                a2, a2_ir, a2_fe, a2_re, 
                c, c_ir, c_fe, c_re, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter b1_w              = 0;
  parameter b2_w              = 0;
  parameter a1_w              = 0;
  parameter a2_w              = 0;
  parameter c_w               = 0;


  parameter w                 = 0;
  parameter cw                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output           [b1_w-1:0]  b1;
  output                       b1_or;
  input                        b1_ff;
  output                       b1_we;
  assign                       b1_we = b1_or & ~b1_ff;

  output           [b2_w-1:0]  b2;
  output                       b2_or;
  input                        b2_ff;
  output                       b2_we;
  assign                       b2_we = b2_or & ~b2_ff;

  input            [a1_w-1:0]  a1;
  output                       a1_ir;
  input                        a1_fe;
  output                       a1_re;
  assign                       a1_re = a1_ir & ~a1_fe;

  input            [a2_w-1:0]  a2;
  output                       a2_ir;
  input                        a2_fe;
  output                       a2_re;
  assign                       a2_re = a2_ir & ~a2_fe;

  input             [c_w-1:0]  c;
  output                       c_ir;
  input                        c_fe;
  output                       c_re;
  assign                       c_re = c_ir & ~c_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

//-----------------------------------------------------------------------------------------
//define internal wires and registers
  wire           [w:0]  x;
  wire     [w+c_w-1:0]  y0;
  wire           [w:0]  y;
  wire           [w:0]  z;
  wire           [w:0]  w1, w2;

//-----------------------------------------------------------------------------------------
  // Addition of input waves, use sign extended inputs
  assign x = {a1[w-1], a1} + {a2[w-1], a2};     // width = w+1

  // Multiply y = (a1+a2)*c
  mulSi mul1(y0, x, c);                         // c*(a1-a2)
  defparam mul1.c_w  = w+c_w;                   // width = w+c_w
  defparam mul1.a_w  = w+1;
  defparam mul1.b_w  = c_w;

  // Discard lower bits + rounding
  assign y = y0[w+c_w-1:c_w-1];                 // width = w+1
  assign z = y[w] ? y+1 : y;                    // width = w+1

  // Calculate output (extended by 2 bit)
  assign b1 = a2 + z[w-1:0];                    // width = w
  assign b2 = a1 - z[w-1:0];                    // width = w
      
endmodule
//=========================================================================================
