//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   wdfSrc
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module wdfSrc(y, y_or, y_ff, y_we, 
              y40, y40_or, y40_ff, y40_we, 
              x, x_ir, x_fe, x_re, 
              run1, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter y40_w             = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter cLo1_w            = 0;
  parameter cLo1_r            = 0;
  parameter cLo1_s            = 0;
  parameter R_cLo1            = 0;
  parameter cLo2_w            = 0;
  parameter cLo2_r            = 0;
  parameter cLo2_s            = 0;
  parameter R_cLo2            = 0;
  parameter cLo3_w            = 0;
  parameter cLo3_r            = 0;
  parameter cLo3_s            = 0;
  parameter R_cLo3            = 0;
  parameter cLo4_w            = 0;
  parameter cLo4_r            = 0;
  parameter cLo4_s            = 0;
  parameter R_cLo4            = 0;
  parameter cHi1_w            = 0;
  parameter cHi1_r            = 0;
  parameter cHi1_s            = 0;
  parameter R_cHi1            = 0;
  parameter cHi2_w            = 0;
  parameter cHi2_r            = 0;
  parameter cHi2_s            = 0;
  parameter R_cHi2            = 0;
  parameter singleAdc_w       = 0;
  parameter singleAdc_r       = 0;
  parameter singleAdc_s       = 0;
  parameter R_singleAdc       = 0;

  parameter w                 = 0;
  parameter we                = 0;
  parameter wc                = 0;

  parameter R0_w              = 0;
  parameter R0_n              = 0;
  parameter R0_m              = 0;
  parameter R1_w              = 0;
  parameter R1_n              = 0;
  parameter R1_m              = 0;
  parameter R2_w              = 0;
  parameter R2_n              = 0;
  parameter R2_m              = 0;

  parameter ySat_w            = 0;
  parameter ySat_or_w         = 0;
  parameter ySat_ff_w         = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output          [y40_w-1:0]  y40;
  output                       y40_or;
  input                        y40_ff;
  output                       y40_we;
  assign                       y40_we = y40_or & ~y40_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [cLo1_w-1:0]  cLo1_q;
  wire           [cLo1_w-1:0]  cLo1_d;
  wire                         cLo1_weint;
  assign                       cLo1_weint = 0;

  wire           [cLo2_w-1:0]  cLo2_q;
  wire           [cLo2_w-1:0]  cLo2_d;
  wire                         cLo2_weint;
  assign                       cLo2_weint = 0;

  wire           [cLo3_w-1:0]  cLo3_q;
  wire           [cLo3_w-1:0]  cLo3_d;
  wire                         cLo3_weint;
  assign                       cLo3_weint = 0;

  wire           [cLo4_w-1:0]  cLo4_q;
  wire           [cLo4_w-1:0]  cLo4_d;
  wire                         cLo4_weint;
  assign                       cLo4_weint = 0;

  wire           [cHi1_w-1:0]  cHi1_q;
  wire           [cHi1_w-1:0]  cHi1_d;
  wire                         cHi1_weint;
  assign                       cHi1_weint = 0;

  wire           [cHi2_w-1:0]  cHi2_q;
  wire           [cHi2_w-1:0]  cHi2_d;
  wire                         cHi2_weint;
  assign                       cHi2_weint = 0;

  wire      [singleAdc_w-1:0]  singleAdc_q;
  wire      [singleAdc_w-1:0]  singleAdc_d;
  wire                         singleAdc_weint;
  assign                       singleAdc_weint = 0;

  // Wires defined for various purposes
  wire           [ySat_w-1:0]  ySat;
  wire        [ySat_or_w-1:0]  ySat_or;
  wire        [ySat_ff_w-1:0]  ySat_ff;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg cLo1(cLo1_q, regBus, cLo1_d, cLo1_weint, regWe, regRe, clk, reset);
  defparam cLo1.w    = cLo1_w;
  defparam cLo1.rval = cLo1_r;
  defparam cLo1.sgn  = cLo1_s;
  defparam cLo1.adr  = R_cLo1;

  ereg cLo2(cLo2_q, regBus, cLo2_d, cLo2_weint, regWe, regRe, clk, reset);
  defparam cLo2.w    = cLo2_w;
  defparam cLo2.rval = cLo2_r;
  defparam cLo2.sgn  = cLo2_s;
  defparam cLo2.adr  = R_cLo2;

  ereg cLo3(cLo3_q, regBus, cLo3_d, cLo3_weint, regWe, regRe, clk, reset);
  defparam cLo3.w    = cLo3_w;
  defparam cLo3.rval = cLo3_r;
  defparam cLo3.sgn  = cLo3_s;
  defparam cLo3.adr  = R_cLo3;

  ereg cLo4(cLo4_q, regBus, cLo4_d, cLo4_weint, regWe, regRe, clk, reset);
  defparam cLo4.w    = cLo4_w;
  defparam cLo4.rval = cLo4_r;
  defparam cLo4.sgn  = cLo4_s;
  defparam cLo4.adr  = R_cLo4;

  ereg cHi1(cHi1_q, regBus, cHi1_d, cHi1_weint, regWe, regRe, clk, reset);
  defparam cHi1.w    = cHi1_w;
  defparam cHi1.rval = cHi1_r;
  defparam cHi1.sgn  = cHi1_s;
  defparam cHi1.adr  = R_cHi1;

  ereg cHi2(cHi2_q, regBus, cHi2_d, cHi2_weint, regWe, regRe, clk, reset);
  defparam cHi2.w    = cHi2_w;
  defparam cHi2.rval = cHi2_r;
  defparam cHi2.sgn  = cHi2_s;
  defparam cHi2.adr  = R_cHi2;

  ereg singleAdc(singleAdc_q, regBus, singleAdc_d, singleAdc_weint, regWe, regRe, clk, reset);
  defparam singleAdc.w    = singleAdc_w;
  defparam singleAdc.rval = singleAdc_r;
  defparam singleAdc.sgn  = singleAdc_s;
  defparam singleAdc.adr  = R_singleAdc;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [R0_w-1:0]  R0;
  reg              [R1_w-1:0]  R1;
  reg              [R2_w-1:0]  R2;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "wdfCore_re1.v"
  `include "wdfCore_re2.v"
  `include "wdfCore_im1.v"
  `include "wdfCore_im2.v"
  `include "buf2_24.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign buf2_24_x                 = ySat;
  assign buf2_24_x_fe              = ~ySat_or;
  assign ySat_ff                   = ~buf2_24_x_ir;

  assign y                         = buf2_24_y;
  assign y_or                      = buf2_24_y_or;
  assign buf2_24_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | wdfCore_re1_regWe | wdfCore_re2_regWe | wdfCore_im1_regWe
                      | wdfCore_im2_regWe | buf2_24_regWe;
  assign regReOut = 0 | wdfCore_re1_regRe | wdfCore_re2_regRe | wdfCore_im1_regRe
                      | wdfCore_im2_regRe | buf2_24_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register/wire definitions
  reg                  run1D, run1DD; 
  reg                  x_reD;
  reg           [1:0]  cnt;          // Internal state counter
  wire          [1:0]  cntNxt;
  reg           [1:0]  runF;
  wire                 runNxt, runTxNxt, runRxNxt;
  
  reg         [wc-1:0] coef1, coef2;
  reg                  sel1A, sel2A;
  reg            [1:0] sel1B, sel2B;
  reg            [1:0] sel1S, sel2S;

  wire      [w+we-1:0] f1InRe, f1InIm;
  wire      [w+we-1:0] f2InRe, f2InIm;
  
  wire        [w+we:0] wdfOutRe, wdfOutIm;
  wire         [w-1:0] ySatRe, ySatIm;
//  wire       [2*w-1:0] ySat;                  // Preliminary output
//  wire                 ySat_we, ySat_or, ySat_ff;
   
  // --------------------------------------------------------------------------------------
  // Set delayed run variables
  always @(posedge clk) begin
    run1D  <= run1!=0;
    run1DD <= run1D;
    x_reD  <= x_reD;
  end
  
  // Reset output buffer
  assign buf2_24_run1 = (run1==2 || run1==3);
  
  // Get some run variables
  assign runTxNxt = (run1==2 && (y_ff==0 || run1DD==0));
  assign runRxNxt = (run1==3 && x_re==1);
  assign runNxt   = runTxNxt || runRxNxt;

  // Assign input ready
  assign x_ir = (run1==2 && ((y_ff==0 || run1DD==0) && cnt==0) ) || (run1==3);
  
  // ---------------------------------------------------------------------------
  // Write to the input register
  always @(posedge clk) begin
    if (run1==0) begin
      R0 <= 0;
    end else
    if (x_re) begin
      R0 <= x;
    end 
  end

  // ---------------------------------------------------------------------------
  // Enable for inner state machine
  always @(posedge clk) begin  
    if (run1==0) begin
      runF <= 0;
    end else
    if (runNxt) begin
      runF <= run1;
    end else
    begin
      runF <= 1;
    end
  end    

  // Set registers for the inner state machine
  assign cntNxt = cnt+1;
  always @(posedge clk) begin  
    if (run1==0) begin
      cnt <= 0;
    end else 
    if (runNxt) begin
      cnt <= cntNxt;
    end
  end

  // ---------------------------------------------------------------------------
  // Set control registers for F1
  always @(posedge clk) begin  
    if (run1==0) begin
      coef1 <= 0;
      sel1A <= 0;
      sel1B <= 0;
      sel1S <= 0;
    end else
    
    if (runTxNxt) begin
      if (cntNxt==1) begin
        coef1 <= cLo1_q;
        sel1A <= 0;
        sel1B <= 0;
        sel1S <= 0;
      end else
      if (cntNxt==2) begin
        coef1 <= cLo3_q;
        sel1A <= 1;
        sel1B <= 1;
        sel1S <= 0;
      end else
      if (cntNxt==3) begin
        coef1 <= cLo2_q;
        sel1A <= 0;
        sel1B <= 2;
        sel1S <= 0;
      end else
      if (cntNxt==0) begin
        coef1 <= cLo4_q;
        sel1A <= 1;
        sel1B <= 3;
        sel1S <= 0;
      end
    end else
    
    if (runRxNxt) begin
      if (cnt==0 || cnt==2) begin
        coef1 <= cHi2_q;
        sel1A <= 0;
        sel1B <= 0;
        sel1S <= 1;
      end else
      if (cnt==1 || cnt==3) begin
        coef1 <= cHi1_q;
        sel1A <= 0;
        sel1B <= 1;
        sel1S <= 0;
      end
    end
  end
  
  // ---------------------------------------------------------------------------
  // Sign extension + feed filter F1
  assign f1InRe = {{we{R0[  w-1]}}, R0[  w-1:0]};
  assign f1InIm = {{we{R0[2*w-1]}}, R0[2*w-1:w]};
  
  assign wdfCore_re1_x    = f1InRe;
  assign wdfCore_re1_run1 = runF;
  assign wdfCore_re1_c    = coef1;
  assign wdfCore_re1_selA = sel1A;
  assign wdfCore_re1_selB = sel1B;
  assign wdfCore_re1_selS = sel1S;
    
  assign wdfCore_im1_x    = f1InIm;
  assign wdfCore_im1_run1 = runF;
  assign wdfCore_im1_c    = coef1;
  assign wdfCore_im1_selA = sel1A;
  assign wdfCore_im1_selB = sel1B;
  assign wdfCore_im1_selS = sel1S;

  // ---------------------------------------------------------------------------
  // Debug output
  assign y40    = {wdfCore_im1_y, wdfCore_re1_y};
  assign y40_or = (runF==2 && (cnt==1 || cnt==3))  ||
                  (runF==3 && (cnt==1 || cnt==3));

  // Write intermediate storage F1->F2
  always @(posedge clk) begin  
    if (run1==0) begin
      R1 <= 0;
    end else
    if (y40_or) begin
      R1 <= {wdfCore_im1_y, wdfCore_re1_y};
    end
  end

  // ---------------------------------------------------------------------------
  // Set control registers for F2
  always @(posedge clk) begin  
    if (run1==0) begin
      coef2 <= 0;
      sel2A <= 0;
      sel2B <= 0;
      sel2S <= 0;
    end else
    
    if (runTxNxt) begin
      if (cntNxt==0 || cntNxt==2) begin
        coef2 <= cHi1_q;
        sel2A <= 0;
        sel2B <= 0;
        sel2S <= 0;
      end else
      if (cntNxt==1 || cntNxt==3) begin
        coef2 <= cHi2_q;
        sel2A <= 0;
        sel2B <= 1;
        sel2S <= 0;
      end
    end else
    
    if (runRxNxt) begin
      if (cnt==1) begin
        coef2 <= cLo2_q;
        sel2A <= 0;
        sel2B <= 0;
        sel2S <= 1;
      end else
      if (cnt==2) begin
        coef2 <= cLo4_q;
        sel2A <= 1;
        sel2B <= 1;
        sel2S <= 2;
      end else
      if (cnt==3) begin
        coef2 <= cLo1_q;
        sel2A <= 0;
        sel2B <= 2;
        sel2S <= 0;
      end else
      if (cnt==0) begin
        coef2 <= cLo3_q;
        sel2A <= 1;
        sel2B <= 3;
        sel2S <= 2;
      end
    end
  end

  assign f2InRe = R1[w+we-1:0];
  assign f2InIm = R1[2*(w+we)-1:w+we];
  
  assign wdfCore_re2_x    = f2InRe;
  assign wdfCore_re2_run1 = runF;
  assign wdfCore_re2_c    = coef2;
  assign wdfCore_re2_selA = sel2A;
  assign wdfCore_re2_selB = sel2B;
  assign wdfCore_re2_selS = sel2S;

  assign wdfCore_im2_x    = f2InIm;
  assign wdfCore_im2_run1 = runF;
  assign wdfCore_im2_c    = coef2;
  assign wdfCore_im2_selA = sel2A;
  assign wdfCore_im2_selB = sel2B;
  assign wdfCore_im2_selS = sel2S;

  // ---------------------------------------------------------------------------
  // Shift in case of single ADC
  assign wdfOutRe = (singleAdc_q==1 && run1==3) ? 
                    {wdfCore_re2_y, 1'b0} : {wdfCore_re2_y[w+we-1], wdfCore_re2_y};
  assign wdfOutIm = (singleAdc_q==1 && run1==3) ? 
                    {wdfCore_im2_y, 1'b0} : {wdfCore_im2_y[w+we-1], wdfCore_im2_y};
  
  // Saturation and output
  sat satRe(ySatRe, wdfOutRe);
  defparam satRe.x_w = w+we+1;
  defparam satRe.y_w = w;

  sat satIm(ySatIm, wdfOutIm);
  defparam satIm.x_w = w+we+1;
  defparam satIm.y_w = w;
  
  assign ySat     = {ySatIm, ySatRe};
  assign ySat_or  = (runF==2 || (runF==3 && cnt==2));
  
  // --------------------------------------------------------------------------------------
  // Assign ySat -> buf2_24 -> y (do this automatically)
  
  // --------------------------------------------------------------------------------------
  
endmodule
//=========================================================================================

