//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   wdfCore
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module wdfCore(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               c, c_ir, c_fe, c_re, 
               selA, selA_ir, selA_fe, selA_re, 
               selB, selB_ir, selB_fe, selB_re, 
               selS, selS_ir, selS_fe, selS_re, 
               run1, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;
  parameter c_w               = 0;
  parameter selA_w            = 0;
  parameter selB_w            = 0;
  parameter selS_w            = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;
  parameter wc                = 0;

  parameter B_w               = 0;
  parameter B_n               = 0;
  parameter B_m               = 0;
  parameter R_w               = 0;
  parameter R_n               = 0;
  parameter R_m               = 0;
  parameter S_w               = 0;
  parameter S_n               = 0;
  parameter S_m               = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input             [c_w-1:0]  c;
  output                       c_ir;
  input                        c_fe;
  output                       c_re;
  assign                       c_re = c_ir & ~c_fe;

  input          [selA_w-1:0]  selA;
  output                       selA_ir;
  input                        selA_fe;
  output                       selA_re;
  assign                       selA_re = selA_ir & ~selA_fe;

  input          [selB_w-1:0]  selB;
  output                       selB_ir;
  input                        selB_fe;
  output                       selB_re;
  assign                       selB_re = selB_ir & ~selB_fe;

  input          [selS_w-1:0]  selS;
  output                       selS_ir;
  input                        selS_fe;
  output                       selS_re;
  assign                       selS_re = selS_ir & ~selS_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg               [B_w-1:0]  B[B_n-1:0];
  reg               [R_w-1:0]  R;
  reg               [S_w-1:0]  S;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "wdfTpaV2_0.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | wdfTpaV2_0_regWe;
  assign regReOut = 0 | wdfTpaV2_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg      [w-1:0]  a1;         // Connections to TPA
  reg      [w-1:0]  a2;
  wire     [w-1:0]  b1;
  wire     [w-1:0]  b2;
  
  reg        [w:0]  Rp;         // Added up output of WDF-TPA
  reg      [w-1:0]  Snxt;      //

  // Needed for XST
  wire   [B_w-1:0] B0, B1, B2, B3;
  assign B0 = B[0];
  assign B1 = B[1];
  assign B2 = B[2];
  assign B3 = B[3];

  // --------------------------------------------------------------------------------------
  // Connect TPA
  assign wdfTpaV2_0_a1 = a1;
  assign wdfTpaV2_0_a2 = a2;
  assign wdfTpaV2_0_c  = c;
  assign b1 = wdfTpaV2_0_b1;
  assign b2 = wdfTpaV2_0_b2;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin

    case (selA)
      0: a1 = x;
      1: a1 = R;
    endcase
    
    case (selB)
      0: a2 = B0;
      1: a2 = B1;
      2: a2 = B2;
      3: a2 = B3;
    endcase

    Rp = {S[w-1], S} + {R[w-1], R};
    case (selS)
      0: Snxt = R;
      1: Snxt = Rp[w:1];
      default: Snxt = S;
   endcase
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      R     <= 0;
      S     <= 0;
      B[0]  <= 0;
      B[1]  <= 0;
      B[2]  <= 0;
      B[3]  <= 0;
    end else 
    
    // Normal operation, continue only upon run=2/3
    if (run1==2 | run1==3) begin
      
      R <= b1;
      S <= Snxt;
            
      if (selB==0)
        B[0] <= b2;
      else if (selB==1) 
        B[1] <= b2;
      else if (selB==2)
        B[2] <= b2;
      else 
        B[3] <= b2;

    end // if (run1[1]==1)
  end // always
  
  // --------------------------------------------------------------------------------------
  // Assign output
  assign y = Snxt;

endmodule
//=========================================================================================

