//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   vitTbd
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module vitTbd(b, b_or, b_ff, b_we, 
              endIdx, endIdx_or, endIdx_ff, endIdx_we, 
              yIdx, yIdx_or, yIdx_ff, yIdx_we, 
              selA, selA_ir, selA_fe, selA_re, 
              selB, selB_ir, selB_fe, selB_re, 
              run1, 
              startIdx, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter b_w               = 0;
  parameter endIdx_w          = 0;
  parameter yIdx_w            = 0;
  parameter selA_w            = 0;
  parameter selB_w            = 0;

  parameter run1_w            = 0;
  parameter startIdx_w        = 0;

  parameter ws                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [b_w-1:0]  b;
  output                       b_or;
  input                        b_ff;
  output                       b_we;
  assign                       b_we = b_or & ~b_ff;

  output       [endIdx_w-1:0]  endIdx;
  output                       endIdx_or;
  input                        endIdx_ff;
  output                       endIdx_we;
  assign                       endIdx_we = endIdx_or & ~endIdx_ff;

  output         [yIdx_w-1:0]  yIdx;
  output                       yIdx_or;
  input                        yIdx_ff;
  output                       yIdx_we;
  assign                       yIdx_we = yIdx_or & ~yIdx_ff;

  input          [selA_w-1:0]  selA;
  output                       selA_ir;
  input                        selA_fe;
  output                       selA_re;
  assign                       selA_re = selA_ir & ~selA_fe;

  input          [selB_w-1:0]  selB;
  output                       selB_ir;
  input                        selB_fe;
  output                       selB_re;
  assign                       selB_re = selB_ir & ~selB_fe;

  input          [run1_w-1:0]  run1;
  input      [startIdx_w-1:0]  startIdx;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg      [5:0]  idx, idxCur, idx_nxt;
  reg   [ws-1:0]  sel;
  reg             bReg, b_nxt, tbb;
  reg             run1D;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin

    // Get current index and input selector
    idxCur = run1D==0 ? startIdx : idx;
    sel    = {selB, selA};
    tbb    = sel[idxCur];

    // Traceback to get next index
    idx_nxt =  {tbb, idxCur[5:1]};
    b_nxt   =  idxCur[0];
  end


  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      bReg  <= 0;
      idx   <= 0;
      run1D <= 0;          
      
    // Normal operation
    end else begin
      bReg  <= b_nxt;
      idx   <= idx_nxt;
      run1D <= run1;

    end // if (run1_q==0) ... else

  end // always

  // Output control signals
  assign yIdx      = idx;
  assign yIdx_or   = run1D==1;
  assign endIdx    = idx;
  assign endIdx_or = run1==0 & run1D==1;
  assign b         = bReg;
  assign b_or      = run1D==1;

endmodule
//=========================================================================================

