//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   vitMem
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module vitMem(memOut0A, memOut0A_or, memOut0A_ff, memOut0A_we, 
              memOut0B, memOut0B_or, memOut0B_ff, memOut0B_we, 
              memOut1A, memOut1A_or, memOut1A_ff, memOut1A_we, 
              memOut1B, memOut1B_or, memOut1B_ff, memOut1B_we, 
              wrAdr, wrAdr_ir, wrAdr_fe, wrAdr_re, 
              rdAdr0, rdAdr0_ir, rdAdr0_fe, rdAdr0_re, 
              rdAdr1, rdAdr1_ir, rdAdr1_fe, rdAdr1_re, 
              memInA, memInA_ir, memInA_fe, memInA_re, 
              memInB, memInB_ir, memInB_fe, memInB_re, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter memOut0A_w        = 0;
  parameter memOut0B_w        = 0;
  parameter memOut1A_w        = 0;
  parameter memOut1B_w        = 0;
  parameter wrAdr_w           = 0;
  parameter rdAdr0_w          = 0;
  parameter rdAdr1_w          = 0;
  parameter memInA_w          = 0;
  parameter memInB_w          = 0;


  parameter mem0A_w           = 0;
  parameter mem0A_n           = 0;
  parameter mem0A_m           = 0;
  parameter mem0B_w           = 0;
  parameter mem0B_n           = 0;
  parameter mem0B_m           = 0;
  parameter mem1A_w           = 0;
  parameter mem1A_n           = 0;
  parameter mem1A_m           = 0;
  parameter mem1B_w           = 0;
  parameter mem1B_n           = 0;
  parameter mem1B_m           = 0;
  parameter mem2A_w           = 0;
  parameter mem2A_n           = 0;
  parameter mem2A_m           = 0;
  parameter mem2B_w           = 0;
  parameter mem2B_n           = 0;
  parameter mem2B_m           = 0;
  parameter mem3A_w           = 0;
  parameter mem3A_n           = 0;
  parameter mem3A_m           = 0;
  parameter mem3B_w           = 0;
  parameter mem3B_n           = 0;
  parameter mem3B_m           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output     [memOut0A_w-1:0]  memOut0A;
  output                       memOut0A_or;
  input                        memOut0A_ff;
  output                       memOut0A_we;
  assign                       memOut0A_we = memOut0A_or & ~memOut0A_ff;

  output     [memOut0B_w-1:0]  memOut0B;
  output                       memOut0B_or;
  input                        memOut0B_ff;
  output                       memOut0B_we;
  assign                       memOut0B_we = memOut0B_or & ~memOut0B_ff;

  output     [memOut1A_w-1:0]  memOut1A;
  output                       memOut1A_or;
  input                        memOut1A_ff;
  output                       memOut1A_we;
  assign                       memOut1A_we = memOut1A_or & ~memOut1A_ff;

  output     [memOut1B_w-1:0]  memOut1B;
  output                       memOut1B_or;
  input                        memOut1B_ff;
  output                       memOut1B_we;
  assign                       memOut1B_we = memOut1B_or & ~memOut1B_ff;

  input         [wrAdr_w-1:0]  wrAdr;
  output                       wrAdr_ir;
  input                        wrAdr_fe;
  output                       wrAdr_re;
  assign                       wrAdr_re = wrAdr_ir & ~wrAdr_fe;

  input        [rdAdr0_w-1:0]  rdAdr0;
  output                       rdAdr0_ir;
  input                        rdAdr0_fe;
  output                       rdAdr0_re;
  assign                       rdAdr0_re = rdAdr0_ir & ~rdAdr0_fe;

  input        [rdAdr1_w-1:0]  rdAdr1;
  output                       rdAdr1_ir;
  input                        rdAdr1_fe;
  output                       rdAdr1_re;
  assign                       rdAdr1_re = rdAdr1_ir & ~rdAdr1_fe;

  input        [memInA_w-1:0]  memInA;
  output                       memInA_ir;
  input                        memInA_fe;
  output                       memInA_re;
  assign                       memInA_re = memInA_ir & ~memInA_fe;

  input        [memInB_w-1:0]  memInB;
  output                       memInB_ir;
  input                        memInB_fe;
  output                       memInB_re;
  assign                       memInB_re = memInB_ir & ~memInB_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for internal memories
  wire          [mem0A_w-1:0]  mem0A_q;
  wire          [mem0A_w-1:0]  mem0A_d;
  wire          [mem0A_m-1:0]  mem0A_adr;
  wire                         mem0A_we;
  wire          [mem0B_w-1:0]  mem0B_q;
  wire          [mem0B_w-1:0]  mem0B_d;
  wire          [mem0B_m-1:0]  mem0B_adr;
  wire                         mem0B_we;
  wire          [mem1A_w-1:0]  mem1A_q;
  wire          [mem1A_w-1:0]  mem1A_d;
  wire          [mem1A_m-1:0]  mem1A_adr;
  wire                         mem1A_we;
  wire          [mem1B_w-1:0]  mem1B_q;
  wire          [mem1B_w-1:0]  mem1B_d;
  wire          [mem1B_m-1:0]  mem1B_adr;
  wire                         mem1B_we;
  wire          [mem2A_w-1:0]  mem2A_q;
  wire          [mem2A_w-1:0]  mem2A_d;
  wire          [mem2A_m-1:0]  mem2A_adr;
  wire                         mem2A_we;
  wire          [mem2B_w-1:0]  mem2B_q;
  wire          [mem2B_w-1:0]  mem2B_d;
  wire          [mem2B_m-1:0]  mem2B_adr;
  wire                         mem2B_we;
  wire          [mem3A_w-1:0]  mem3A_q;
  wire          [mem3A_w-1:0]  mem3A_d;
  wire          [mem3A_m-1:0]  mem3A_adr;
  wire                         mem3A_we;
  wire          [mem3B_w-1:0]  mem3B_q;
  wire          [mem3B_w-1:0]  mem3B_d;
  wire          [mem3B_m-1:0]  mem3B_adr;
  wire                         mem3B_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal single ported memories
  spRam1 mem0A(mem0A_q, mem0A_d, mem0A_adr, mem0A_we, clk);
  defparam mem0A.w    = mem0A_w;
  defparam mem0A.n    = mem0A_n;
  defparam mem0A.m    = mem0A_m;

  spRam1 mem0B(mem0B_q, mem0B_d, mem0B_adr, mem0B_we, clk);
  defparam mem0B.w    = mem0B_w;
  defparam mem0B.n    = mem0B_n;
  defparam mem0B.m    = mem0B_m;

  spRam1 mem1A(mem1A_q, mem1A_d, mem1A_adr, mem1A_we, clk);
  defparam mem1A.w    = mem1A_w;
  defparam mem1A.n    = mem1A_n;
  defparam mem1A.m    = mem1A_m;

  spRam1 mem1B(mem1B_q, mem1B_d, mem1B_adr, mem1B_we, clk);
  defparam mem1B.w    = mem1B_w;
  defparam mem1B.n    = mem1B_n;
  defparam mem1B.m    = mem1B_m;

  spRam1 mem2A(mem2A_q, mem2A_d, mem2A_adr, mem2A_we, clk);
  defparam mem2A.w    = mem2A_w;
  defparam mem2A.n    = mem2A_n;
  defparam mem2A.m    = mem2A_m;

  spRam1 mem2B(mem2B_q, mem2B_d, mem2B_adr, mem2B_we, clk);
  defparam mem2B.w    = mem2B_w;
  defparam mem2B.n    = mem2B_n;
  defparam mem2B.m    = mem2B_m;

  spRam1 mem3A(mem3A_q, mem3A_d, mem3A_adr, mem3A_we, clk);
  defparam mem3A.w    = mem3A_w;
  defparam mem3A.n    = mem3A_n;
  defparam mem3A.m    = mem3A_m;

  spRam1 mem3B(mem3B_q, mem3B_d, mem3B_adr, mem3B_we, clk);
  defparam mem3B.w    = mem3B_w;
  defparam mem3B.n    = mem3B_n;
  defparam mem3B.m    = mem3B_m;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire          memRd0,  memRd1,  memWr;
  wire   [1:0]  rdIdx0,  rdIdx1,  wrIdx;
  reg    [1:0]  rdIdx0D, rdIdx1D;
  reg           memRd0D, memRd1D;

  // --------------------------------------------------------------------------------------
  // Get valid signals
  assign  memWr     = ~wrAdr_fe;
  assign  memRd0    = ~rdAdr0_fe;
  assign  memRd1    = ~rdAdr1_fe;
  
  // Get memory indices
  assign  wrIdx     = wrAdr[7:6];
  assign  rdIdx0    = rdAdr0[7:6];
  assign  rdIdx1    = rdAdr1[7:6];
  
  // Delay memory indices for output multiplexing
  always @(posedge clk) begin
    rdIdx0D <= rdIdx0;
    rdIdx1D <= rdIdx1;
    memRd0D <= memRd0;
    memRd1D <= memRd1;
  end
  
  // --------------------------------------------------------------------------------------
  // Input multiplexor
  assign  mem0A_d   = memInA;
  assign  mem0B_d   = memInB;
  assign  mem0A_we  = memWr & wrIdx==0;
  assign  mem0B_we  = memWr & wrIdx==0;
  
  assign  mem1A_d   = memInA;
  assign  mem1B_d   = memInB;
  assign  mem1A_we  = memWr & wrIdx==1;
  assign  mem1B_we  = memWr & wrIdx==1;
  
  assign  mem2A_d   = memInA;
  assign  mem2B_d   = memInB;
  assign  mem2A_we  = memWr & wrIdx==2;
  assign  mem2B_we  = memWr & wrIdx==2;
  
  assign  mem3A_d   = memInA;
  assign  mem3B_d   = memInB;
  assign  mem3A_we  = memWr & wrIdx==3;
  assign  mem3B_we  = memWr & wrIdx==3;

  // --------------------------------------------------------------------------------------
  // Output multiplexor
  assign  memOut0A = rdIdx0D==0 ? mem0A_q : 
                     rdIdx0D==1 ? mem1A_q :
                     rdIdx0D==2 ? mem2A_q : 
                                  mem3A_q;
  assign  memOut0B = rdIdx0D==0 ? mem0B_q : 
                     rdIdx0D==1 ? mem1B_q :
                     rdIdx0D==2 ? mem2B_q : 
                                  mem3B_q;
  
  assign  memOut1A = rdIdx1D==0 ? mem0A_q : 
                     rdIdx1D==1 ? mem1A_q :
                     rdIdx1D==2 ? mem2A_q : 
                                  mem3A_q;
  assign  memOut1B = rdIdx1D==0 ? mem0B_q : 
                     rdIdx1D==1 ? mem1B_q :
                     rdIdx1D==2 ? mem2B_q : 
                                  mem3B_q;
  
  // --------------------------------------------------------------------------------------
  // Address multiplexor
  assign mem0A_adr = (wrIdx==0  & memWr ) ? wrAdr[5:0]  :
                     (rdIdx0==0 & memRd0) ? rdAdr0[5:0] :
                     (rdIdx1==0 & memRd1) ? rdAdr1[5:0] : 0;
  assign mem0B_adr = mem0A_adr;
  
  assign mem1A_adr = (wrIdx==1  & memWr ) ? wrAdr[5:0]  :
                     (rdIdx0==1 & memRd0) ? rdAdr0[5:0] :
                     (rdIdx1==1 & memRd1) ? rdAdr1[5:0] : 0;
  assign mem1B_adr = mem1A_adr;

  assign mem2A_adr = (wrIdx==2  & memWr ) ? wrAdr[5:0]  :
                     (rdIdx0==2 & memRd0) ? rdAdr0[5:0] :
                     (rdIdx1==2 & memRd1) ? rdAdr1[5:0] : 0;
  assign mem2B_adr = mem2A_adr;

  assign mem3A_adr = (wrIdx==3  & memWr ) ? wrAdr[5:0]  :
                     (rdIdx0==3 & memRd0) ? rdAdr0[5:0] :
                     (rdIdx1==3 & memRd1) ? rdAdr1[5:0] : 0;
  assign mem3B_adr = mem3A_adr;

  // --------------------------------------------------------------------------------------
  // Output ready lines
  assign memOut0A_or = memRd0D;
  assign memOut0B_or = memRd0D;
  assign memOut1A_or = memRd1D;
  assign memOut1B_or = memRd1D;

endmodule
//=========================================================================================

