//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   vitMain
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module vitMain(y, y_or, y_ff, y_we, 
               yIdx0, yIdx0_or, yIdx0_ff, yIdx0_we, 
               yIdx1, yIdx1_or, yIdx1_ff, yIdx1_we, 
               x, x_ir, x_fe, x_re, 
               irqDone, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yIdx0_w           = 0;
  parameter yIdx1_w           = 0;
  parameter x_w               = 0;

  parameter irqDone_w         = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter numBits_w         = 0;
  parameter numBits_r         = 0;
  parameter numBits_s         = 0;
  parameter R_numBits         = 0;
  parameter rxMode_w          = 0;
  parameter rxMode_r          = 0;
  parameter rxMode_s          = 0;
  parameter R_rxMode          = 0;
  parameter rxLen_w           = 0;
  parameter rxLen_r           = 0;
  parameter rxLen_s           = 0;
  parameter R_rxLen           = 0;
  parameter pm00_w            = 0;
  parameter pm00_r            = 0;
  parameter pm00_s            = 0;
  parameter R_pm00            = 0;

  parameter ws                = 0;
  parameter StPsduReset       = 0;
  parameter StPsduStart       = 0;
  parameter StPsduMid         = 0;
  parameter StPsduMax         = 0;
  parameter StPsduEnd         = 0;
  parameter StPsduWait        = 0;
  parameter StPsduDone        = 0;

  parameter cntIn_w           = 0;
  parameter cntIn_n           = 0;
  parameter cntIn_m           = 0;
  parameter stPsdu_w          = 0;
  parameter stPsdu_n          = 0;
  parameter stPsdu_m          = 0;
  parameter wrAdr_w           = 0;
  parameter wrAdr_n           = 0;
  parameter wrAdr_m           = 0;
  parameter rdAdr0_w          = 0;
  parameter rdAdr0_n          = 0;
  parameter rdAdr0_m          = 0;
  parameter rdAdr1_w          = 0;
  parameter rdAdr1_n          = 0;
  parameter rdAdr1_m          = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output        [yIdx0_w-1:0]  yIdx0;
  output                       yIdx0_or;
  input                        yIdx0_ff;
  output                       yIdx0_we;
  assign                       yIdx0_we = yIdx0_or & ~yIdx0_ff;

  output        [yIdx1_w-1:0]  yIdx1;
  output                       yIdx1_or;
  input                        yIdx1_ff;
  output                       yIdx1_we;
  assign                       yIdx1_we = yIdx1_or & ~yIdx1_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output      [irqDone_w-1:0]  irqDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;

  wire        [numBits_w-1:0]  numBits_q;
  wire        [numBits_w-1:0]  numBits_d;
  wire                         numBits_weint;
  assign                       numBits_weint = 0;

  wire         [rxMode_w-1:0]  rxMode_q;
  wire         [rxMode_w-1:0]  rxMode_d;
  wire                         rxMode_weint;

  wire          [rxLen_w-1:0]  rxLen_q;
  wire          [rxLen_w-1:0]  rxLen_d;
  wire                         rxLen_weint;

  wire           [pm00_w-1:0]  pm00_q;
  wire           [pm00_w-1:0]  pm00_d;
  wire                         pm00_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg numBits(numBits_q, regBus, numBits_d, numBits_weint, regWe, regRe, clk, reset);
  defparam numBits.w    = numBits_w;
  defparam numBits.rval = numBits_r;
  defparam numBits.sgn  = numBits_s;
  defparam numBits.adr  = R_numBits;

  ereg rxMode(rxMode_q, regBus, rxMode_d, rxMode_weint, regWe, regRe, clk, reset);
  defparam rxMode.w    = rxMode_w;
  defparam rxMode.rval = rxMode_r;
  defparam rxMode.sgn  = rxMode_s;
  defparam rxMode.adr  = R_rxMode;

  ereg rxLen(rxLen_q, regBus, rxLen_d, rxLen_weint, regWe, regRe, clk, reset);
  defparam rxLen.w    = rxLen_w;
  defparam rxLen.rval = rxLen_r;
  defparam rxLen.sgn  = rxLen_s;
  defparam rxLen.adr  = R_rxLen;

  ereg pm00(pm00_q, regBus, pm00_d, pm00_weint, regWe, regRe, clk, reset);
  defparam pm00.w    = pm00_w;
  defparam pm00.rval = pm00_r;
  defparam pm00.sgn  = pm00_s;
  defparam pm00.adr  = R_pm00;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg           [cntIn_w-1:0]  cntIn;
  reg          [stPsdu_w-1:0]  stPsdu;
  reg           [wrAdr_w-1:0]  wrAdr;
  reg          [rdAdr0_w-1:0]  rdAdr0;
  reg          [rdAdr1_w-1:0]  rdAdr1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "vitPm_0.v"
  `include "vitMem_0.v"
  `include "vitMax_0.v"
  `include "vitTbd_0.v"
  `include "vitTbd_1.v"
  `include "vitBrev_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = vitBrev_0_y;
  assign y_or                      = vitBrev_0_y_or;
  assign vitBrev_0_y_ff            = y_ff;

  assign vitMax_0_x00              = vitPm_0_pm00;
  assign vitMax_0_x01              = vitPm_0_pm01;
  assign vitMax_0_x02              = vitPm_0_pm02;
  assign vitMax_0_x03              = vitPm_0_pm03;
  assign vitMax_0_x04              = vitPm_0_pm04;
  assign vitMax_0_x05              = vitPm_0_pm05;
  assign vitMax_0_x06              = vitPm_0_pm06;
  assign vitMax_0_x07              = vitPm_0_pm07;
  assign vitMax_0_x08              = vitPm_0_pm08;
  assign vitMax_0_x09              = vitPm_0_pm09;
  assign vitMax_0_x10              = vitPm_0_pm10;
  assign vitMax_0_x11              = vitPm_0_pm11;
  assign vitMax_0_x12              = vitPm_0_pm12;
  assign vitMax_0_x13              = vitPm_0_pm13;
  assign vitMax_0_x14              = vitPm_0_pm14;
  assign vitMax_0_x15              = vitPm_0_pm15;
  assign vitMax_0_x16              = vitPm_0_pm16;
  assign vitMax_0_x17              = vitPm_0_pm17;
  assign vitMax_0_x18              = vitPm_0_pm18;
  assign vitMax_0_x19              = vitPm_0_pm19;
  assign vitMax_0_x20              = vitPm_0_pm20;
  assign vitMax_0_x21              = vitPm_0_pm21;
  assign vitMax_0_x22              = vitPm_0_pm22;
  assign vitMax_0_x23              = vitPm_0_pm23;
  assign vitMax_0_x24              = vitPm_0_pm24;
  assign vitMax_0_x25              = vitPm_0_pm25;
  assign vitMax_0_x26              = vitPm_0_pm26;
  assign vitMax_0_x27              = vitPm_0_pm27;
  assign vitMax_0_x28              = vitPm_0_pm28;
  assign vitMax_0_x29              = vitPm_0_pm29;
  assign vitMax_0_x30              = vitPm_0_pm30;
  assign vitMax_0_x31              = vitPm_0_pm31;
  assign vitMax_0_x32              = vitPm_0_pm32;
  assign vitMax_0_x33              = vitPm_0_pm33;
  assign vitMax_0_x34              = vitPm_0_pm34;
  assign vitMax_0_x35              = vitPm_0_pm35;
  assign vitMax_0_x36              = vitPm_0_pm36;
  assign vitMax_0_x37              = vitPm_0_pm37;
  assign vitMax_0_x38              = vitPm_0_pm38;
  assign vitMax_0_x39              = vitPm_0_pm39;
  assign vitMax_0_x40              = vitPm_0_pm40;
  assign vitMax_0_x41              = vitPm_0_pm41;
  assign vitMax_0_x42              = vitPm_0_pm42;
  assign vitMax_0_x43              = vitPm_0_pm43;
  assign vitMax_0_x44              = vitPm_0_pm44;
  assign vitMax_0_x45              = vitPm_0_pm45;
  assign vitMax_0_x46              = vitPm_0_pm46;
  assign vitMax_0_x47              = vitPm_0_pm47;
  assign vitMax_0_x48              = vitPm_0_pm48;
  assign vitMax_0_x49              = vitPm_0_pm49;
  assign vitMax_0_x50              = vitPm_0_pm50;
  assign vitMax_0_x51              = vitPm_0_pm51;
  assign vitMax_0_x52              = vitPm_0_pm52;
  assign vitMax_0_x53              = vitPm_0_pm53;
  assign vitMax_0_x54              = vitPm_0_pm54;
  assign vitMax_0_x55              = vitPm_0_pm55;
  assign vitMax_0_x56              = vitPm_0_pm56;
  assign vitMax_0_x57              = vitPm_0_pm57;
  assign vitMax_0_x58              = vitPm_0_pm58;
  assign vitMax_0_x59              = vitPm_0_pm59;
  assign vitMax_0_x60              = vitPm_0_pm60;
  assign vitMax_0_x61              = vitPm_0_pm61;
  assign vitMax_0_x62              = vitPm_0_pm62;
  assign vitMax_0_x63              = vitPm_0_pm63;
  assign yIdx0                     = vitTbd_0_yIdx;
  assign yIdx0_or                  = vitTbd_0_yIdx_or;
  assign vitTbd_0_yIdx_ff          = yIdx0_ff;

  assign yIdx1                     = vitTbd_1_yIdx;
  assign yIdx1_or                  = vitTbd_1_yIdx_or;
  assign vitTbd_1_yIdx_ff          = yIdx1_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | vitPm_0_regWe | vitMem_0_regWe | vitMax_0_regWe
                      | vitTbd_0_regWe | vitTbd_1_regWe | vitBrev_0_regWe;
  assign regReOut = 0 | vitPm_0_regRe | vitMem_0_regRe | vitMax_0_regRe
                      | vitTbd_0_regRe | vitTbd_1_regRe | vitBrev_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Define internal states
  parameter StTbd0Idle    = 0;
  parameter StTbd0Run     = 1;
  parameter StTbd0CfgEnd  = 2;
  parameter StTbd0RunEnd0 = 3;
  parameter StTbd0RunEnd1 = 4;
  parameter StTbd0Last    = 5;
  parameter StTbd0Done    = 6;

  parameter StTbd1Idle    = 0;
  parameter StTbd1Run     = 1;
  

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire           hdrErr;              // Indicate header parameter error
  wire           xInpEn;              // Enable input to pass data to Viterbi
  wire           xInpDmp;             // Dump input (for debugging)
  wire           x_reX;               // Real input read -> data passed to Viterbi
  reg            x_reXD;              // Delayed real input read
  reg     [7:0]  cntInUp;
  reg     [2:0]  stPsduD;
  reg     [2:0]  stTbd0, stTbd0D;
  reg     [1:0]  stTbd1, stTbd1D;
  reg     [3:0]  cntMax;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign xInpEn   = stPsdu==StPsduStart | stPsdu==StPsduMid | stPsdu==StPsduEnd;
  assign xInpDmp  = stPsdu==StPsduWait  | stPsdu==StPsduDone;
  assign x_ir     = xInpEn | xInpDmp;
  assign x_reX    = x_re & xInpEn;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      stPsdu  <= StPsduReset;
      stPsduD <= StPsduReset;
      stTbd0  <= StTbd0Idle;
      stTbd0D <= StTbd0Idle;
      stTbd1  <= StTbd1Idle;
      stTbd1D <= StTbd1Idle;
      cntIn   <= 0;
      cntInUp <= 0;
      wrAdr   <= 0;
      rdAdr0  <= 0;
      rdAdr1  <= 0;
      x_reXD  <= 0;
      cntMax  <= 0;
    end else 
    
    // -----------------------------------------------------
    // Normal decoding
    begin
      
      // Delayed read enable + states
      x_reXD  <= x_reX;
      stPsduD <= stPsdu;
      stTbd0D <= stTbd0;
      stTbd1D <= stTbd1;
      
      // -----------------------------------------
      // FSM for decoding
      if (stPsdu==StPsduReset) begin
        if (numBits_q<128) begin
          stPsdu <= StPsduEnd;
        end else begin  
          stPsdu <= StPsduStart;
        end
      end else
      
      if (stPsdu==StPsduStart & cntInUp[5:0]==63 & x_reX) begin
        stPsdu <= StPsduMid;
      end else
      
      if (stPsdu==StPsduMid & cntInUp[5:0]==63 & x_reX) begin
        stPsdu <= StPsduMax;
      end else
      
      if (stPsdu==StPsduMax) begin
        
        if (stPsduD==StPsduMid) begin
          cntMax <= 10;
        end else  
        if (cntMax!=0) begin
          cntMax <= cntMax-1;
        end
        
        if (cntMax==1) begin 
          if (cntIn[cntIn_w-1:6]!=0) begin
            stPsdu <= StPsduMid;
          end else begin
            stPsdu <= StPsduEnd;
          end
        end
      end else
      
      if (stPsdu==StPsduEnd & cntIn==0 & x_reX) begin
        stPsdu <= StPsduWait;
      end else
      
      if (stPsdu==StPsduWait & stTbd0==StTbd0Done) begin
        stPsdu <= StPsduDone;    
      end

      // -----------------------------------------
      // Trace back and decode FSM 0 
      if (stTbd0==StTbd0Idle) begin
        if (cntMax==2) begin
          stTbd0 <= StTbd0Run;
        end else
        if (stPsdu==StPsduWait) begin
          stTbd0 <= StTbd0CfgEnd;
        end
      end else
      
      if (stTbd0==StTbd0Run & rdAdr0[5:0]==0) begin
        stTbd0 <= StTbd0Idle;
      end else
      
      if (stTbd0==StTbd0CfgEnd) begin
        stTbd0 <= StTbd0RunEnd0;
      end else
      
      if (stTbd0==StTbd0RunEnd0 & rdAdr0[5:0]==0) begin
        if (numBits_q<64) begin
          stTbd0 <= StTbd0Last;
        end else begin
          stTbd0 <= StTbd0RunEnd1;
        end
      end else
      
      if (stTbd0D==StTbd0RunEnd1 & rdAdr0[5:0]==0) begin
        stTbd0 <= StTbd0Last;
      end else
      
      if (stTbd0==StTbd0Last) begin
        stTbd0 <= StTbd0Done;
      end
      
      if (stTbd0==StTbd0Done) begin
        stTbd0 <= StTbd0Idle;
      end
      
      // -----------------------------------------
      // Trace back and decode FSM 1 
      if (stTbd1==StTbd1Idle & stTbd0==StTbd0Run & rdAdr0[5:0]==0) begin
        stTbd1 <= StTbd1Run;
      end
      
      if (stTbd1==StTbd1Run & rdAdr1[5:0]==0) begin
        stTbd1 <= StTbd1Idle;
      end
      
      // -----------------------------------------
      // Input write address update
      if (x_reX) begin
        cntInUp <= cntInUp+1;
      end
      wrAdr <= cntInUp;
      
      // TBD 0 read address update
      if (stPsdu==StPsduReset) begin
        rdAdr0 <= 127;
      end else
      
      if (stTbd0==StTbd0Run) begin
        if (rdAdr0[5:0]!=0) begin
          rdAdr0 <= rdAdr0-1;
        end else begin
          rdAdr0 <= (rdAdr0-1)^128;
        end
      end else
      
      if (stTbd0==StTbd0CfgEnd) begin
        rdAdr0 <= numBits_q[7:0];
      end else
      
      if (stTbd0==StTbd0RunEnd0 | stTbd0==StTbd0RunEnd1) begin
        rdAdr0 <= rdAdr0-1;
      end
      
      // TBD 1 read address update
      if (stPsdu==StPsduReset) begin
        rdAdr1 <= 63;
      end else
      
      if (stTbd1==StTbd1Run) begin
        if (rdAdr1[5:0]!=0) begin
          rdAdr1 <= rdAdr1-1;
        end else begin
          rdAdr1 <= (rdAdr1-1)^128;
        end
      end

      // Input counter update
      if (stPsdu==StPsduReset) begin
        cntIn <= numBits_q;
      end else
      if (x_reX) begin
        cntIn <= cntIn-1;
      end
      
    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Connect control/input -> PM
  assign vitPm_0_run1       = run1_q!=0;
  assign vitPm_0_sb         = x;
  assign vitPm_0_sb_fe      = ~x_reX;
  
  // Connect MEM controls
  assign vitMem_0_wrAdr     = wrAdr;
  assign vitMem_0_wrAdr_fe  = ~x_reXD;
  assign vitMem_0_rdAdr0    = rdAdr0;
  assign vitMem_0_rdAdr0_fe = ~(stTbd0==StTbd0Run     | stTbd0==StTbd0RunEnd0 | 
                                stTbd0==StTbd0RunEnd1 | stTbd0==StTbd0Last);
  assign vitMem_0_rdAdr1    = rdAdr1;
  assign vitMem_0_rdAdr1_fe = ~(stTbd1==StTbd1Run);
  
  // Connect PM -> MEM
  assign vitMem_0_memInA    = vitPm_0_selA;
  assign vitMem_0_memInB    = vitPm_0_selB;
  
  // Connect MAX controls
  assign vitMax_0_run1      = cntMax!=0;
 
  // Connect TBD0 controls and mem
  assign vitTbd_0_startIdx  = stTbd0==StTbd0Run ? vitMax_0_xIdx : 0;
  assign vitTbd_0_run1      = stTbd0D==StTbd0Run     | stTbd0D==StTbd0RunEnd0 | 
                              stTbd0D==StTbd0RunEnd1 | stTbd0==StTbd0Last;
  assign vitTbd_0_selA      = vitMem_0_memOut0A;
  assign vitTbd_0_selB      = vitMem_0_memOut0B;

  // Connect TBD1 controls and mem
  assign vitTbd_1_startIdx  = vitTbd_0_endIdx;
  assign vitTbd_1_run1      = stTbd1D==StTbd1Run;
  assign vitTbd_1_selA      = vitMem_0_memOut1A;
  assign vitTbd_1_selB      = vitMem_0_memOut1B;

  // Connect BREV controls
  assign vitBrev_0_run1     = run1_q;
  assign vitBrev_0_numIn0   = {|numBits_q[numBits_w-1:6], numBits_q[5:0]};
  assign vitBrev_0_x0       = vitTbd_0_b;
  assign vitBrev_0_x0_fe    = ~(vitTbd_0_b_or & 
                               (stTbd0D==StTbd0RunEnd0 | stTbd0D==StTbd0RunEnd1 | 
                                stTbd0D==StTbd0Last));
  assign vitBrev_0_x1       = vitTbd_1_b;
  assign vitBrev_0_x1_fe    = ~vitTbd_1_b_or;

  // Assign header data output, check for error
  assign hdrErr = vitBrev_0_yHdr[   4]==1   |   // Reserved bit = 1
                  vitBrev_0_yHdr[   3]==0   |   // Mode MSB     = 0
                 ^vitBrev_0_yHdr      ==1;      // Parity error
  
  assign rxLen_d            = hdrErr ? 0 : vitBrev_0_yHdr[16:5];
  assign rxMode_d           = vitBrev_0_yHdr[2:0];
  assign rxLen_weint        = vitBrev_0_yHdr_or;
  assign rxMode_weint       = vitBrev_0_yHdr_or;

  // Get last metric of path 0, only for header
  assign pm00_d             = vitPm_0_pm00x9;
  assign pm00_weint         = x_reXD & run1_q==1;

  // Pass through IRQ from vitBrev
  assign irqDone            = vitBrev_0_irqDone;

  // Reset global run - currently only after header decoding
  assign run1_d             = 0;
  assign run1_weint         = rxLen_weint;

endmodule
//=========================================================================================

