//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   vitAcs
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module vitAcs(sel, sel_or, sel_ff, sel_we, 
              pmOut, pmOut_or, pmOut_ff, pmOut_we, 
              sb, sb_ir, sb_fe, sb_re, 
              pmIn0, pmIn0_ir, pmIn0_fe, pmIn0_re, 
              pmIn1, pmIn1_ir, pmIn1_fe, pmIn1_re, 
              run1, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter sel_w             = 0;
  parameter pmOut_w           = 0;
  parameter sb_w              = 0;
  parameter pmIn0_w           = 0;
  parameter pmIn1_w           = 0;

  parameter run1_w            = 0;

  parameter i0                = 0;
  parameter i1                = 0;
  parameter pbrv              = 0;
  parameter ws                = 0;
  parameter wp                = 0;

  parameter pmBuf_w           = 0;
  parameter pmBuf_n           = 0;
  parameter pmBuf_m           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [sel_w-1:0]  sel;
  output                       sel_or;
  input                        sel_ff;
  output                       sel_we;
  assign                       sel_we = sel_or & ~sel_ff;

  output        [pmOut_w-1:0]  pmOut;
  output                       pmOut_or;
  input                        pmOut_ff;
  output                       pmOut_we;
  assign                       pmOut_we = pmOut_or & ~pmOut_ff;

  input            [sb_w-1:0]  sb;
  output                       sb_ir;
  input                        sb_fe;
  output                       sb_re;
  assign                       sb_re = sb_ir & ~sb_fe;

  input         [pmIn0_w-1:0]  pmIn0;
  output                       pmIn0_ir;
  input                        pmIn0_fe;
  output                       pmIn0_re;
  assign                       pmIn0_re = pmIn0_ir & ~pmIn0_fe;

  input         [pmIn1_w-1:0]  pmIn1;
  output                       pmIn1_ir;
  input                        pmIn1_fe;
  output                       pmIn1_re;
  assign                       pmIn1_re = pmIn1_ir & ~pmIn1_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg           [pmBuf_w-1:0]  pmBuf;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg       [ws:0]  sb0, sb1, add;
  reg     [wp-1:0]  pmBuf_nxt;
  reg     [wp-1:0]  pmAdd0, pmAdd1, cmp;
  reg               selR;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign sb_ir    = 1;
  assign pmIn0_ir = 1;
  assign pmIn1_ir = 1;

  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Select the 2 soft bits of the input, extend 1 bit
    sb0     = {sb[  ws-1], sb[  ws-1: 0]};
    sb1     = {sb[2*ws-1], sb[2*ws-1:ws]};
    
    // Calculate current path metric, add to previous (in ACS mode)
    add     = (i0 ? sb0 : -sb0) + (i1 ? sb1 : -sb1);
    pmAdd0  = pmIn0 + {{wp-ws-1{add[ws]}}, add};
    pmAdd1  = pmIn1 - {{wp-ws-1{add[ws]}}, add};

    // Select maximum
    cmp = pmAdd0 - pmAdd1;
    if (cmp[wp-1]==0) begin
      pmBuf_nxt = pmAdd0;
    end else begin
      pmBuf_nxt = pmAdd1;
    end
      
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      pmBuf     <= pbrv;
      selR      <= 0;
      
    // Normal operation
    end else begin
      
      // Update path metric buffer
      if (sb_re) begin
        pmBuf <= pmBuf_nxt;
      end 
            
      // Selection bit output
      selR  <= cmp[wp-1];

    end // if (run1_q==0) ... else
  end // always

  // Output selector
  assign sel    = selR;
  assign pmOut  = pmBuf;

endmodule
//=========================================================================================

