//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ttCordic
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ttCordic(y, y_or, y_ff, y_we, 
                x, x_ir, x_fe, x_re, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter ph_w              = 0;
  parameter ph_r              = 0;
  parameter ph_s              = 0;
  parameter R_ph              = 0;
  parameter dph3_w            = 0;
  parameter dph3_r            = 0;
  parameter dph3_s            = 0;
  parameter R_dph3            = 0;
  parameter dph4_w            = 0;
  parameter dph4_r            = 0;
  parameter dph4_s            = 0;
  parameter R_dph4            = 0;
  parameter dphM49_w          = 0;
  parameter dphM49_r          = 0;
  parameter dphM49_s          = 0;
  parameter R_dphM49          = 0;
  parameter dph14_w           = 0;
  parameter dph14_r           = 0;
  parameter dph14_s           = 0;
  parameter R_dph14           = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;

  wire             [ph_w-1:0]  ph_q;
  wire             [ph_w-1:0]  ph_d;
  wire                         ph_weint;

  wire           [dph3_w-1:0]  dph3_q;
  wire           [dph3_w-1:0]  dph3_d;
  wire                         dph3_weint;
  assign                       dph3_weint = 0;

  wire           [dph4_w-1:0]  dph4_q;
  wire           [dph4_w-1:0]  dph4_d;
  wire                         dph4_weint;
  assign                       dph4_weint = 0;

  wire         [dphM49_w-1:0]  dphM49_q;
  wire         [dphM49_w-1:0]  dphM49_d;
  wire                         dphM49_weint;
  assign                       dphM49_weint = 0;

  wire          [dph14_w-1:0]  dph14_q;
  wire          [dph14_w-1:0]  dph14_d;
  wire                         dph14_weint;
  assign                       dph14_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg ph(ph_q, regBus, ph_d, ph_weint, regWe, regRe, clk, reset);
  defparam ph.w    = ph_w;
  defparam ph.rval = ph_r;
  defparam ph.sgn  = ph_s;
  defparam ph.adr  = R_ph;

  ereg dph3(dph3_q, regBus, dph3_d, dph3_weint, regWe, regRe, clk, reset);
  defparam dph3.w    = dph3_w;
  defparam dph3.rval = dph3_r;
  defparam dph3.sgn  = dph3_s;
  defparam dph3.adr  = R_dph3;

  ereg dph4(dph4_q, regBus, dph4_d, dph4_weint, regWe, regRe, clk, reset);
  defparam dph4.w    = dph4_w;
  defparam dph4.rval = dph4_r;
  defparam dph4.sgn  = dph4_s;
  defparam dph4.adr  = R_dph4;

  ereg dphM49(dphM49_q, regBus, dphM49_d, dphM49_weint, regWe, regRe, clk, reset);
  defparam dphM49.w    = dphM49_w;
  defparam dphM49.rval = dphM49_r;
  defparam dphM49.sgn  = dphM49_s;
  defparam dphM49.adr  = R_dphM49;

  ereg dph14(dph14_q, regBus, dph14_d, dph14_weint, regWe, regRe, clk, reset);
  defparam dph14.w    = dph14_w;
  defparam dph14.rval = dph14_r;
  defparam dph14.sgn  = dph14_s;
  defparam dph14.adr  = R_dph14;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "cordicRotCore_0x14.v"
  `include "cordicRotCore_1x14.v"
  `include "cordicRotCore_2x14.v"
  `include "cordicRotCore_3x14.v"
  `include "cordicRotCore_4x14.v"
  `include "cordicRotCore_5x14.v"
  `include "cordicRotCore_6x14.v"
  `include "cordicRotCore_7x14.v"
  `include "cordicRotCore_8x14.v"
  `include "cordicRotCore_9x14.v"
  `include "buf2_22.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_22_y;
  assign y_or                      = buf2_22_y_or;
  assign buf2_22_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | cordicRotCore_0x14_regWe | cordicRotCore_1x14_regWe | cordicRotCore_2x14_regWe
                      | cordicRotCore_3x14_regWe | cordicRotCore_4x14_regWe | cordicRotCore_5x14_regWe
                      | cordicRotCore_6x14_regWe | cordicRotCore_7x14_regWe | cordicRotCore_8x14_regWe
                      | cordicRotCore_9x14_regWe | buf2_22_regWe;
  assign regReOut = 0 | cordicRotCore_0x14_regRe | cordicRotCore_1x14_regRe | cordicRotCore_2x14_regRe
                      | cordicRotCore_3x14_regRe | cordicRotCore_4x14_regRe | cordicRotCore_5x14_regRe
                      | cordicRotCore_6x14_regRe | cordicRotCore_7x14_regRe | cordicRotCore_8x14_regRe
                      | cordicRotCore_9x14_regRe | buf2_22_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Define some parameters from included files
  parameter wp = cordicRotCore_0x14_wp;

  // --------------------------------------------------------------------------------------
  // Register  + wire definitions
  wire      [wx:0]  xRe,    xIm, 
                    xReOut, xImOut;
  wire    [wy-1:0]  xReSat, xImSat,
                    yRe,    yIm;
  reg        [5:0]  cnt, cntOut;
  reg        [2:0]  x_reD;
  reg       [wx:0]  xRe1, xIm1, xRe4, xIm4, xRe7, xIm7;
  reg     [wp-1:0]  ph1, ph4, ph7;
  reg       [15:0]  phUpdate;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir = ((run1_q==1 && cnt[5:2]==0) || (run1_q==2 && cnt[5:4]!=3)) && buf2_22_x_ir;
  
  // Change to mode 1 at the end of reception of all data carriers
  assign run1_d     = 0;
  assign run1_weint = ((cntOut==3 && run1_q==1) || (cntOut==47 && run1_q==2)) && y_we;

  // --------------------------------------------------------------------------------------
  // Define phase update table
  always @(*) begin
    case ({run1_q, cnt})  
                                    // c(-21), init
        64: phUpdate = dph14_q;     // c(-07)
        65: phUpdate = dph14_q;     // c(+07)
        66: phUpdate = dph14_q;     // c(+21)
                                    // c(-26), init
       128: phUpdate = dph3_q;      // c(-23)
       129: phUpdate = dph4_q;      // c(-19)
       130: phUpdate = dph3_q;      // c(-16)
       131: phUpdate = dph3_q;      // c(-13)
       132: phUpdate = dph3_q;      // c(-10)
       133: phUpdate = dph4_q;      // c(-06)
       134: phUpdate = dph3_q;      // c(-03)
       135: phUpdate = dph4_q;      // c(+01)
       136: phUpdate = dph3_q;      // c(+04)
       137: phUpdate = dph4_q;      // c(+08)
       138: phUpdate = dph3_q;      // c(+11)
       139: phUpdate = dph3_q;      // c(+14)
       140: phUpdate = dph3_q;      // c(+17)
       141: phUpdate = dph3_q;      // c(+20)
       142: phUpdate = dph4_q;      // c(+24)
       143: phUpdate = dphM49_q;    // c(-25)
       144: phUpdate = dph3_q;      // c(-22)
       145: phUpdate = dph4_q;      // c(-18)
       146: phUpdate = dph3_q;      // c(-15)
       147: phUpdate = dph3_q;      // c(-12)
       148: phUpdate = dph3_q;      // c(-09)
       149: phUpdate = dph4_q;      // c(-05)
       150: phUpdate = dph3_q;      // c(-02)
       151: phUpdate = dph4_q;      // c(+02)
       152: phUpdate = dph3_q;      // c(+05)
       153: phUpdate = dph4_q;      // c(+09)
       154: phUpdate = dph3_q;      // c(+12)
       155: phUpdate = dph3_q;      // c(+15)
       156: phUpdate = dph3_q;      // c(+18)
       157: phUpdate = dph4_q;      // c(+22)
       158: phUpdate = dph3_q;      // c(+25)
       159: phUpdate = dphM49_q;    // c(-24)
       160: phUpdate = dph4_q;      // c(-20)
       161: phUpdate = dph3_q;      // c(-17)
       162: phUpdate = dph3_q;      // c(-14)
       163: phUpdate = dph3_q;      // c(-11)
       164: phUpdate = dph3_q;      // c(-08)
       165: phUpdate = dph4_q;      // c(-04)
       166: phUpdate = dph3_q;      // c(-01)
       167: phUpdate = dph4_q;      // c(+03)
       168: phUpdate = dph3_q;      // c(+06)
       169: phUpdate = dph4_q;      // c(+10)
       170: phUpdate = dph3_q;      // c(+13)
       171: phUpdate = dph3_q;      // c(+16)
       172: phUpdate = dph3_q;      // c(+19)
       173: phUpdate = dph4_q;      // c(+23)
       174: phUpdate = dph3_q;      // c(+26)
      default: phUpdate = 0;
    endcase
  end
 
  // --------------------------------------------------------------------------------------
  // Calculate next phase + update external register
  assign ph_d      = ph_q + phUpdate;
  assign ph_weint  = x_re;

  // --------------------------------------------------------------------------------------
  // Signal processing behaviour

  // Sign extension of input, split into real/imag
  assign xRe = {x[  wx-1], x[  wx-1: 0]};
  assign xIm = {x[2*wx-1], x[2*wx-1:wx]};
  
  // Cordic iterations on wx+1 bit
  assign cordicRotCore_0x14_xReIn = xRe;
  assign cordicRotCore_0x14_xImIn = xIm;
  assign cordicRotCore_0x14_phIn  = ph_q[ph_w-1:6];

  assign cordicRotCore_1x14_xReIn = cordicRotCore_0x14_xReOut;
  assign cordicRotCore_1x14_xImIn = cordicRotCore_0x14_xImOut;
  assign cordicRotCore_1x14_phIn  = cordicRotCore_0x14_phOut;

  assign cordicRotCore_2x14_xReIn = xRe1;
  assign cordicRotCore_2x14_xImIn = xIm1;
  assign cordicRotCore_2x14_phIn  = ph1;

//  assign cordicRotCore_2x14_xReIn = cordicRotCore_1x14_xReOut;
//  assign cordicRotCore_2x14_xImIn = cordicRotCore_1x14_xImOut;
//  assign cordicRotCore_2x14_phIn  = cordicRotCore_1x14_phOut;

  assign cordicRotCore_3x14_xReIn = cordicRotCore_2x14_xReOut;
  assign cordicRotCore_3x14_xImIn = cordicRotCore_2x14_xImOut;
  assign cordicRotCore_3x14_phIn  = cordicRotCore_2x14_phOut;

  assign cordicRotCore_4x14_xReIn = cordicRotCore_3x14_xReOut;
  assign cordicRotCore_4x14_xImIn = cordicRotCore_3x14_xImOut;
  assign cordicRotCore_4x14_phIn  = cordicRotCore_3x14_phOut;

  assign cordicRotCore_5x14_xReIn = xRe4;
  assign cordicRotCore_5x14_xImIn = xIm4;
  assign cordicRotCore_5x14_phIn  = ph4;

//  assign cordicRotCore_5x14_xReIn = cordicRotCore_4x14_xReOut;
//  assign cordicRotCore_5x14_xImIn = cordicRotCore_4x14_xImOut;
//  assign cordicRotCore_5x14_phIn  = cordicRotCore_4x14_phOut;

  assign cordicRotCore_6x14_xReIn = cordicRotCore_5x14_xReOut;
  assign cordicRotCore_6x14_xImIn = cordicRotCore_5x14_xImOut;
  assign cordicRotCore_6x14_phIn  = cordicRotCore_5x14_phOut;

  assign cordicRotCore_7x14_xReIn = cordicRotCore_6x14_xReOut;
  assign cordicRotCore_7x14_xImIn = cordicRotCore_6x14_xImOut;
  assign cordicRotCore_7x14_phIn  = cordicRotCore_6x14_phOut;

  assign cordicRotCore_8x14_xReIn = xRe7;
  assign cordicRotCore_8x14_xImIn = xIm7;
  assign cordicRotCore_8x14_phIn  = ph7;

//  assign cordicRotCore_8x14_xReIn = cordicRotCore_7x14_xReOut;
//  assign cordicRotCore_8x14_xImIn = cordicRotCore_7x14_xImOut;
//  assign cordicRotCore_8x14_phIn  = cordicRotCore_7x14_phOut;

  assign cordicRotCore_9x14_xReIn = cordicRotCore_8x14_xReOut;
  assign cordicRotCore_9x14_xImIn = cordicRotCore_8x14_xImOut;
  assign cordicRotCore_9x14_phIn  = cordicRotCore_8x14_phOut;

  // Shift >>2, symmetric saturation 12->11 bit...
  assign xReOut = cordicRotCore_9x14_xReOut; // Use abbreviation
  assign xImOut = cordicRotCore_9x14_xImOut;

  sat sat_re(xReSat, xReOut[wx:2]);
  defparam sat_re.x_w = wx+1-2;
  defparam sat_re.y_w = wy;
  
  sat sat_im(xImSat, xImOut[wx:2]);
  defparam sat_im.x_w = wx+1-2;
  defparam sat_im.y_w = wy;

  // Scale, multiply by 1-2^(-6)
  assign yRe  = xReSat - {{6{xReSat[wy-1]}}, xReSat[wy-1:6]};
  assign yIm  = xImSat - {{6{xImSat[wy-1]}}, xImSat[wy-1:6]};

  // Connect output FIFO buffer
  assign  buf2_22_run1  = run1_q!=0;
//  assign  buf2_22_x_fe  = ~x_re; //~x_reD[2];
  assign  buf2_22_x_fe  = ~x_reD[2];
  assign  buf2_22_x     = {yIm, yRe};

  // Buf2 -> output y
  // => automatically via Matlab generation

  // --------------------------------------------------------------------------------------
  // FSM - count carriers
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      cnt     <= 0;
      cntOut  <= 0;
      x_reD   <= 0;
      
    // Normal operation
    end else begin
      
      // Count up input
      if (x_re) begin
        cnt <= cnt+1;
      end

      // Count up output
      if (y_we) begin
        cntOut <= cntOut+1;
      end

      // Run FSM only if output buffer FIFO accepts data
      if (buf2_22_x_ir) begin
        
        // Delay input read enable
        x_reD <= {x_reD[1:0], x_re};
        
        // Delayed values
        xRe1  <= cordicRotCore_1x14_xReOut;
        xRe4  <= cordicRotCore_4x14_xReOut;
        xRe7  <= cordicRotCore_7x14_xReOut;
                          
        xIm1  <= cordicRotCore_1x14_xImOut;
        xIm4  <= cordicRotCore_4x14_xImOut;
        xIm7  <= cordicRotCore_7x14_xImOut;
        
        ph1   <= cordicRotCore_1x14_phOut;
        ph4   <= cordicRotCore_4x14_phOut;
        ph7   <= cordicRotCore_7x14_phOut;
      
      end // if (buf2_22_x_ir) begin
      
    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

