//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssDiv
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssDiv(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             amp, amp_ir, amp_fe, amp_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;
  parameter amp_w             = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wa                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input           [amp_w-1:0]  amp;
  output                       amp_ir;
  input                        amp_fe;
  output                       amp_re;
  assign                       amp_re = amp_ir & ~amp_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  //-----------------------------------------------------------------------------------------
  // Registers definitions
  reg       [wx:0]  nRe, nRe_nxt, nIm, nIm_nxt;
  reg               sRe, sRe_nxt, sIm, sIm_nxt;
  reg     [wa-1:0]  d, d_nxt;
  reg     [wa+1:0]  mRe, mRe_nxt, mIm, mIm_nxt;
  reg     [wy-2:0]  qRe, qRe_nxt, qIm, qIm_nxt;
  reg     [wy-1:0]  yRe, yRe_nxt, yIm, yIm_nxt;
  reg        [1:0]  yOr;
  reg        [5:0]  cnt;
  
  reg     [wx-1:0]  xRe, xIm;
  reg     [wx-2:0]  xAbsRe, xAbsIm;
  reg               xSgnRe, xSgnIm;    
  
  // --------------------------------------------------------------------------
  // Assign input and output enable
  assign amp_ir = run1 & cnt==0;
  assign x_ir   = run1 & ((cnt[1:0]==0 & cnt[5:2]!=0) | amp_re);

  assign y_or   = yOr[0];
  assign y      = {yIm, yRe};
  
  // --------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Abs of input values
    xRe    = x[  wx-1: 0];
    xIm    = x[2*wx-1:wx];
    xSgnRe = xRe[wx-1];
    xSgnIm = xIm[wx-1];
    xAbsRe = xSgnRe ? -xRe[wx-2:0] : xRe[wx-2:0];
    xAbsIm = xSgnIm ? -xIm[wx-2:0] : xIm[wx-2:0];
    
    // Capture amplitude input
    if (amp_re) begin
      d_nxt = amp;
    end else begin
      d_nxt = d;
    end
    
    // Define subtraction
    mRe = {1'b0, nRe[wx:1]} - {2'b00, d};
    mIm = {1'b0, nIm[wx:1]} - {2'b00, d};
  
    // Define update of n
    if (cnt[1:0]==0) begin
      nRe_nxt = {2'b00, xAbsRe};
      nIm_nxt = {2'b00, xAbsIm};
      sRe_nxt = xSgnRe;
      sIm_nxt = xSgnIm;
    end else begin
      nRe_nxt = mRe[wa+1] ? nRe<<1 : {mRe[wa]|mRe[wa-1], mRe[wa-2:0], nRe[0], 1'b0};
      nIm_nxt = mIm[wa+1] ? nIm<<1 : {mIm[wa]|mIm[wa-1], mIm[wa-2:0], nIm[0], 1'b0};
      sRe_nxt = sRe;
      sIm_nxt = sIm;
    end
    
    // Define update of q
    qRe_nxt = {qRe[wy-3:0], ~mRe[wa+1]};
    qIm_nxt = {qIm[wy-3:0], ~mIm[wa+1]};
    
    // Define y
    yRe_nxt = sRe ? -{1'b0, qRe_nxt} : {1'b0, qRe_nxt}; 
    yIm_nxt = sIm ? -{1'b0, qIm_nxt} : {1'b0, qIm_nxt}; 
    
  end

  
  // --------------------------------------------------------------------------
  // Input FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt  <= 0;
      yOr  <= 0;
     
    // Normal operation
    end else begin
      
      // State counter, 0..63
      if (amp_re | cnt!=0) begin
        cnt <= cnt+1;
      end
      
      // Update internal registers
      d   <= d_nxt;
      nRe <= nRe_nxt; nIm <= nIm_nxt;
      sRe <= sRe_nxt; sIm <= sIm_nxt;
      qRe <= qRe_nxt; qIm <= qIm_nxt;
      yRe <= yRe_nxt; yIm <= yIm_nxt;
      
      // Delayed output enable
      yOr <= {cnt[1:0]==3, yOr[1]};
      
    end // if (run1==0) ... else
  end // always

endmodule
//=========================================================================================

