//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssCcfAddOut
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssCcfAddOut(y, y_or, y_ff, y_we, 
                   xA, xA_ir, xA_fe, xA_re, 
                   xB, xB_ir, xB_fe, xB_re, 
                   run1, 
                   regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter xA_w              = 0;
  parameter xB_w              = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter sh                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input            [xA_w-1:0]  xA;
  output                       xA_ir;
  input                        xA_fe;
  output                       xA_re;
  assign                       xA_re = xA_ir & ~xA_fe;

  input            [xB_w-1:0]  xB;
  output                       xB_ir;
  input                        xB_fe;
  output                       xB_re;
  assign                       xB_re = xB_ir & ~xB_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [wx-1:0]  xAD1, xBD1, xBD2;
  reg     [wx-1:0]  addIn0, addIn1, addIn1x, addAbs;
  reg       [wx:0]  addOut;
  reg       [wy:0]  yRe, yIm, yReBuf, addAbsSh;  // One bit more internally
  reg        [1:0]  cntIn, cntOut;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xA_ir = run1;
  assign xB_ir = run1;
  assign y_or = cntOut==1 | cntOut==3;
  assign y    = {yIm[wy-1:0], yRe[wy-1:0]};     // Reduce output bit width
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin

    // Define adder inputs
    if (cntIn==1 | cntIn==3) begin
      addIn0  = xAD1;
      addIn1x = xA;
    end else begin
      addIn0  = xBD2;
      addIn1x = xBD1;
    end
    
    // Invert input or not
    if (cntIn==1 | cntIn==2) begin
      addIn1 = -addIn1x;
    end else begin
      addIn1 = addIn1x;
    end
    
    // Define adder
    addOut = {addIn0[wx-1], addIn0} + {addIn1[wx-1], addIn1};
    
    // Define abs of adder output
    if (addOut[wx]==0) begin
      addAbs = addOut[wx-1:0];
    end else begin
      addAbs = -addOut[wx-1:0];
    end
    
    // Shift output >> sh
    addAbsSh = addAbs[wx-1:sh];
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntIn   <= 0;
      cntOut  <= 0;
      
    // Normal operation
    end else begin
      
      // Processing counters
      if (xA_re) begin
        cntIn <= cntIn+1;
      end    
      if (cntIn==3 | cntOut!=0) begin
        cntOut <= cntOut+1;
      end
      
      // Buffer input data
      xAD1 <= xA;
      xBD1 <= xB;
      xBD2 <= xBD1;

      // Update output registers
      if (cntIn==1) begin
        yReBuf <= addAbsSh;
      end else
      if (cntIn==2) begin
        yRe    <= yReBuf;
        yReBuf <= addAbsSh;
      end else
      if (cntIn==3) begin
        yIm <= addAbsSh;
      end else
      if (cntOut==1) begin
        yRe <= yReBuf;
        yIm <= addAbsSh;
      end

    end // if (run1==0) ... else
  end // always

endmodule
//=========================================================================================

