//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssCcfAddIn
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssCcfAddIn(y, y_or, y_ff, y_we, 
                  x, x_ir, x_fe, x_re, 
                  run1, 
                  regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;

  parameter xD_w              = 0;
  parameter xD_n              = 0;
  parameter xD_m              = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [xD_w-1:0]  xD[xD_n-1:0];

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg        [1:0]  cntIn;
  reg               cntOut;
  reg   [2*wx-1:0]  xC;
  reg     [wx-1:0]  x0Re, x0Im, x8Re, x8Im, x8MRe, x8MIm;
  reg     [wx-1:0]  addIn0, addIn1;
  reg       [wx:0]  addOut, yR;
    
  integer k;
  
  wire    [2*wx-1:0] xD0;
  assign  xD0 = xD[0];
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1 & cntIn==0;
  assign y_or = cntIn!=0 | cntOut==1;
  assign y    = yR;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Input to +/-
    x8Re = xD0[  wx-1: 0];
    x8Im = xD0[2*wx-1:wx];
    if (x_re) begin
      x0Re = x[wx-1:0];
    end else begin
      x0Re = xC[wx-1:0];
    end  
    x0Im = xC[2*wx-1:wx];
    
    // Negate x8
    x8MRe = -x8Re;
    x8MIm = -x8Im;
    
    // Adder input multiplexing
    case (cntIn)
      0: addIn0 = x0Re;
      1: addIn0 = x0Im;
      2: addIn0 = x0Im;
      3: addIn0 = x0Re;
    endcase
    case (cntIn)
      0: addIn1 = x8Re;
      1: addIn1 = x8MIm;
      2: addIn1 = x8Im;
      3: addIn1 = x8MRe;
    endcase
    
    // Adder definition
    addOut = {addIn0[wx-1], addIn0} + {addIn1[wx-1], addIn1};
    
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntIn   <= 0;
      cntOut  <= 0;
      for (k=0; k<xD_n; k=k+1) begin
        xD[k] <= 0;
      end
 
    // Normal operation
    end else begin

      // Shift input data into delay chain
      if (x_re) begin
        xC <= x;
      end
      if (cntIn==3) begin
        for (k=0; k<xD_n-1; k=k+1) begin
          xD[k] <= xD[k+1];
        end
        xD[7] <= xC;
      end
      
      // Increase counter, cntIn 0..3 starting with x_re
      if (x_re | cntIn!=0) begin
        cntIn <= cntIn+1;
      end
      cntOut <= cntIn==3;

      // Register adder output
      yR <= addOut;

    end // if (run1==0) ... else
  end // always

endmodule
//=========================================================================================

