//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssCcfAbs
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssCcfAbs(y, y_or, y_ff, y_we, 
                x, x_ir, x_fe, x_re, 
                run1, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg       [wx:0]  xRe, xIm;
  
  reg       [wx:0]  xRe0, xIm0, xRe0_nxt, xIm0_nxt;
  reg       [wx:0]  xIn0Re0, xIn0Re1, xIn0Im0, xIn0Im1;
  reg       [wx:0]  xRe0Add, xIm0Sub, xIm0SubAbs;
  
  reg       [wx:0]  xRe1, xIm1, xRe1_nxt, xIm1_nxt;
  reg       [wx:0]  xIn1Re0, xIn1Re1, xIn1Im0, xIn1Im1;
  reg       [wx:0]  xRe1Add, xIm1Sub, xIm1SubAbs;
  
  reg     [wy-1:0]  ySat, ySat_nxt;
  
  reg        [1:0]  cnt0, cnt1;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1 & cnt0!=1;
  assign y_or = cnt1==2;
  assign y    = ySat;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Abs of input values -> change this, use only one muxer
    xRe    = {1'b0, x[  wx-1: 0]};
    xIm    = {1'b0, x[2*wx-1:wx]};
    
    // Input multiplexor for stage 0
    if (cnt0!=1) begin
      xIn0Re0 = xRe;
      xIn0Re1 = xIm;
      xIn0Im0 = xIm;
      xIn0Im1 = xRe;
    end else begin
      xIn0Re0 = xRe0;
      xIn0Re1 = xIm0>>1;
      xIn0Im0 = xIm0;
      xIn0Im1 = xRe0>>1;
    end
    
    // Addition/subtraction for stage 0
    xRe0Add = xIn0Re0 + xIn0Re1;
    xIm0Sub = xIn0Im0 - xIn0Im1;
    if (xIm0Sub[wx]==1) begin
      xIm0SubAbs = -xIm0Sub;
    end else begin
      xIm0SubAbs = xIm0Sub;
    end
    
    // Define update for stage 0
    xRe0_nxt = xRe0Add;
    xIm0_nxt = xIm0SubAbs;
    
    // Input multiplexor for stage 1
    if (cnt1!=1) begin
      xIn1Re0 = xRe0;
      xIn1Re1 = xIm0>>2;
      xIn1Im0 = xIm0;
      xIn1Im1 = xRe0>>2;
    end else begin
      xIn1Re0 = xRe1;
      xIn1Re1 = xIm1>>3;
      xIn1Im0 = xIm1;
      xIn1Im1 = xRe1>>3;
    end
    
    // Addition/subtraction for stage 1
    xRe1Add = xIn1Re0 + xIn1Re1;
    xIm1Sub = xIn1Im0 - xIn1Im1;
    if (xIm1Sub[wx]==1) begin
      xIm1SubAbs = -xIm1Sub;
    end else begin
      xIm1SubAbs = xIm1Sub;
    end
    
    // Define update for stage 1,include saturation
    xRe1_nxt = xRe1Add;
    xIm1_nxt = xIm1SubAbs;
    ySat_nxt = xRe1Add[wx]==0 ? xRe1Add>>2 : -1;
        
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt0 <= 0;
      cnt1 <= 0;
      
    // Normal operation
    end else begin
      
      // Counter for 1st stage
      if (x_re) begin
        cnt0 <= 1;
      end else begin
        cnt0 <= cnt0<<1;
      end

      // Counter for 2nd stage
      if (cnt0==2) begin
        cnt1 <= 1;
      end else begin
        cnt1 <= cnt1<<1;
      end
      
      // Update internal registers
      xRe0 <= xRe0_nxt;
      xIm0 <= xIm0_nxt;
      xRe1 <= xRe1_nxt;
      xIm1 <= xIm1_nxt;
      ySat <= ySat_nxt;
      
    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

