//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssCcf
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssCcf(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "ssCcfAddIn_0.v"
  `include "filt8x2x2_0.v"
  `include "ssCcfAddOut_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign ssCcfAddIn_0_x            = x;
  assign ssCcfAddIn_0_x_fe         = x_fe;
  assign x_ir                      = ssCcfAddIn_0_x_ir;

  assign filt8x2x2_0_x             = ssCcfAddIn_0_y;
  assign filt8x2x2_0_x_fe          = ~ssCcfAddIn_0_y_or;
  assign ssCcfAddIn_0_y_ff         = ~filt8x2x2_0_x_ir;

  assign ssCcfAddOut_0_xA          = filt8x2x2_0_yA;
  assign ssCcfAddOut_0_xA_fe       = ~filt8x2x2_0_yA_or;
  assign filt8x2x2_0_yA_ff         = ~ssCcfAddOut_0_xA_ir;

  assign ssCcfAddOut_0_xB          = filt8x2x2_0_yB;
  assign ssCcfAddOut_0_xB_fe       = ~filt8x2x2_0_yB_or;
  assign filt8x2x2_0_yB_ff         = ~ssCcfAddOut_0_xB_ir;

  assign y                         = ssCcfAddOut_0_y;
  assign y_or                      = ssCcfAddOut_0_y_or;
  assign ssCcfAddOut_0_y_ff        = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | ssCcfAddIn_0_regWe | filt8x2x2_0_regWe | ssCcfAddOut_0_regWe;
  assign regReOut = 0 | ssCcfAddIn_0_regRe | filt8x2x2_0_regRe | ssCcfAddOut_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Assign enable
  assign ssCcfAddIn_0_run1  = run1;
  assign filt8x2x2_0_run1   = run1;
  assign ssCcfAddOut_0_run1 = run1;
   
endmodule
//=========================================================================================

