//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssAvg
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssAvg(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter sh                = 0;

  parameter xSumD_w           = 0;
  parameter xSumD_n           = 0;
  parameter xSumD_m           = 0;
  parameter cntSmplOut_w      = 0;
  parameter cntSmplOut_n      = 0;
  parameter cntSmplOut_m      = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg           [xSumD_w-1:0]  xSumD;
  reg      [cntSmplOut_w-1:0]  cntSmplOut;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Registers definitions
  reg        [5:0]  cntIn;
  reg        [1:0]  cntOut;
  wire       [1:0]  cntIn10;
  wire       [3:0]  cntIn52;

  reg     [wx+3:0]  acc, acc_nxt;
  reg     [wx+3:0]  addOut, addIn0, addIn1;
      
  reg     [wx-1:0]  xRe, xIm;
  reg     [wx-1:0]  xReR, xReR_nxt, xImR, xImR_nxt;
  reg     [wx-1:0]  negIn, negOut;
  reg               s, s_nxt;
  reg     [wy-1:0]  xSumD_nxt;
  

  // --------------------------------------------------------------------------
  // Assign input and output enable
  assign cntIn10 = cntIn[1:0];
  assign cntIn52 = cntIn[5:2];
  assign x_ir = run1 & cntIn10==0;
  assign y_or = cntIn52==0 & cntOut==3 & cntSmplOut==1;
  assign y    = acc[wy-1:0];
  
  // --------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Get real an imag part
    xRe    = x[  wx-1: 0];
    xIm    = x[2*wx-1:wx];
        
    // Paranoia setting
    acc_nxt   = acc;
    xReR_nxt  = xReR;
    xImR_nxt  = xImR;
    xSumD_nxt = xSumD;
    s_nxt     = s;
    
    // Use of initial inverter
    if (cntIn10==0) begin
      negIn     = xRe;
    end else 
    //if (cntIn10==1 | cntIn10==2) begin
    begin
      negIn     = xImR;
    end 
    
    // Input inverter
    negOut = -negIn;

    // Use of initial inverter
    if (cntIn10==0) begin
      xReR_nxt  = xRe[wx-1] ? negOut : xRe;
      xImR_nxt  = xIm;
    end else     
    // if (cntIn10==1) begin
    begin
      xImR_nxt  = xImR[wx-1] ? negOut : xImR;
    end

    // Use of adder
    if (cntIn10==2) begin               // Save sign
      addIn0 = {4'b0000, xReR};
      addIn1 = {{4{negOut[wx-1]}}, negOut};
    end else
    if (cntIn10==3) begin
      addIn0 = cntIn52==0 ? 32 : acc;
      addIn1 = s==0 ? xReR : xReR>>1;
    end else
    if (cntIn10==0 & cntOut==1) begin
      addIn0 = acc;
      addIn1 = s==1 ? xImR : xImR>>1;
    end else
    //if (cntIn10==0 & cntOut==2) begin
    begin
      addIn0 = acc>>5;
      addIn1 = {5'b11111, ~xSumD};
    end
    
    // Adder
    addOut = addIn0 + addIn1;
    if (cntIn10==2) begin               // Save sign
      s_nxt  = addOut[wx+3];
    end
    
    // Accumulator output
    if (cntIn10==3) begin
      acc_nxt = addOut;
    end else
    if (cntOut==1) begin
      acc_nxt = addOut;
    end else
    if (cntOut==2 & cntIn52==0) begin
      acc_nxt = addOut[wx+3]==0 ? acc>>5 : xSumD;
    end
    
    // Save delayed element
    if (cntOut==2 & cntIn52==0) begin
      xSumD_nxt = acc[wx+3:5];  // >> 5
    end
    
  end

  // --------------------------------------------------------------------------
  // Input FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cntIn       <= 0;
      cntOut      <= 0;
      cntSmplOut  <= 0;     
      xSumD       <= 0;
      
    // Normal operation
    end else begin
      
      // Update variables
      xReR  <= xReR_nxt;
      xImR  <= xImR_nxt;
      s     <= s_nxt;
      acc   <= acc_nxt;
      xSumD <= xSumD_nxt;
           
      // State input counter, 0..63, always count up 4 values upon new input
      if (x_re | cntIn10!=0) begin
        cntIn <= cntIn+1;
      end
      
      // State output counter, start with cntIn==0, 0,1,2,3 -> 0 
      if (cntIn10==3 | cntOut!=0) begin
        cntOut <= cntOut+1;
      end
      
      // Update output sample counter
      if (cntIn52==0 & cntOut==3) begin
        cntSmplOut <= 1;
      end

    end // if (run1==0) ... else
  end // always

endmodule
//=========================================================================================

