//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   shortSym
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module shortSym(y, y_or, y_ff, y_we, 
                x, x_ir, x_fe, x_re, 
                irqPsduDone, 
                run1, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter irqPsduDone_w     = 0;
  parameter run1_w            = 0;

  parameter numOfdm_w         = 0;
  parameter numOfdm_r         = 0;
  parameter numOfdm_s         = 0;
  parameter R_numOfdm         = 0;

  parameter w                 = 0;
  parameter ssTime0           = 0;
  parameter ssTime1           = 0;
  parameter ssTime2           = 0;
  parameter ssTime3           = 0;
  parameter ssTime4           = 0;

  parameter mode1_w           = 0;
  parameter mode1_n           = 0;
  parameter mode1_m           = 0;
  parameter cntOfdm_w         = 0;
  parameter cntOfdm_n         = 0;
  parameter cntOfdm_m         = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output  [irqPsduDone_w-1:0]  irqPsduDone;
  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [numOfdm_w-1:0]  numOfdm_q;
  wire        [numOfdm_w-1:0]  numOfdm_d;
  wire                         numOfdm_weint;
  assign                       numOfdm_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numOfdm(numOfdm_q, regBus, numOfdm_d, numOfdm_weint, regWe, regRe, clk, reset);
  defparam numOfdm.w    = numOfdm_w;
  defparam numOfdm.rval = numOfdm_r;
  defparam numOfdm.sgn  = numOfdm_s;
  defparam numOfdm.adr  = R_numOfdm;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg           [mode1_w-1:0]  mode1;
  reg         [cntOfdm_w-1:0]  cntOfdm;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf2_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_20_y;
  assign y_or                      = buf2_20_y_or;
  assign buf2_20_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf2_20_regWe;
  assign regReOut = 0 | buf2_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg                [2:0] lutAdr;
  reg                [6:0] smplCnt;
  reg            [2*w-1:0] ssOut, ssCur, yOut;
  reg              [w-1:0] ssRe, ssIm;

  wire                     dataInt;     
  
  wire       [y_w-1:0]  yP;                     // Preliminary output
  wire                  yP_we, yP_or, yP_ff;  // before buffering

  // --------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf2_20_x                 = yP;
  assign buf2_20_x_fe              = ~yP_or;
  assign yP_ff                     = ~buf2_20_x_ir;

  // --------------------------------------------------------------------------
  // Assign input/output enable
  assign dataInt = mode1==0 | mode1==2;
  assign x_ir    = run1 & mode1!=3 & (yP_ff==0 & dataInt==0); 
  assign yP_or   = run1 & mode1!=3 & ( x_fe==0 | dataInt==1);
  assign yP_we   = yP_or & ~yP_ff;
  assign yP      = yOut;

  // Output buffer control
  assign buf2_20_run1 = run1;

  // Issue IRQ at the end
  assign irqPsduDone = cntOfdm==numOfdm_q+1 & smplCnt==1 & yP_we;
  
  // --------------------------------------------------------------------------
  // LUT address counter, LUT address input calculation - combinatorial logic
  always @(*) begin
            
    // Set LUT-8 input address
    if (smplCnt[2]==0) begin    // Count 0,1,2,3,4,3,2,1,0,1,2,...
      lutAdr = smplCnt[2:0];    // for the LUT address input
    end else begin
      lutAdr = -smplCnt[2:0];
    end

    // Execute LUT, use a simple muxer (only 5 entries)
    case (lutAdr)
      0: ssCur = ssTime0;   // Only entries 0-4 are valid
      1: ssCur = ssTime1;
      2: ssCur = ssTime2;
      3: ssCur = ssTime3;
      4: ssCur = ssTime4;
      5: ssCur = ssTime4;   // Don't care here
      6: ssCur = ssTime4;   // --
      7: ssCur = ssTime4;   // --
    endcase

    // Split into real and imag
    ssRe = ssCur[  w-1:0];
    ssIm = ssCur[2*w-1:w];
  
    // Possibly exchange real/imag part
    if (smplCnt[3]==0) begin
      ssOut = {ssIm, ssRe};
    end else begin
      ssOut = {ssRe, ssIm};
    end

    // Assign output - eventually 
    case (mode1)
      0:        yOut = ssOut;
      1:        yOut = x;
      default:  yOut = 0;
    endcase

  end // LUT output processing

  // --------------------------------------------------------------------------
  // FSM-feedback
  always @(posedge clk) begin
    
    // Reset    
    if (run1==0) begin
      mode1   <= 0;
      cntOfdm <= 0;
      smplCnt <= 0;
    end else
    
    // Normal operation
    if (yP_we) begin
      if (smplCnt==79) begin      // At the end of the OFDM symbol
        smplCnt <= 0;             // smplCnt 79 -> 0
        if (cntOfdm==1 | cntOfdm==numOfdm_q | mode1==2) begin
          mode1 <= mode1+1;       // -> possibly a mode1 transition
        end
        if (mode1!=2 & mode1!=3) begin
          cntOfdm <= cntOfdm+1;   // Count up OFDM symbols
        end
      end else begin
        smplCnt <= smplCnt+1;
      end // if (smplCnt==79) ...

    end // if (yP_we) begin
  end // always

endmodule
//=========================================================================================

