//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   s1To2Sel
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module s1To2Sel(y0, y0_or, y0_ff, y0_we, 
                y1, y1_or, y1_ff, y1_we, 
                x, x_ir, x_fe, x_re, 
                sel, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y0_w              = 0;
  parameter y1_w              = 0;
  parameter x_w               = 0;

  parameter sel_w             = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output           [y0_w-1:0]  y0;
  output                       y0_or;
  input                        y0_ff;
  output                       y0_we;
  assign                       y0_we = y0_or & ~y0_ff;

  output           [y1_w-1:0]  y1;
  output                       y1_or;
  input                        y1_ff;
  output                       y1_we;
  assign                       y1_we = y1_or & ~y1_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input           [sel_w-1:0]  sel;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

//-----------------------------------------------------------------------------------------
//Assing input and output controls
  assign y0     = x;
  assign y1     = x;
  assign y0_or  = ~x_fe & sel==0;
  assign y1_or  = ~x_fe & sel==1;
  assign x_ir   = sel==0 ? ~y0_ff : ~y1_ff;

endmodule
//=========================================================================================
