//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   rxBuf
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module rxBuf(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             irqRxDatWr, 
             run1, 
             runOut, 
             numOut, 
             fftWrap, 
             ssAcqHalt, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter irqRxDatWr_w      = 0;
  parameter run1_w            = 0;
  parameter runOut_w          = 0;
  parameter numOut_w          = 0;
  parameter fftWrap_w         = 0;
  parameter ssAcqHalt_w       = 0;

  parameter wrAdr_w           = 0;
  parameter wrAdr_r           = 0;
  parameter wrAdr_s           = 0;
  parameter R_wrAdr           = 0;
  parameter rdAdr0_w          = 0;
  parameter rdAdr0_r          = 0;
  parameter rdAdr0_s          = 0;
  parameter R_rdAdr0          = 0;
  parameter irqAdr_w          = 0;
  parameter irqAdr_r          = 0;
  parameter irqAdr_s          = 0;
  parameter R_irqAdr          = 0;
  parameter agcDoneAdr_w      = 0;
  parameter agcDoneAdr_r      = 0;
  parameter agcDoneAdr_s      = 0;
  parameter R_agcDoneAdr      = 0;

  parameter w                 = 0;
  parameter wa                = 0;

  parameter dpm0_w            = 0;
  parameter dpm0_n            = 0;
  parameter dpm0_m            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output   [irqRxDatWr_w-1:0]  irqRxDatWr;
  input          [run1_w-1:0]  run1;
  input        [runOut_w-1:0]  runOut;
  input        [numOut_w-1:0]  numOut;
  input       [fftWrap_w-1:0]  fftWrap;
  input     [ssAcqHalt_w-1:0]  ssAcqHalt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire          [wrAdr_w-1:0]  wrAdr_q;
  wire          [wrAdr_w-1:0]  wrAdr_d;
  wire                         wrAdr_weint;

  wire         [rdAdr0_w-1:0]  rdAdr0_q;
  wire         [rdAdr0_w-1:0]  rdAdr0_d;
  wire                         rdAdr0_weint;
  assign                       rdAdr0_weint = 0;

  wire         [irqAdr_w-1:0]  irqAdr_q;
  wire         [irqAdr_w-1:0]  irqAdr_d;
  wire                         irqAdr_weint;
  assign                       irqAdr_weint = 0;

  wire     [agcDoneAdr_w-1:0]  agcDoneAdr_q;
  wire     [agcDoneAdr_w-1:0]  agcDoneAdr_d;
  wire                         agcDoneAdr_weint;

  // Wires for internal memories
  wire           [dpm0_w-1:0]  dpm0_q;
  wire           [dpm0_w-1:0]  dpm0_d;
  wire           [dpm0_m-1:0]  dpm0_rdAdr;
  wire           [dpm0_m-1:0]  dpm0_wrAdr;
  wire                         dpm0_we;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg wrAdr(wrAdr_q, regBus, wrAdr_d, wrAdr_weint, regWe, regRe, clk, reset);
  defparam wrAdr.w    = wrAdr_w;
  defparam wrAdr.rval = wrAdr_r;
  defparam wrAdr.sgn  = wrAdr_s;
  defparam wrAdr.adr  = R_wrAdr;

  ereg rdAdr0(rdAdr0_q, regBus, rdAdr0_d, rdAdr0_weint, regWe, regRe, clk, reset);
  defparam rdAdr0.w    = rdAdr0_w;
  defparam rdAdr0.rval = rdAdr0_r;
  defparam rdAdr0.sgn  = rdAdr0_s;
  defparam rdAdr0.adr  = R_rdAdr0;

  ereg irqAdr(irqAdr_q, regBus, irqAdr_d, irqAdr_weint, regWe, regRe, clk, reset);
  defparam irqAdr.w    = irqAdr_w;
  defparam irqAdr.rval = irqAdr_r;
  defparam irqAdr.sgn  = irqAdr_s;
  defparam irqAdr.adr  = R_irqAdr;

  ereg agcDoneAdr(agcDoneAdr_q, regBus, agcDoneAdr_d, agcDoneAdr_weint, regWe, regRe, clk, reset);
  defparam agcDoneAdr.w    = agcDoneAdr_w;
  defparam agcDoneAdr.rval = agcDoneAdr_r;
  defparam agcDoneAdr.sgn  = agcDoneAdr_s;
  defparam agcDoneAdr.adr  = R_agcDoneAdr;

  // --------------------------------------------------------------------------------------
  // Internal dual ported memories
  dpRam1 dpm0(dpm0_q, dpm0_d, dpm0_rdAdr, dpm0_wrAdr, dpm0_we, clk);
  defparam dpm0.w    = dpm0_w;
  defparam dpm0.n    = dpm0_n;
  defparam dpm0.m    = dpm0_m;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [wa-1:0]  rdAdr, rdAdr_nxt;
  reg        [6:0]  cntOut;
  reg               tglOut;
  wire    [wa-1:0]  cmpAdr;
  wire              yStall;
  reg        [6:0]  fftWrapP1;
  wire              startOutFsm, runOutEq0;
  reg               runOutEq0D;
  reg               ssAcqHaltD;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1;
  assign y_or = cntOut!=0 & runOut!=0 & ~yStall;
  assign y    = dpm0_q;
    
  // Connect memory inputs
  assign dpm0_rdAdr = rdAdr_nxt;
  assign dpm0_wrAdr = wrAdr_q;
  assign dpm0_d     = x;
  assign dpm0_we    = x_re;
  
  // Interrupt output
  assign irqRxDatWr = dpm0_we & (dpm0_wrAdr==irqAdr_q);
  
  // Stall output enable
  assign cmpAdr = rdAdr+1;
  assign yStall = wrAdr_q==cmpAdr;

  // Start system if runOut switches from 0 -> 1 or 2
  assign runOutEq0    = runOut==0;
  assign startOutFsm  = runOutEq0D==1 & runOutEq0==0;
  
  // --------------------------------------------------------------------------------------
  // Combinatorial logic
  always @(*) begin
        
    // Use this for FFT wrap comparison
    fftWrapP1 = {3'b000, fftWrap}+1;
    
    // Update read address counter
    if (runOut==0) begin
      rdAdr_nxt = rdAdr0_q;
    end else
    if (y_we) begin
      if (runOut==1) begin
        if (cntOut!=fftWrapP1) begin
          rdAdr_nxt = rdAdr+1;
        end else begin
          rdAdr_nxt = rdAdr-63;
        end
      end else begin
        if (tglOut==0) begin
          rdAdr_nxt = rdAdr+64;
        end else begin
          if (cntOut!=fftWrapP1) begin
            rdAdr_nxt = rdAdr-63;
          end else begin
            rdAdr_nxt = rdAdr-127;
          end
        end
      end
    end else begin
      rdAdr_nxt = rdAdr;
    end
        
  end

  // -------------------------------------------
  // Input/write FSM
  assign wrAdr_d      = wrAdr_q+1;
  assign wrAdr_weint  = x_re;

  // Get write address at the moment of 1->0 transition of ssAcqHalt
  assign agcDoneAdr_d     = wrAdr_q;
  assign agcDoneAdr_weint = ssAcqHaltD==1 & ssAcqHalt==0;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
                
    // -------------------------------------------
    // Delayed runOut
    runOutEq0D <= runOutEq0;
    
    // Reset of output
    if (run1==0) begin
      cntOut     <= 0;
      tglOut     <= 0;
      rdAdr      <= 0;
      ssAcqHaltD <= 0;
      
    // Normal output operation
    end else begin
     
      // Capture ssAcqHalt signal
      ssAcqHaltD <= ssAcqHalt;
     
      // Set next read address
      rdAdr <= rdAdr_nxt;
     
      // Reset output counter upon start
      if (startOutFsm) begin
        cntOut <= numOut;
        tglOut <= 0;
        
      // Otherwise count down if data is written
      end else begin
        
        // Set counter depending on the mode
        if (y_we & cntOut!=0 & (tglOut==1 | runOut==1)) begin
          cntOut <= cntOut-1;
        end
      
        // Set output toggling for mode 2
        if (y_we & runOut==2) begin
          tglOut <= ~tglOut;
        end      
      
      end // if (startOutFsm) ... else
    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

