//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   rx11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module rx11a(y, y_or, y_ff, y_we, 
             yFft, yFft_or, yFft_ff, yFft_we, 
             yAcqCor, yAcqCor_or, yAcqCor_ff, yAcqCor_we, 
             yAcqAbs, yAcqAbs_or, yAcqAbs_ff, yAcqAbs_we, 
             yAcqPh, yAcqPh_or, yAcqPh_ff, yAcqPh_we, 
             ySyncAbs, ySyncAbs_or, ySyncAbs_ff, ySyncAbs_we, 
             ySyncC, ySyncC_or, ySyncC_ff, ySyncC_we, 
             ySyncSh, ySyncSh_or, ySyncSh_ff, ySyncSh_we, 
             yDemD, yDemD_or, yDemD_ff, yDemD_we, 
             yDemSb, yDemSb_or, yDemSb_ff, yDemSb_we, 
             yDecSb, yDecSb_or, yDecSb_ff, yDecSb_we, 
             yDecSb2, yDecSb2_or, yDecSb2_ff, yDecSb2_we, 
             yDecVit, yDecVit_or, yDecVit_ff, yDecVit_we, 
             x, x_ir, x_fe, x_re, 
             xFft, xFft_ir, xFft_fe, xFft_re, 
             irqDone, 
             ssDetect, 
             ssAcqHalt, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yFft_w            = 0;
  parameter yAcqCor_w         = 0;
  parameter yAcqAbs_w         = 0;
  parameter yAcqPh_w          = 0;
  parameter ySyncAbs_w        = 0;
  parameter ySyncC_w          = 0;
  parameter ySyncSh_w         = 0;
  parameter yDemD_w           = 0;
  parameter yDemSb_w          = 0;
  parameter yDecSb_w          = 0;
  parameter yDecSb2_w         = 0;
  parameter yDecVit_w         = 0;
  parameter x_w               = 0;
  parameter xFft_w            = 0;

  parameter irqDone_w         = 0;
  parameter ssDetect_w        = 0;
  parameter ssAcqHalt_w       = 0;

  parameter runAcqBuf_w       = 0;
  parameter runAcqBuf_r       = 0;
  parameter runAcqBuf_s       = 0;
  parameter R_runAcqBuf       = 0;

  parameter wx                = 0;
  parameter wf                = 0;
  parameter modeSyncFte       = 0;
  parameter modeSyncFfe       = 0;
  parameter modeSyncAmpEst    = 0;
  parameter modeSyncChEst     = 0;
  parameter modeSyncChCor     = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output         [yFft_w-1:0]  yFft;
  output                       yFft_or;
  input                        yFft_ff;
  output                       yFft_we;
  assign                       yFft_we = yFft_or & ~yFft_ff;

  output      [yAcqCor_w-1:0]  yAcqCor;
  output                       yAcqCor_or;
  input                        yAcqCor_ff;
  output                       yAcqCor_we;
  assign                       yAcqCor_we = yAcqCor_or & ~yAcqCor_ff;

  output      [yAcqAbs_w-1:0]  yAcqAbs;
  output                       yAcqAbs_or;
  input                        yAcqAbs_ff;
  output                       yAcqAbs_we;
  assign                       yAcqAbs_we = yAcqAbs_or & ~yAcqAbs_ff;

  output       [yAcqPh_w-1:0]  yAcqPh;
  output                       yAcqPh_or;
  input                        yAcqPh_ff;
  output                       yAcqPh_we;
  assign                       yAcqPh_we = yAcqPh_or & ~yAcqPh_ff;

  output     [ySyncAbs_w-1:0]  ySyncAbs;
  output                       ySyncAbs_or;
  input                        ySyncAbs_ff;
  output                       ySyncAbs_we;
  assign                       ySyncAbs_we = ySyncAbs_or & ~ySyncAbs_ff;

  output       [ySyncC_w-1:0]  ySyncC;
  output                       ySyncC_or;
  input                        ySyncC_ff;
  output                       ySyncC_we;
  assign                       ySyncC_we = ySyncC_or & ~ySyncC_ff;

  output      [ySyncSh_w-1:0]  ySyncSh;
  output                       ySyncSh_or;
  input                        ySyncSh_ff;
  output                       ySyncSh_we;
  assign                       ySyncSh_we = ySyncSh_or & ~ySyncSh_ff;

  output        [yDemD_w-1:0]  yDemD;
  output                       yDemD_or;
  input                        yDemD_ff;
  output                       yDemD_we;
  assign                       yDemD_we = yDemD_or & ~yDemD_ff;

  output       [yDemSb_w-1:0]  yDemSb;
  output                       yDemSb_or;
  input                        yDemSb_ff;
  output                       yDemSb_we;
  assign                       yDemSb_we = yDemSb_or & ~yDemSb_ff;

  output       [yDecSb_w-1:0]  yDecSb;
  output                       yDecSb_or;
  input                        yDecSb_ff;
  output                       yDecSb_we;
  assign                       yDecSb_we = yDecSb_or & ~yDecSb_ff;

  output      [yDecSb2_w-1:0]  yDecSb2;
  output                       yDecSb2_or;
  input                        yDecSb2_ff;
  output                       yDecSb2_we;
  assign                       yDecSb2_we = yDecSb2_or & ~yDecSb2_ff;

  output      [yDecVit_w-1:0]  yDecVit;
  output                       yDecVit_or;
  input                        yDecVit_ff;
  output                       yDecVit_we;
  assign                       yDecVit_we = yDecVit_or & ~yDecVit_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [xFft_w-1:0]  xFft;
  output                       xFft_ir;
  input                        xFft_fe;
  output                       xFft_re;
  assign                       xFft_re = xFft_ir & ~xFft_fe;

  output      [irqDone_w-1:0]  irqDone;
  output     [ssDetect_w-1:0]  ssDetect;
  input     [ssAcqHalt_w-1:0]  ssAcqHalt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire      [runAcqBuf_w-1:0]  runAcqBuf_q;
  wire      [runAcqBuf_w-1:0]  runAcqBuf_d;
  wire                         runAcqBuf_weint;
  assign                       runAcqBuf_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg runAcqBuf(runAcqBuf_q, regBus, runAcqBuf_d, runAcqBuf_weint, regWe, regRe, clk, reset);
  defparam runAcqBuf.w    = runAcqBuf_w;
  defparam runAcqBuf.rval = runAcqBuf_r;
  defparam runAcqBuf.sgn  = runAcqBuf_s;
  defparam runAcqBuf.adr  = R_runAcqBuf;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "bufNormRot_0.v"
  `include "acq11a_0.v"
  `include "sync11a_0.v"
  `include "dem11a_0.v"
  `include "dec11a_0.v"
  `include "s1To2Or_20.v"
  `include "s1To2And_9.v"
  `include "s1To2And_26.v"
  `include "s1To2And_22.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign s1To2Or_20_x              = x;
  assign s1To2Or_20_x_fe           = x_fe;
  assign x_ir                      = s1To2Or_20_x_ir;

  assign acq11a_0_x                = s1To2Or_20_y0;
  assign acq11a_0_x_fe             = ~s1To2Or_20_y0_or;
  assign s1To2Or_20_y0_ff          = ~acq11a_0_x_ir;

  assign bufNormRot_0_x            = s1To2Or_20_y1;
  assign bufNormRot_0_x_fe         = ~s1To2Or_20_y1_or;
  assign s1To2Or_20_y1_ff          = ~bufNormRot_0_x_ir;

  assign sync11a_0_xFft            = xFft;
  assign sync11a_0_xFft_fe         = xFft_fe;
  assign xFft_ir                   = sync11a_0_xFft_ir;

  assign sync11a_0_x               = bufNormRot_0_y;
  assign sync11a_0_x_fe            = ~bufNormRot_0_y_or;
  assign bufNormRot_0_y_ff         = ~sync11a_0_x_ir;

  assign sync11a_0_xu              = bufNormRot_0_yu;
  assign sync11a_0_xu_fe           = ~bufNormRot_0_yu_or;
  assign bufNormRot_0_yu_ff        = ~sync11a_0_xu_ir;

  assign s1To2And_26_x             = sync11a_0_yC;
  assign s1To2And_26_x_fe          = ~sync11a_0_yC_or;
  assign sync11a_0_yC_ff           = ~s1To2And_26_x_ir;

  assign s1To2And_9_x              = sync11a_0_ySh;
  assign s1To2And_9_x_fe           = ~sync11a_0_ySh_or;
  assign sync11a_0_ySh_ff          = ~s1To2And_9_x_ir;

  assign dem11a_0_xSf              = s1To2And_9_y0;
  assign dem11a_0_xSf_fe           = ~s1To2And_9_y0_or;
  assign s1To2And_9_y0_ff          = ~dem11a_0_xSf_ir;

  assign dem11a_0_xC               = s1To2And_26_y0;
  assign dem11a_0_xC_fe            = ~s1To2And_26_y0_or;
  assign s1To2And_26_y0_ff         = ~dem11a_0_xC_ir;

  assign s1To2And_22_x             = dem11a_0_ySb;
  assign s1To2And_22_x_fe          = ~dem11a_0_ySb_or;
  assign dem11a_0_ySb_ff           = ~s1To2And_22_x_ir;

  assign dec11a_0_x                = s1To2And_22_y0;
  assign dec11a_0_x_fe             = ~s1To2And_22_y0_or;
  assign s1To2And_22_y0_ff         = ~dec11a_0_x_ir;

  assign yFft                      = sync11a_0_yFft;
  assign yFft_or                   = sync11a_0_yFft_or;
  assign sync11a_0_yFft_ff         = yFft_ff;

  assign y                         = dec11a_0_y;
  assign y_or                      = dec11a_0_y_or;
  assign dec11a_0_y_ff             = y_ff;

  assign yAcqCor                   = acq11a_0_yCor2;
  assign yAcqCor_or                = acq11a_0_yCor2_or;
  assign acq11a_0_yCor2_ff         = yAcqCor_ff;

  assign yAcqPh                    = acq11a_0_yPh;
  assign yAcqPh_or                 = acq11a_0_yPh_or;
  assign acq11a_0_yPh_ff           = yAcqPh_ff;

  assign yAcqAbs                   = acq11a_0_yAbs;
  assign yAcqAbs_or                = acq11a_0_yAbs_or;
  assign acq11a_0_yAbs_ff          = yAcqAbs_ff;

  assign ySyncAbs                  = sync11a_0_yAbs;
  assign ySyncAbs_or               = sync11a_0_yAbs_or;
  assign sync11a_0_yAbs_ff         = ySyncAbs_ff;

  assign ySyncC                    = s1To2And_26_y1;
  assign ySyncC_or                 = s1To2And_26_y1_or;
  assign s1To2And_26_y1_ff         = ySyncC_ff;

  assign ySyncSh                   = s1To2And_9_y1;
  assign ySyncSh_or                = s1To2And_9_y1_or;
  assign s1To2And_9_y1_ff          = ySyncSh_ff;

  assign yDemD                     = dem11a_0_yD;
  assign yDemD_or                  = dem11a_0_yD_or;
  assign dem11a_0_yD_ff            = yDemD_ff;

  assign yDemSb                    = s1To2And_22_y1;
  assign yDemSb_or                 = s1To2And_22_y1_or;
  assign s1To2And_22_y1_ff         = yDemSb_ff;

  assign yDecSb                    = dec11a_0_ySb;
  assign yDecSb_or                 = dec11a_0_ySb_or;
  assign dec11a_0_ySb_ff           = yDecSb_ff;

  assign yDecSb2                   = dec11a_0_ySb2;
  assign yDecSb2_or                = dec11a_0_ySb2_or;
  assign dec11a_0_ySb2_ff          = yDecSb2_ff;

  assign yDecVit                   = dec11a_0_yVit;
  assign yDecVit_or                = dec11a_0_yVit_or;
  assign dec11a_0_yVit_ff          = yDecVit_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | bufNormRot_0_regWe | acq11a_0_regWe | sync11a_0_regWe
                      | dem11a_0_regWe | dec11a_0_regWe | s1To2Or_20_regWe
                      | s1To2And_9_regWe | s1To2And_26_regWe | s1To2And_22_regWe;
  assign regReOut = 0 | bufNormRot_0_regRe | acq11a_0_regRe | sync11a_0_regRe
                      | dem11a_0_regRe | dec11a_0_regRe | s1To2Or_20_regRe
                      | s1To2And_9_regRe | s1To2And_26_regRe | s1To2And_22_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================
  
  // Connect run control
  assign acq11a_0_run1     = runAcqBuf_q;
  assign bufNormRot_0_run1 = runAcqBuf_q;
  
  // Connect IRQ lines
  parameter IrqOffset = WlanIrqBitRxAgc_C;
  assign irqDone[WlanIrqBitRxAgc_C          - IrqOffset]  = 0;
  assign irqDone[WlanIrqBitRxSsDet_C        - IrqOffset]  = acq11a_0_irqSsDet;
  assign irqDone[WlanIrqBitRxSsEnd_C        - IrqOffset]  = acq11a_0_irqSsEnd;
  assign irqDone[WlanIrqBitRxDatWr_C        - IrqOffset]  = bufNormRot_0_irqRxDatWr;
  assign irqDone[WlanIrqBitRxDatRd_C        - IrqOffset]  = bufNormRot_0_irqRxDatRd;
  assign irqDone[WlanIrqBitRxFteDone_C      - IrqOffset]  = sync11a_0_irqDone[0];
  assign irqDone[WlanIrqBitRxCxMulAvgDone_C - IrqOffset]  = sync11a_0_irqDone[1];
  assign irqDone[WlanIrqBitRxTtDone_C       - IrqOffset]  = dem11a_0_irqTtDone;
  assign irqDone[WlanIrqBitRxVitHdrDone_C   - IrqOffset]  = dec11a_0_irqVitDone[0];
  assign irqDone[WlanIrqBitRxVitPsduDone_C  - IrqOffset]  = dec11a_0_irqVitDone[1];

  // Connect AGC signals
  assign ssDetect               = acq11a_0_irqSsDet;
  assign acq11a_0_ssAcqHalt     = ssAcqHalt;
  assign bufNormRot_0_ssAcqHalt = ssAcqHalt;

endmodule
//=========================================================================================

