//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   punct
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module punct(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf2_1.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_1_y;
  assign y_or                      = buf2_1_y_or;
  assign buf2_1_y_ff               = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf2_1_regWe;
  assign regReOut = 0 | buf2_1_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg         [1:0] cnt;                // State counter, 0..3 maximum
  wire        [1:0] cnt_nxt;            // Next state count
  wire        [1:0] cntMax;             // Max count (1,2,3) <=> R=1/2, 2/3, 3/4
  reg               x1D;                // Buffer for bit[1] of input x
  wire              dataInt;            // Indicates that internal data is used
  wire              yOut;               

  wire         [y_w-1:0]  yP;                   // Preliminary output
  wire                    yP_we, yP_or, yP_ff;  // before buffering

  // --------------------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf2_1_x                  = yP;
  assign buf2_1_x_fe               = ~yP_or;
  assign yP_ff                     = ~buf2_1_x_ir;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir  = run1_q!=0 & yP_ff==0 & dataInt==0;
  assign yP_or = run1_q!=0 & (x_fe==0 | dataInt==1);
  assign yP_we = yP_or & ~yP_ff;
  assign yP    = yOut;
  
  // Output buffer control
  assign buf2_1_run1 = run1_q!=0;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  assign yOut    = (cnt==0 | cnt==2) ? x[0] : ((cnt==1) ? x1D : x[1]);
  assign cntMax  = run1_q;                      // Count until cntMax
  assign cnt_nxt = (cnt==cntMax) ? 0 : cnt+1;   // Count 0-1 or 0-2 or 0-3
  assign dataInt = (cnt==1);                    // Internal data is used (x1D)

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      cnt <= 0;
      
    // Normal operation
    end else begin
      
      // Buffer input x[1]
      if (x_re) begin
        x1D <= x[1];       // Buffer input x[1]
      end
         
      // Register update 1
      if (yP_we) begin
        cnt <= cnt_nxt;    // Count up state counter
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

