//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   pltExt
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module pltExt(y, y_or, y_ff, y_we, 
              x, x_ir, x_fe, x_re, 
              irqDone, 
              run1, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter irqDone_w         = 0;
  parameter run1_w            = 0;

  parameter pltSumRe_w        = 0;
  parameter pltSumRe_r        = 0;
  parameter pltSumRe_s        = 0;
  parameter R_pltSumRe        = 0;
  parameter pltSumIm_w        = 0;
  parameter pltSumIm_r        = 0;
  parameter pltSumIm_s        = 0;
  parameter R_pltSumIm        = 0;

  parameter w                 = 0;

  parameter pltScr_w          = 0;
  parameter pltScr_n          = 0;
  parameter pltScr_m          = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output      [irqDone_w-1:0]  irqDone;
  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire       [pltSumRe_w-1:0]  pltSumRe_q;
  wire       [pltSumRe_w-1:0]  pltSumRe_d;
  wire                         pltSumRe_weint;

  wire       [pltSumIm_w-1:0]  pltSumIm_q;
  wire       [pltSumIm_w-1:0]  pltSumIm_d;
  wire                         pltSumIm_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg pltSumRe(pltSumRe_q, regBus, pltSumRe_d, pltSumRe_weint, regWe, regRe, clk, reset);
  defparam pltSumRe.w    = pltSumRe_w;
  defparam pltSumRe.rval = pltSumRe_r;
  defparam pltSumRe.sgn  = pltSumRe_s;
  defparam pltSumRe.adr  = R_pltSumRe;

  ereg pltSumIm(pltSumIm_q, regBus, pltSumIm_d, pltSumIm_weint, regWe, regRe, clk, reset);
  defparam pltSumIm.w    = pltSumIm_w;
  defparam pltSumIm.rval = pltSumIm_r;
  defparam pltSumIm.sgn  = pltSumIm_s;
  defparam pltSumIm.adr  = R_pltSumIm;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg          [pltScr_w-1:0]  pltScr;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [5:0]  cnt;         // Data counter

  wire   [w-1:0] xRe, xIm;    // Real/imag part of input x
  reg    [w-1:0] xImD;        // Buffered imag part of input x
  reg            addImFlag;       // Indicate that the module is busy adding up imag part
  
  wire           isData;      // As the name says, use for indicating
  wire           isPilot;     // either data or a pilot
  
  wire   [w+1:0] addIn0, addIn1, addIn0s, addOut;
  wire           sgn0;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir  = run1 & ((isData & ~y_ff) | (isPilot & ~addImFlag));
  
  // Split input into real and imag part
  assign xRe = x[  w-1:0];
  assign xIm = x[2*w-1:w];
  
  // Test for special counter values
  assign isPilot = (cnt==0) | (cnt==1) | (cnt==2) | (cnt==3);
  assign isData  = ~isPilot;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      cnt       <= 0;
      addImFlag <= 0;
      pltScr    <= 112;
      
    // Normal operation
    end else begin
      
      // Add up FSM
      if (x_re & isPilot) begin
        addImFlag <= 1;
      end else begin
        addImFlag <= 0;
      end
      
      // Input counter FSM
      if ((cnt!=51 & isData & x_re) | (isPilot & addImFlag)) begin
        cnt <= cnt+1;
      end else 
      if (cnt==51 & x_re) begin
        cnt <= 0;
      end
     
      // Buffer input data
      if (x_re) begin
        xImD <= xIm;
      end

      // Update pilot scrambler
      if (cnt==8 && x_re) begin
        if (pltScr[0]==0) begin
          pltScr <= pltScr >> 1;
        end else begin
          pltScr <= (pltScr >> 1) ^ 72;
        end
      end
      
    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Pilot carrier add up
  assign sgn0     = (cnt==3) ^ pltScr[0];
  assign addIn0   = (addImFlag==0) ? {{2{xRe[w-1]}}, xRe} : {{2{xImD[w-1]}}, xImD};
  assign addIn1   = (addImFlag==0) ? pltSumRe_q           : pltSumIm_q;
  assign addIn0s  = sgn0 ? -addIn0 : addIn0;
  assign addOut   = addIn0s + addIn1;
  
  assign pltSumRe_d     = addOut;
  assign pltSumIm_d     = addOut;
  assign pltSumRe_weint = isPilot & x_re;
  assign pltSumIm_weint = addImFlag;

  // Assign output data carriers
  assign y    = x;
  assign y_or = isData & x_re;
  
  // --------------------------------------------------------------------------------------
  // IRQ pilot extraction/summation done
  assign irqDone = (cnt==3 || cnt==51) && x_re;
  
endmodule
//=========================================================================================

