//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   normXDivCore
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module normXDivCore(nOut, nOut_or, nOut_ff, nOut_we, 
                    qOut, qOut_or, qOut_ff, qOut_we, 
                    nIn, nIn_ir, nIn_fe, nIn_re, 
                    qIn, qIn_ir, qIn_fe, qIn_re, 
                    dIn, dIn_ir, dIn_fe, dIn_re, 
                    regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter nOut_w            = 0;
  parameter qOut_w            = 0;
  parameter nIn_w             = 0;
  parameter qIn_w             = 0;
  parameter dIn_w             = 0;


  parameter wn                = 0;
  parameter wd                = 0;
  parameter wq                = 0;
  parameter ws                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [nOut_w-1:0]  nOut;
  output                       nOut_or;
  input                        nOut_ff;
  output                       nOut_we;
  assign                       nOut_we = nOut_or & ~nOut_ff;

  output         [qOut_w-1:0]  qOut;
  output                       qOut_or;
  input                        qOut_ff;
  output                       qOut_we;
  assign                       qOut_we = qOut_or & ~qOut_ff;

  input           [nIn_w-1:0]  nIn;
  output                       nIn_ir;
  input                        nIn_fe;
  output                       nIn_re;
  assign                       nIn_re = nIn_ir & ~nIn_fe;

  input           [qIn_w-1:0]  qIn;
  output                       qIn_ir;
  input                        qIn_fe;
  output                       qIn_re;
  assign                       qIn_re = qIn_ir & ~qIn_fe;

  input           [dIn_w-1:0]  dIn;
  output                       dIn_ir;
  input                        dIn_fe;
  output                       dIn_re;
  assign                       dIn_re = dIn_ir & ~dIn_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Wire / register definitions
  reg        [wn:0]  n;     // One bit more (12 bit) needed
  reg      [ws-1:0]  nLo;   // Lower 2 bit of nIn
  reg   [wn-ws-1:0]  nHi;   // Upper 9 bit of nIn
  reg      [wy-1:0]  y;     // 10 bit intermediate result
  reg                ys;    // Sign bit of y
  reg      [wq-1:0]  q;

  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
    
    // Get inputs
    nLo = nIn[ws-1: 0];
    nHi = nIn[wn-1:ws];
    
    // Core processing
    y  = {1'b0, nHi} - {2'b00, dIn};
    ys = y[wy-1];

    q  = {qIn[wq-2:0], ~ys};
    n  = {ys ? nHi : y[wy-2:0], nLo} << 1;
    n[wn-1] = n[wn-1] | n[wn];
        
  end

  // Assign outputs
  assign nOut = n[wn-1:0];
  assign qOut = q;

endmodule
//=========================================================================================

