//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   normX
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module normX(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             runOut, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter runOut_w          = 0;

  parameter amp_w             = 0;
  parameter amp_r             = 0;
  parameter amp_s             = 0;
  parameter R_amp             = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input        [runOut_w-1:0]  runOut;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire            [amp_w-1:0]  amp_q;
  wire            [amp_w-1:0]  amp_d;
  wire                         amp_weint;
  assign                       amp_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg amp(amp_q, regBus, amp_d, amp_weint, regWe, regRe, clk, reset);
  defparam amp.w    = amp_w;
  defparam amp.rval = amp_r;
  defparam amp.sgn  = amp_s;
  defparam amp.adr  = R_amp;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "normXDivCore_re0.v"
  `include "normXDivCore_re1.v"
  `include "normXDivCore_re2.v"
  `include "normXDivCore_re3.v"
  `include "normXDivCore_re4.v"
  `include "normXDivCore_re5.v"
  `include "normXDivCore_re6.v"
  `include "normXDivCore_re7.v"
  `include "normXDivCore_re8.v"
  `include "normXDivCore_im0.v"
  `include "normXDivCore_im1.v"
  `include "normXDivCore_im2.v"
  `include "normXDivCore_im3.v"
  `include "normXDivCore_im4.v"
  `include "normXDivCore_im5.v"
  `include "normXDivCore_im6.v"
  `include "normXDivCore_im7.v"
  `include "normXDivCore_im8.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | normXDivCore_re0_regWe | normXDivCore_re1_regWe | normXDivCore_re2_regWe
                      | normXDivCore_re3_regWe | normXDivCore_re4_regWe | normXDivCore_re5_regWe
                      | normXDivCore_re6_regWe | normXDivCore_re7_regWe | normXDivCore_re8_regWe
                      | normXDivCore_im0_regWe | normXDivCore_im1_regWe | normXDivCore_im2_regWe
                      | normXDivCore_im3_regWe | normXDivCore_im4_regWe | normXDivCore_im5_regWe
                      | normXDivCore_im6_regWe | normXDivCore_im7_regWe | normXDivCore_im8_regWe;
  assign regReOut = 0 | normXDivCore_re0_regRe | normXDivCore_re1_regRe | normXDivCore_re2_regRe
                      | normXDivCore_re3_regRe | normXDivCore_re4_regRe | normXDivCore_re5_regRe
                      | normXDivCore_re6_regRe | normXDivCore_re7_regRe | normXDivCore_re8_regRe
                      | normXDivCore_im0_regRe | normXDivCore_im1_regRe | normXDivCore_im2_regRe
                      | normXDivCore_im3_regRe | normXDivCore_im4_regRe | normXDivCore_im5_regRe
                      | normXDivCore_im6_regRe | normXDivCore_im7_regRe | normXDivCore_im8_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================
  
  // Define some parameters from included files
  parameter wn = normXDivCore_re0_wn;
  parameter wq = normXDivCore_re0_wq;

  // --------------------------------------------------------------------------------------
  // Register definitions
  wire    [wx-1:0]  xRe,  xIm;
  wire    [wx-2:0]  xARe, xAIm;
  wire              xSRe, xSIm;
  wire    [wy-1:0]  yRe,  yIm;
  wire [amp_w-1:0]  amp1;

  reg     [wn-1:0]  nOut2ReD, nOut5ReD, nOut2ImD, nOut5ImD;
  reg     [wq-1:0]  qOut2ReD, qOut5ReD, qOut2ImD, qOut5ImD;
  reg     [wy-1:0]  yReD, yImD;
  reg        [2:0]  x_reD;
  reg        [1:0]  xSReD, xSImD;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable (delayed by pipeline)
  assign x_ir   = runOut & ~y_ff;
  assign y_or   = x_reD[2];

  // --------------------------------------------------------------------------------------
  // amp=0 -> use 1 to avoid division by 0
  assign amp1 = amp_q==0 ? 1 : amp_q;

  // Input processing - real part
  assign xRe  = x[wx-1:0];
  assign xSRe = xRe[wx-1];
  assign xARe = xSRe ? -xRe[wx-2:0] : xRe[wx-2:0]; 

  // Connect core modules - real part
  assign normXDivCore_re0_nIn = xARe;
  assign normXDivCore_re1_nIn = normXDivCore_re0_nOut;
  assign normXDivCore_re2_nIn = normXDivCore_re1_nOut;
  assign normXDivCore_re3_nIn = nOut2ReD;
  assign normXDivCore_re4_nIn = normXDivCore_re3_nOut;
  assign normXDivCore_re5_nIn = normXDivCore_re4_nOut;
  assign normXDivCore_re6_nIn = nOut5ReD;
  assign normXDivCore_re7_nIn = normXDivCore_re6_nOut;
  assign normXDivCore_re8_nIn = normXDivCore_re7_nOut;

  assign normXDivCore_re0_qIn = 0;
  assign normXDivCore_re1_qIn = normXDivCore_re0_qOut;
  assign normXDivCore_re2_qIn = normXDivCore_re1_qOut;
  assign normXDivCore_re3_qIn = qOut2ReD;
  assign normXDivCore_re4_qIn = normXDivCore_re3_qOut;
  assign normXDivCore_re5_qIn = normXDivCore_re4_qOut;
  assign normXDivCore_re6_qIn = qOut5ReD;
  assign normXDivCore_re7_qIn = normXDivCore_re6_qOut;
  assign normXDivCore_re8_qIn = normXDivCore_re7_qOut;
                                                                     
  assign normXDivCore_re0_dIn = amp1;                               
  assign normXDivCore_re1_dIn = amp1;                               
  assign normXDivCore_re2_dIn = amp1;                               
  assign normXDivCore_re3_dIn = amp1;                               
  assign normXDivCore_re4_dIn = amp1;
  assign normXDivCore_re5_dIn = amp1;
  assign normXDivCore_re6_dIn = amp1;
  assign normXDivCore_re7_dIn = amp1;
  assign normXDivCore_re8_dIn = amp1;

  // Final output inversion - real part
  assign yRe = xSReD[1] ? -{1'b0, normXDivCore_re8_qOut} : {1'b0, normXDivCore_re8_qOut};
  
  // ----------------------------
  // Input processing - imag part
  assign xIm  = x[2*wx-1:wx];
  assign xSIm = xIm[wx-1];
  assign xAIm = xSIm ? -xIm[wx-2:0] : xIm[wx-2:0]; 

  // Connect core modules - imag part
  assign normXDivCore_im0_nIn = xAIm;
  assign normXDivCore_im1_nIn = normXDivCore_im0_nOut;
  assign normXDivCore_im2_nIn = normXDivCore_im1_nOut;
  assign normXDivCore_im3_nIn = nOut2ImD;
  assign normXDivCore_im4_nIn = normXDivCore_im3_nOut;
  assign normXDivCore_im5_nIn = normXDivCore_im4_nOut;
  assign normXDivCore_im6_nIn = nOut5ImD;
  assign normXDivCore_im7_nIn = normXDivCore_im6_nOut;
  assign normXDivCore_im8_nIn = normXDivCore_im7_nOut;

  assign normXDivCore_im0_qIn = 0;
  assign normXDivCore_im1_qIn = normXDivCore_im0_qOut;
  assign normXDivCore_im2_qIn = normXDivCore_im1_qOut;
  assign normXDivCore_im3_qIn = qOut2ImD;
  assign normXDivCore_im4_qIn = normXDivCore_im3_qOut;
  assign normXDivCore_im5_qIn = normXDivCore_im4_qOut;
  assign normXDivCore_im6_qIn = qOut5ImD;
  assign normXDivCore_im7_qIn = normXDivCore_im6_qOut;
  assign normXDivCore_im8_qIn = normXDivCore_im7_qOut;

  assign normXDivCore_im0_dIn = amp1;                               
  assign normXDivCore_im1_dIn = amp1;                               
  assign normXDivCore_im2_dIn = amp1;                               
  assign normXDivCore_im3_dIn = amp1;                               
  assign normXDivCore_im4_dIn = amp1;
  assign normXDivCore_im5_dIn = amp1;
  assign normXDivCore_im6_dIn = amp1;
  assign normXDivCore_im7_dIn = amp1;
  assign normXDivCore_im8_dIn = amp1;

  // Final output inversion - imag part
  assign yIm = xSImD[1] ? -{1'b0, normXDivCore_im8_qOut} : {1'b0, normXDivCore_im8_qOut};
  
// --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin

    // Reset
    if (runOut==0) begin
      x_reD <= 0;
      
    // Normal operation
    end else begin
      
      if (~y_ff) begin

        // Delay input read enable
        x_reD <= {x_reD[1:0], x_re};

        // Delayed values for real part 
        xSReD     <= {xSReD[0], xSRe};
        nOut2ReD  <= normXDivCore_re2_nOut;
        qOut2ReD  <= normXDivCore_re2_qOut;
        nOut5ReD  <= normXDivCore_re5_nOut;
        qOut5ReD  <= normXDivCore_re5_qOut;
        yReD      <= yRe;

        // Delayed values for imag part 
        xSImD     <= {xSImD[0], xSIm};
        nOut2ImD  <= normXDivCore_im2_nOut;
        qOut2ImD  <= normXDivCore_im2_qOut;
        nOut5ImD  <= normXDivCore_im5_nOut;
        qOut5ImD  <= normXDivCore_im5_qOut;
        yImD      <= yIm;

      end // if (~y_ff)
    end // if (runOut_q==0) ... else
  end // always

  // -----------------------------
  // Assemble real and imag output
  assign y = {yImD, yReD};

endmodule
//=========================================================================================
