//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mod11bQpsk
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mod11bQpsk(y, y_or, y_ff, y_we, 
                  x, x_ir, x_fe, x_re, 
                  runCck, 
                  phOut, 
                  run1, 
                  phIn, 
                  regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter runCck_w          = 0;
  parameter phOut_w           = 0;
  parameter run1_w            = 0;
  parameter phIn_w            = 0;

  parameter numBits_w         = 0;
  parameter numBits_r         = 0;
  parameter numBits_s         = 0;
  parameter R_numBits         = 0;

  parameter ph_w              = 0;
  parameter ph_n              = 0;
  parameter ph_m              = 0;
  parameter cntBits_w         = 0;
  parameter cntBits_n         = 0;
  parameter cntBits_m         = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output       [runCck_w-1:0]  runCck;
  output        [phOut_w-1:0]  phOut;
  input          [run1_w-1:0]  run1;
  input          [phIn_w-1:0]  phIn;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [numBits_w-1:0]  numBits_q;
  wire        [numBits_w-1:0]  numBits_d;
  wire                         numBits_weint;
  assign                       numBits_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numBits(numBits_q, regBus, numBits_d, numBits_weint, regWe, regRe, clk, reset);
  defparam numBits.w    = numBits_w;
  defparam numBits.rval = numBits_r;
  defparam numBits.sgn  = numBits_s;
  defparam numBits.adr  = R_numBits;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [ph_w-1:0]  ph;
  reg         [cntBits_w-1:0]  cntBits;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // -------------------------------------------------------------------------------------
  // Some more defintions
  reg          x1;
  reg          cntIn;
  reg    [3:0] cntOut;
  reg   [10:0] chips;

  // -------------------------------------------------------------------------------------
  // Define input and output signals and control
  assign x_ir   = run1 & cntOut==0 & cntBits!=numBits_q;

  assign y      = {ph[1]^chips[0], ph[0]} & {2{y_we}}; // Spreading modulation
  assign y_or   = cntOut!=0;                           // Set to zero when not written

  assign runCck  = run1 & cntBits==numBits_q & cntOut==0; // Start mod11bCck
  assign phOut   = ph;                            // Output QPSK start phase 
                                                  // for mod11bCck
  // -------------------------------------------------------------------------------------
  // Input FSM
  always @(posedge clk) begin
    
    // Reset input FSM
    if (run1==0) begin
      ph      <= phIn;          // Set initial phase
      cntBits <= 0;             // Set bit counter
      cntIn   <= 0;
    end else 
    
    // Normal operation
    begin
      if (x_re) begin                   // Read data
        cntIn <= cntIn+1;
        if (cntIn==0) begin
          x1 <= x;
        end else begin
          ph      <= ph + {x1, x1^x};  // DQPSK Gray encoding
          cntBits <= cntBits+2;
        end
      end
    end

  end //always
    
  // Output FSM
  always @(posedge clk) begin
    
    // Reset output FSM
    if (run1==0) begin
      cntOut <= 0;
      chips  <= 11'b11100010010;
    end else
    
    // Normal output FSM operation
    begin
      if (cntOut==0) begin                // Wait for input data
        if (x_re & cntIn==1) begin        // If input data available
          cntOut <= 11;                   // -> set output counter
        end
      end else
      
      begin                               // Spread input data
        if (y_we) begin
          cntOut <= cntOut-1;
          chips  <= {chips[0], chips[10:1]}; // -> Rotate chip pattern every
        end //if (y_we)      
      end //if (cntOut==0) ... else
    end //if (run1_q==0) ... else

  end //always 

endmodule
//=========================================================================================
