//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mod11bCck
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mod11bCck(y, y_or, y_ff, y_we, 
                 x, x_ir, x_fe, x_re, 
                 runZeros, 
                 run1, 
                 phIn, 
                 regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter runZeros_w        = 0;
  parameter run1_w            = 0;
  parameter phIn_w            = 0;

  parameter numBits_w         = 0;
  parameter numBits_r         = 0;
  parameter numBits_s         = 0;
  parameter R_numBits         = 0;
  parameter mode1_w           = 0;
  parameter mode1_r           = 0;
  parameter mode1_s           = 0;
  parameter R_mode1           = 0;

  parameter ph_w              = 0;
  parameter ph_n              = 0;
  parameter ph_m              = 0;
  parameter cntBits_w         = 0;
  parameter cntBits_n         = 0;
  parameter cntBits_m         = 0;
  parameter tph_w             = 0;
  parameter tph_n             = 0;
  parameter tph_m             = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output     [runZeros_w-1:0]  runZeros;
  input          [run1_w-1:0]  run1;
  input          [phIn_w-1:0]  phIn;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire        [numBits_w-1:0]  numBits_q;
  wire        [numBits_w-1:0]  numBits_d;
  wire                         numBits_weint;
  assign                       numBits_weint = 0;

  wire          [mode1_w-1:0]  mode1_q;
  wire          [mode1_w-1:0]  mode1_d;
  wire                         mode1_weint;
  assign                       mode1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg numBits(numBits_q, regBus, numBits_d, numBits_weint, regWe, regRe, clk, reset);
  defparam numBits.w    = numBits_w;
  defparam numBits.rval = numBits_r;
  defparam numBits.sgn  = numBits_s;
  defparam numBits.adr  = R_numBits;

  ereg mode1(mode1_q, regBus, mode1_d, mode1_weint, regWe, regRe, clk, reset);
  defparam mode1.w    = mode1_w;
  defparam mode1.rval = mode1_r;
  defparam mode1.sgn  = mode1_s;
  defparam mode1.adr  = R_mode1;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [ph_w-1:0]  ph;
  reg         [cntBits_w-1:0]  cntBits;
  reg             [tph_w-1:0]  tph;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // -------------------------------------------------------------------------------------
  // Define output y as register
  reg     [y_w-1:0] y;
  reg               y_or;
    
  // Some more defintions
  reg               xD;         // Delayed input 
  reg         [7:0] xIn;        // Only x[7:2] needed
  reg         [3:0] cntOut;
  wire        [1:0] phOut, phOut0, phOut1, phOut2, phOut3;
  wire        [1:0] phIn0, phIn1, phIn2, phIn3;

  // -------------------------------------------------------------------------------------
  // Define input and output signals and control
  assign x_ir      = run1 & cntOut[3]==1 & cntBits!=numBits_q & y_or==0;
  assign runZeros  = run1 & cntOut==15   & cntBits==numBits_q & y_or==0;  // Start zero append for SRC

  // -------------------------------------------------------------------------------------
  // Input FSM
  always @(posedge clk) begin
    
    // Reset input FSM
    if (run1==0) begin
      ph      <= phIn;          // Reset phase
      tph     <= 0;             // Reset toggle phase
      cntBits <= 0;             // Set bit counter
    end else 
    
    // Normal operation
    begin
      if (x_re) begin                   // Read data
        cntBits <= cntBits+1;
        xD      <= x;
        if ((mode1_q==0 & cntBits[1:0]==1) |
            (mode1_q==1 & cntBits[2:0]==1)) begin   // DTGE, same for CCK-5.5 and CCK-11
          ph    <= ph + {xD, xD^x} + {tph, 1'b0};
          tph   <= ~tph;
        end
        if (mode1_q==0) begin   // CCK-11 -> shift in data, but change
          xIn[2] <= xIn[6];
          xIn[6] <= x;
          xIn[3] <= 1;
          xIn[4] <= 0;
          xIn[5] <= 0;
          xIn[7] <= 0;         
        end else begin       // CCK-11 -> shift in data
          xIn[2] <= xIn[3];
          xIn[3] <= xIn[4];
          xIn[4] <= xIn[5];
          xIn[5] <= xIn[6];
          xIn[6] <= xIn[7];
          xIn[7] <= x;
        end // if (mode1_q==0) begin
      end // 
    end

  end //always

  // Map bits in xIn
  assign phIn0 = ph;
  assign phIn1 = {xIn[6], xIn[7]};
  assign phIn2 = {xIn[4], xIn[5]};
  assign phIn3 = {xIn[2], xIn[3]};

  // CCK modulation
  assign phOut0 = (cntOut==4 | cntOut==1) ? phIn0+2 : phIn0;  // Cover code
  assign phOut1 = cntOut[2] ? phIn1 : 0;     // Select 
  assign phOut2 = cntOut[1] ? phIn2 : 0;
  assign phOut3 = cntOut[0] ? phIn3 : 0;
  assign phOut  = phOut0 + phOut1 + phOut2 + phOut3;

  // Run the output FSM if cntOut=0..7, data is not ready or currently written
  assign runOutFsm = (cntOut[3]==0) & (y_or==0 | y_we==1);
        
  // Output FSM
  always @(posedge clk) begin
    
    // Reset output FSM
    if (run1==0) begin
      cntOut <= 15;
      y      <= 0;
      y_or   <= 0;
    end else
    
    // Normal output FSM operation
    begin
      // Wait for input FSM to be ready -> set cntOut=7 to start
      if (cntOut[3]==1) begin                 // Wait for input data
        if (x_re & (                          // Data will be available in the
            (mode1_q==0 & cntBits[1:0]==3) |  // next cycle if input data is read
            (mode1_q==1 & cntBits[2:0]==7))) begin // and the input bits counter is
          cntOut <= 7;                        // equal to 1 for the last 2 or 3 bits
        end                                   // depending on the mode
      end else
      
      // Run output FSM (CCK encoding)
      begin                                   // If cntOut = 7..0
        if (runOutFsm) begin                  
          cntOut <= cntOut-1;                 
          y      <= phOut;                    
        end //if (y_we)      
      end //if (cntOut[3]==1) ... else
      y_or <= (y_or & ~y_we) | runOutFsm;     // Output will be ready if it has been ready before
    end //if (run1==0) ... else               // and is not read, or the output FSM runs
                                              // Count down output, stop at output =-1 (=15)
  end //always                                // Output is registered

endmodule
//=========================================================================================
