//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mod11b
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mod11b(y, y_or, y_ff, y_we, 
              x, x_ir, x_fe, x_re, 
              run1, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "mod11bBpsk_0.v"
  `include "mod11bQpsk_0.v"
  `include "mod11bCck_0.v"
  `include "modQpskZero_0.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | mod11bBpsk_0_regWe | mod11bQpsk_0_regWe | mod11bCck_0_regWe
                      | modQpskZero_0_regWe;
  assign regReOut = 0 | mod11bBpsk_0_regRe | mod11bQpsk_0_regRe | mod11bCck_0_regRe
                      | modQpskZero_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Connect input 
  assign x_ir = mod11bBpsk_0_x_ir | mod11bQpsk_0_x_ir | mod11bCck_0_x_ir;
  
  // Connect mod11bBpsk
  assign mod11bBpsk_0_x       = x;
  assign mod11bBpsk_0_x_fe    = x_fe;
  assign mod11bBpsk_0_y_ff    = ~modQpskZero_0_x_ir;
  assign mod11bBpsk_0_run1    = run1;

  // Connect mod11bQpsk
  assign mod11bQpsk_0_x       = x;
  assign mod11bQpsk_0_x_fe    = x_fe;
  assign mod11bQpsk_0_run1    = mod11bBpsk_0_runQpsk;
  assign mod11bQpsk_0_y_ff    = ~modQpskZero_0_x_ir;
  assign mod11bQpsk_0_phIn    = mod11bBpsk_0_phOut;

  // Connect mod11bCck
  assign mod11bCck_0_x        = x;
  assign mod11bCck_0_x_fe     = x_fe;
  assign mod11bCck_0_run1     = mod11bQpsk_0_runCck;
  assign mod11bCck_0_y_ff     = ~modQpskZero_0_x_ir;
  assign mod11bCck_0_phIn     = mod11bQpsk_0_phOut;

  // Connect modQpskZero
  assign modQpskZero_0_x      =   mod11bBpsk_0_y    |  mod11bQpsk_0_y   | mod11bCck_0_y;
  assign modQpskZero_0_x_fe   = ~(mod11bBpsk_0_y_or | mod11bQpsk_0_y_or | mod11bCck_0_y_or);
  assign modQpskZero_0_run1   = run1;
  assign modQpskZero_0_mode1  = mod11bCck_0_runZeros;
  
  assign y    = modQpskZero_0_y;
  assign y_or = modQpskZero_0_y_or;
  assign modQpskZero_0_y_ff = y_ff;

endmodule
//=========================================================================================

