//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   mod11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module mod11a(y, y_or, y_ff, y_we, 
              yFft, yFft_or, yFft_ff, yFft_we, 
              x, x_ir, x_fe, x_re, 
              xFft, xFft_ir, xFft_fe, xFft_re, 
              irqDone, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yFft_w            = 0;
  parameter x_w               = 0;
  parameter xFft_w            = 0;

  parameter irqDone_w         = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;
  parameter wf                = 0;

  parameter qam2lpd_w         = 0;
  parameter qam2lpd_n         = 0;
  parameter qam2lpd_m         = 0;
  parameter R_qam2lpd         = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output         [yFft_w-1:0]  yFft;
  output                       yFft_or;
  input                        yFft_ff;
  output                       yFft_we;
  assign                       yFft_we = yFft_or & ~yFft_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [xFft_w-1:0]  xFft;
  output                       xFft_ir;
  input                        xFft_fe;
  output                       xFft_re;
  assign                       xFft_re = xFft_ir & ~xFft_fe;

  output      [irqDone_w-1:0]  irqDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "intlv_0.v"
  `include "qamMod_0.v"
  `include "lsPltDat_0.v"
  `include "cpExt_0.v"
  `include "shortSym_0.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo qamMod_0_y -> lsPltDat_0_x
  wire      [qam2lpd_w-1:0]  qam2lpd_q;
  wire                       qam2lpd_fe;
  wire                       qam2lpd_ff;
  wire                       qam2lpd_ff2;
  wire                       qam2lpd_fuf;
  wire                       qam2lpd_fof;
  wire      [qam2lpd_w-1:0]  qam2lpd_d;
  wire                       qam2lpd_re;
  wire                       qam2lpd_we;
  wire                       qam2lpd_ir;
  wire                       qam2lpd_or;
  wire                       qam2lpd_rst;

  fifoB qam2lpd(qam2lpd_q, qam2lpd_fe, qam2lpd_ff, qam2lpd_ff2, qam2lpd_fuf,
                qam2lpd_fof, qam2lpd_d, qam2lpd_re, qam2lpd_we, qam2lpd_ir,
                qam2lpd_or, qam2lpd_rst, clk);
  defparam qam2lpd.w = qam2lpd_w;
  defparam qam2lpd.m = qam2lpd_m;
  defparam qam2lpd.n = qam2lpd_n;
  defparam qam2lpd.a = R_qam2lpd;

  assign qam2lpd_d                 = qamMod_0_y;
  assign qam2lpd_we                = qamMod_0_y_we;
  assign qamMod_0_y_ff             = qam2lpd_ff;
  assign qam2lpd_or                = qamMod_0_y_or;

  assign lsPltDat_0_x              = qam2lpd_q;
  assign lsPltDat_0_x_fe           = qam2lpd_fe;
  assign qam2lpd_re                = lsPltDat_0_x_re;
  assign qam2lpd_ir                = lsPltDat_0_x_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign intlv_0_x                 = x;
  assign intlv_0_x_fe              = x_fe;
  assign x_ir                      = intlv_0_x_ir;

  assign qamMod_0_x                = intlv_0_y;
  assign qamMod_0_x_fe             = ~intlv_0_y_or;
  assign intlv_0_y_ff              = ~qamMod_0_x_ir;

  assign yFft                      = lsPltDat_0_y;
  assign yFft_or                   = lsPltDat_0_y_or;
  assign lsPltDat_0_y_ff           = yFft_ff;

  assign cpExt_0_x                 = xFft;
  assign cpExt_0_x_fe              = xFft_fe;
  assign xFft_ir                   = cpExt_0_x_ir;

  assign shortSym_0_x              = cpExt_0_y;
  assign shortSym_0_x_fe           = ~cpExt_0_y_or;
  assign cpExt_0_y_ff              = ~shortSym_0_x_ir;

  assign y                         = shortSym_0_y;
  assign y_or                      = shortSym_0_y_or;
  assign shortSym_0_y_ff           = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | intlv_0_regWe | qamMod_0_regWe | lsPltDat_0_regWe
                      | cpExt_0_regWe | shortSym_0_regWe;
  assign regReOut = 0 | intlv_0_regRe | qamMod_0_regRe | lsPltDat_0_regRe
                      | cpExt_0_regRe | shortSym_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Connect control signals
  assign intlv_0_run1     = run1_q!=0;
  assign qamMod_0_run1    = run1_q;
  assign lsPltDat_0_run1  = run1_q!=0;
  assign cpExt_0_run1     = run1_q!=0;
  assign shortSym_0_run1  = run1_q!=0;

  // FIFO reset
  assign qam2lpd_rst      = run1_q==0;

  // Connect IRQs
  assign irqDone[0]       = intlv_0_irqHdrDone;
  assign irqDone[1]       = qamMod_0_irqHdrDone;
  assign irqDone[2]       = shortSym_0_irqPsduDone;

endmodule
//=========================================================================================

