//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   main11b
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module main11b(bOut, bOut_or, bOut_ff, bOut_we, 
               tx20, tx20_or, tx20_ff, tx20_we, 
               bIn, bIn_ir, bIn_fe, bIn_re, 
               rx20, rx20_ir, rx20_fe, rx20_re, 
               ssDetect, 
               ssAcqHalt, 
               irq_bridge_11b, 
               regBusIn, regWeIn, regReIn, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter bOut_w            = 0;
  parameter tx20_w            = 0;
  parameter bIn_w             = 0;
  parameter rx20_w            = 0;

  parameter ssDetect_w        = 0;
  parameter ssAcqHalt_w       = 0;

  parameter state11b_w        = 0;
  parameter state11b_r        = 0;
  parameter state11b_s        = 0;
  parameter R_state11b        = 0;
  parameter state11bDbg_w     = 0;
  parameter state11bDbg_r     = 0;
  parameter state11bDbg_s     = 0;
  parameter R_state11bDbg     = 0;

  parameter R_bridge_11b_fifoMst = 0;
  parameter R_bridge_11b_ctrlMst = 0;
  parameter R_bridge_11b_fifoSlv = 0;
  parameter R_bridge_11b_ctrlSlv = 0;

  parameter wt                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [bOut_w-1:0]  bOut;
  output                       bOut_or;
  input                        bOut_ff;
  output                       bOut_we;
  assign                       bOut_we = bOut_or & ~bOut_ff;

  output         [tx20_w-1:0]  tx20;
  output                       tx20_or;
  input                        tx20_ff;
  output                       tx20_we;
  assign                       tx20_we = tx20_or & ~tx20_ff;

  input           [bIn_w-1:0]  bIn;
  output                       bIn_ir;
  input                        bIn_fe;
  output                       bIn_re;
  assign                       bIn_re = bIn_ir & ~bIn_fe;

  input          [rx20_w-1:0]  rx20;
  output                       rx20_ir;
  input                        rx20_fe;
  output                       rx20_re;
  assign                       rx20_re = rx20_ir & ~rx20_fe;

  output     [ssDetect_w-1:0]  ssDetect;
  input     [ssAcqHalt_w-1:0]  ssAcqHalt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Define bridge IRQ to upper module
  output                       irq_bridge_11b;

  // Inputs and outputs for registers
  inout                [15:0]  regBusIn;
  input                        regWeIn;
  input                        regReIn;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire       [state11b_w-1:0]  state11b_q;
  wire       [state11b_w-1:0]  state11b_d;
  wire                         state11b_weint;
  assign                       state11b_weint = 0;

  wire    [state11bDbg_w-1:0]  state11bDbg_q;
  wire    [state11bDbg_w-1:0]  state11bDbg_d;
  wire                         state11bDbg_weint;
  assign                       state11bDbg_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  wire   [15:0] regBus;
  wire          regWe;
  wire          regRe;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg state11b(state11b_q, regBus, state11b_d, state11b_weint, regWe, regRe, clk, reset);
  defparam state11b.w    = state11b_w;
  defparam state11b.rval = state11b_r;
  defparam state11b.sgn  = state11b_s;
  defparam state11b.adr  = R_state11b;

  ereg state11bDbg(state11bDbg_q, regBus, state11bDbg_d, state11bDbg_weint, regWe, regRe, clk, reset);
  defparam state11bDbg.w    = state11bDbg_w;
  defparam state11bDbg.rval = state11bDbg_r;
  defparam state11bDbg.sgn  = state11bDbg_s;
  defparam state11bDbg.adr  = R_state11bDbg;

  // --------------------------------------------------------------------------------------
  // Included bridge

  // ----------------------------------------
  wire                bridge_11b_irqMst;
  wire                bridge_11b_irqSlv;
  wire                bridge_11b_regWeSlvOut;

  bridge bridge_11b(bridge_11b_irqMst,
                    bridge_11b_irqSlv,
                    bridge_11b_regWeSlvOut,
                    regBusIn, regWeIn, regReIn,
                    regBus,   regWe,   regRe,
                    clk, reset);

  defparam bridge_11b.R_fifoMst = R_bridge_11b_fifoMst;
  defparam bridge_11b.R_ctrlMst = R_bridge_11b_ctrlMst;
  defparam bridge_11b.R_fifoSlv = R_bridge_11b_fifoSlv;
  defparam bridge_11b.R_ctrlSlv = R_bridge_11b_ctrlSlv;

  assign irq_bridge_11b = bridge_11b_irqMst;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "X16_11b.v"
  `include "irqCtrl_11b.v"
  `include "tx11b_0.v"
  `include "rx11b_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign tx11b_0_x                 = bIn;
  assign tx11b_0_x_fe              = bIn_fe;
  assign bIn_ir                    = tx11b_0_x_ir;

  assign tx20                      = tx11b_0_y;
  assign tx20_or                   = tx11b_0_y_or;
  assign tx11b_0_y_ff              = tx20_ff;

  assign rx11b_0_x                 = rx20;
  assign rx11b_0_x_fe              = rx20_fe;
  assign rx20_ir                   = rx11b_0_x_ir;

  assign bOut                      = rx11b_0_y;
  assign bOut_or                   = rx11b_0_y_or;
  assign rx11b_0_y_ff              = bOut_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regWe = 0 | X16_11b_regWe | irqCtrl_11b_regWe | tx11b_0_regWe
                      | rx11b_0_regWe | bridge_11b_regWeSlvOut;
  assign regReOut = 0;
  assign regRe = 0 | X16_11b_regRe | irqCtrl_11b_regRe | tx11b_0_regRe
                      | rx11b_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Assign interrupts - inputs
  assign irqCtrl_11b_irqIn[WlanIrqBitCtrl11b_C]                           = bridge_11b_irqSlv;
  assign irqCtrl_11b_irqIn[WlanIrqBitTx11bDone_C]                         = tx11b_0_irqDone;
  assign irqCtrl_11b_irqIn[15:WlanIrqBitTx11bDone_C+1]                    = 0;

  // Assign IRQ output
  assign X16_11b_irqExt = irqCtrl_11b_irqOut;

  // Connect AGC control signals
  assign ssDetect           = 0;
//  assign rx11a_0_ssAcqHalt  = ssAcqHalt;


endmodule
//=========================================================================================

