//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   main11
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module main11(bOut, bOut_or, bOut_ff, bOut_we, 
              tx80, tx80_or, tx80_ff, tx80_we, 
              attn, attn_or, attn_ff, attn_we, 
              yRxDbg0, yRxDbg0_or, yRxDbg0_ff, yRxDbg0_we, 
              yRxDbg1, yRxDbg1_or, yRxDbg1_ff, yRxDbg1_we, 
              bIn, bIn_ir, bIn_fe, bIn_re, 
              rx80, rx80_ir, rx80_fe, rx80_re, 
              irq11a, 
              irq11b, 
              dbgLed, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter bOut_w            = 0;
  parameter tx80_w            = 0;
  parameter attn_w            = 0;
  parameter yRxDbg0_w         = 0;
  parameter yRxDbg1_w         = 0;
  parameter bIn_w             = 0;
  parameter rx80_w            = 0;

  parameter irq11a_w          = 0;
  parameter irq11b_w          = 0;
  parameter dbgLed_w          = 0;

  parameter singleAdc_w       = 0;
  parameter singleAdc_r       = 0;
  parameter singleAdc_s       = 0;
  parameter R_singleAdc       = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [bOut_w-1:0]  bOut;
  output                       bOut_or;
  input                        bOut_ff;
  output                       bOut_we;
  assign                       bOut_we = bOut_or & ~bOut_ff;

  output         [tx80_w-1:0]  tx80;
  output                       tx80_or;
  input                        tx80_ff;
  output                       tx80_we;
  assign                       tx80_we = tx80_or & ~tx80_ff;

  output         [attn_w-1:0]  attn;
  output                       attn_or;
  input                        attn_ff;
  output                       attn_we;
  assign                       attn_we = attn_or & ~attn_ff;

  output      [yRxDbg0_w-1:0]  yRxDbg0;
  output                       yRxDbg0_or;
  input                        yRxDbg0_ff;
  output                       yRxDbg0_we;
  assign                       yRxDbg0_we = yRxDbg0_or & ~yRxDbg0_ff;

  output      [yRxDbg1_w-1:0]  yRxDbg1;
  output                       yRxDbg1_or;
  input                        yRxDbg1_ff;
  output                       yRxDbg1_we;
  assign                       yRxDbg1_we = yRxDbg1_or & ~yRxDbg1_ff;

  input           [bIn_w-1:0]  bIn;
  output                       bIn_ir;
  input                        bIn_fe;
  output                       bIn_re;
  assign                       bIn_re = bIn_ir & ~bIn_fe;

  input          [rx80_w-1:0]  rx80;
  output                       rx80_ir;
  input                        rx80_fe;
  output                       rx80_re;
  assign                       rx80_re = rx80_ir & ~rx80_fe;

  output       [irq11a_w-1:0]  irq11a;
  output       [irq11b_w-1:0]  irq11b;
  output       [dbgLed_w-1:0]  dbgLed;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire      [singleAdc_w-1:0]  singleAdc_q;
  wire      [singleAdc_w-1:0]  singleAdc_d;
  wire                         singleAdc_weint;
  assign                       singleAdc_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg singleAdc(singleAdc_q, regBus, singleAdc_d, singleAdc_weint, regWe, regRe, clk, reset);
  defparam singleAdc.w    = singleAdc_w;
  defparam singleAdc.rval = singleAdc_r;
  defparam singleAdc.sgn  = singleAdc_s;
  defparam singleAdc.adr  = R_singleAdc;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "main11a_0.v"
  `include "main11b_0.v"
  `include "rtx80_0.v"
  `include "s1To2Or_8.v"
  `include "s2To1Or_8.v"
  `include "s1To2Or_20.v"
  `include "s2To1Or_20.v"
  `include "agcMain_0.v"
  `include "s1To2And_24.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign s1To2Or_8_x               = bIn;
  assign s1To2Or_8_x_fe            = bIn_fe;
  assign bIn_ir                    = s1To2Or_8_x_ir;

  assign main11a_0_bIn             = s1To2Or_8_y0;
  assign main11a_0_bIn_fe          = ~s1To2Or_8_y0_or;
  assign s1To2Or_8_y0_ff           = ~main11a_0_bIn_ir;

  assign main11b_0_bIn             = s1To2Or_8_y1;
  assign main11b_0_bIn_fe          = ~s1To2Or_8_y1_or;
  assign s1To2Or_8_y1_ff           = ~main11b_0_bIn_ir;

  assign s2To1Or_20_x0             = main11a_0_tx20;
  assign s2To1Or_20_x0_fe          = ~main11a_0_tx20_or;
  assign main11a_0_tx20_ff         = ~s2To1Or_20_x0_ir;

  assign s2To1Or_20_x1             = main11b_0_tx20;
  assign s2To1Or_20_x1_fe          = ~main11b_0_tx20_or;
  assign main11b_0_tx20_ff         = ~s2To1Or_20_x1_ir;

  assign rtx80_0_xTx20             = s2To1Or_20_y;
  assign rtx80_0_xTx20_fe          = ~s2To1Or_20_y_or;
  assign s2To1Or_20_y_ff           = ~rtx80_0_xTx20_ir;

  assign tx80                      = rtx80_0_yTx80;
  assign tx80_or                   = rtx80_0_yTx80_or;
  assign rtx80_0_yTx80_ff          = tx80_ff;

  assign rtx80_0_xRx80             = s1To2And_24_y0;
  assign rtx80_0_xRx80_fe          = ~s1To2And_24_y0_or;
  assign s1To2And_24_y0_ff         = ~rtx80_0_xRx80_ir;

  assign s1To2Or_20_x              = rtx80_0_yRx20;
  assign s1To2Or_20_x_fe           = ~rtx80_0_yRx20_or;
  assign rtx80_0_yRx20_ff          = ~s1To2Or_20_x_ir;

  assign main11a_0_rx20            = s1To2Or_20_y0;
  assign main11a_0_rx20_fe         = ~s1To2Or_20_y0_or;
  assign s1To2Or_20_y0_ff          = ~main11a_0_rx20_ir;

  assign main11b_0_rx20            = s1To2Or_20_y1;
  assign main11b_0_rx20_fe         = ~s1To2Or_20_y1_or;
  assign s1To2Or_20_y1_ff          = ~main11b_0_rx20_ir;

  assign s2To1Or_8_x0              = main11a_0_bOut;
  assign s2To1Or_8_x0_fe           = ~main11a_0_bOut_or;
  assign main11a_0_bOut_ff         = ~s2To1Or_8_x0_ir;

  assign s2To1Or_8_x1              = main11b_0_bOut;
  assign s2To1Or_8_x1_fe           = ~main11b_0_bOut_or;
  assign main11b_0_bOut_ff         = ~s2To1Or_8_x1_ir;

  assign bOut                      = s2To1Or_8_y;
  assign bOut_or                   = s2To1Or_8_y_or;
  assign s2To1Or_8_y_ff            = bOut_ff;

  assign agcMain_0_x               = s1To2And_24_y1;
  assign agcMain_0_x_fe            = ~s1To2And_24_y1_or;
  assign s1To2And_24_y1_ff         = ~agcMain_0_x_ir;

  assign rtx80_0_attnDb            = agcMain_0_attnDb;
  assign rtx80_0_attnDb_fe         = ~agcMain_0_attnDb_or;
  assign agcMain_0_attnDb_ff       = ~rtx80_0_attnDb_ir;

  assign attn                      = agcMain_0_attn;
  assign attn_or                   = agcMain_0_attn_or;
  assign agcMain_0_attn_ff         = attn_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | main11a_0_regWe | main11b_0_regWe | rtx80_0_regWe
                      | s1To2Or_8_regWe | s2To1Or_8_regWe | s1To2Or_20_regWe
                      | s2To1Or_20_regWe | agcMain_0_regWe | s1To2And_24_regWe;
  assign regReOut = 0 | main11a_0_regRe | main11b_0_regRe | rtx80_0_regRe
                      | s1To2Or_8_regRe | s2To1Or_8_regRe | s1To2Or_20_regRe
                      | s2To1Or_20_regRe | agcMain_0_regRe | s1To2And_24_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Possibly set imaginary part 0 on single ADC config
  assign  s1To2And_24_x     = singleAdc_q==0 ? rx80 : {{w{1'b0}}, rx80[w-1:0]};
  assign  s1To2And_24_x_fe  = rx80_fe;
  assign  rx80_ir           = s1To2And_24_x_ir;

  // --------------------------------------------------------------------------------------
  // Pass IRQs from subsystems to upper modules
  assign irq11a = main11a_0_irq_bridge_11a;
  assign irq11b = main11b_0_irq_bridge_11b;

  // Connect AGC control signals
  assign agcMain_0_ssDetect   = main11a_0_ssDetect;
  assign main11a_0_ssAcqHalt  = agcMain_0_ssAcqHalt;

  // --------------------------------------------------------------------------------------
  // Connect debug outputs - currently unused
  assign main11a_0_yAcqCor_ff   = 0;
  assign main11a_0_yAcqPh_ff    = 0;
  assign main11a_0_yAcqAbs_ff   = 0;
  assign main11a_0_ySyncAbs_ff  = 0;
  assign main11a_0_ySyncC_ff    = 0;
  assign main11a_0_ySyncSh_ff   = 0;
  assign main11a_0_yDemD_ff     = 0;
  assign main11a_0_yDemP_ff     = 0;
  assign main11a_0_yDemSb_ff    = 0;
  assign main11a_0_yDecSb_ff    = 0;
  assign main11a_0_yDecSb2_ff   = 0;
  assign main11a_0_yDecVit_ff   = 0;

  // Debug outputs of this module - currently unused
  assign yRxDbg0_or             = 0;
  assign yRxDbg0                = 0;
  assign yRxDbg1_or             = 0;
  assign yRxDbg1                = 0;
  
  // Test - currently not used, must be enabled in the upper module
  assign dbgLed = 0;
//  assign dbgLed = agcMain_0_dbgLed;

endmodule
//=========================================================================================

