//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   main
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module main(ctrlOut, ctrlOut_or, ctrlOut_ff, ctrlOut_we, 
            dacRe, dacRe_or, dacRe_ff, dacRe_we, 
            dacIm, dacIm_or, dacIm_ff, dacIm_we, 
            dataRx, dataRx_or, dataRx_ff, dataRx_we, 
            attn, attn_or, attn_ff, attn_we, 
            ctrlIn, ctrlIn_ir, ctrlIn_fe, ctrlIn_re, 
            adcRe, adcRe_ir, adcRe_fe, adcRe_re, 
            adcIm, adcIm_ir, adcIm_fe, adcIm_re, 
            dataTx, dataTx_ir, dataTx_fe, dataTx_re, 
            uartOut, 
            statLed, 
            resetOut, 
            paOn, 
            txOn, 
            rxOn, 
            twbClk, 
            twbDat, 
            twbEn, 
            gpo, 
            uartIn, 
            ctrlSel, 
            gpi, 
            regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter ctrlOut_w         = 0;
  parameter dacRe_w           = 0;
  parameter dacIm_w           = 0;
  parameter dataRx_w          = 0;
  parameter attn_w            = 0;
  parameter ctrlIn_w          = 0;
  parameter adcRe_w           = 0;
  parameter adcIm_w           = 0;
  parameter dataTx_w          = 0;

  parameter uartOut_w         = 0;
  parameter statLed_w         = 0;
  parameter resetOut_w        = 0;
  parameter paOn_w            = 0;
  parameter txOn_w            = 0;
  parameter rxOn_w            = 0;
  parameter twbClk_w          = 0;
  parameter twbDat_w          = 0;
  parameter twbEn_w           = 0;
  parameter gpo_w             = 0;
  parameter uartIn_w          = 0;
  parameter ctrlSel_w         = 0;
  parameter gpi_w             = 0;

  parameter resetReg_w        = 0;
  parameter resetReg_r        = 0;
  parameter resetReg_s        = 0;
  parameter R_resetReg        = 0;
  parameter rxRfCtrl_w        = 0;
  parameter rxRfCtrl_r        = 0;
  parameter rxRfCtrl_s        = 0;
  parameter R_rxRfCtrl        = 0;
  parameter txDataSrcSel_w    = 0;
  parameter txDataSrcSel_r    = 0;
  parameter txDataSrcSel_s    = 0;
  parameter R_txDataSrcSel    = 0;
  parameter twbClkR_w         = 0;
  parameter twbClkR_r         = 0;
  parameter twbClkR_s         = 0;
  parameter R_twbClkR         = 0;
  parameter twbDatR_w         = 0;
  parameter twbDatR_r         = 0;
  parameter twbDatR_s         = 0;
  parameter R_twbDatR         = 0;
  parameter twbEnR_w          = 0;
  parameter twbEnR_r          = 0;
  parameter twbEnR_s          = 0;
  parameter R_twbEnR          = 0;
  parameter gpoR_w            = 0;
  parameter gpoR_r            = 0;
  parameter gpoR_s            = 0;
  parameter R_gpoR            = 0;
  parameter gpiR_w            = 0;
  parameter gpiR_r            = 0;
  parameter gpiR_s            = 0;
  parameter R_gpiR            = 0;
  parameter stat_w            = 0;
  parameter stat_r            = 0;
  parameter stat_s            = 0;
  parameter R_stat            = 0;

  parameter extIf2Host_w      = 0;
  parameter extIf2Host_n      = 0;
  parameter extIf2Host_m      = 0;
  parameter R_extIf2Host      = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output      [ctrlOut_w-1:0]  ctrlOut;
  output                       ctrlOut_or;
  input                        ctrlOut_ff;
  output                       ctrlOut_we;
  assign                       ctrlOut_we = ctrlOut_or & ~ctrlOut_ff;

  output        [dacRe_w-1:0]  dacRe;
  output                       dacRe_or;
  input                        dacRe_ff;
  output                       dacRe_we;
  assign                       dacRe_we = dacRe_or & ~dacRe_ff;

  output        [dacIm_w-1:0]  dacIm;
  output                       dacIm_or;
  input                        dacIm_ff;
  output                       dacIm_we;
  assign                       dacIm_we = dacIm_or & ~dacIm_ff;

  output       [dataRx_w-1:0]  dataRx;
  output                       dataRx_or;
  input                        dataRx_ff;
  output                       dataRx_we;
  assign                       dataRx_we = dataRx_or & ~dataRx_ff;

  output         [attn_w-1:0]  attn;
  output                       attn_or;
  input                        attn_ff;
  output                       attn_we;
  assign                       attn_we = attn_or & ~attn_ff;

  input        [ctrlIn_w-1:0]  ctrlIn;
  output                       ctrlIn_ir;
  input                        ctrlIn_fe;
  output                       ctrlIn_re;
  assign                       ctrlIn_re = ctrlIn_ir & ~ctrlIn_fe;

  input         [adcRe_w-1:0]  adcRe;
  output                       adcRe_ir;
  input                        adcRe_fe;
  output                       adcRe_re;
  assign                       adcRe_re = adcRe_ir & ~adcRe_fe;

  input         [adcIm_w-1:0]  adcIm;
  output                       adcIm_ir;
  input                        adcIm_fe;
  output                       adcIm_re;
  assign                       adcIm_re = adcIm_ir & ~adcIm_fe;

  input        [dataTx_w-1:0]  dataTx;
  output                       dataTx_ir;
  input                        dataTx_fe;
  output                       dataTx_re;
  assign                       dataTx_re = dataTx_ir & ~dataTx_fe;

  output      [uartOut_w-1:0]  uartOut;
  output      [statLed_w-1:0]  statLed;
  output     [resetOut_w-1:0]  resetOut;
  output         [paOn_w-1:0]  paOn;
  output         [txOn_w-1:0]  txOn;
  output         [rxOn_w-1:0]  rxOn;
  output       [twbClk_w-1:0]  twbClk;
  output       [twbDat_w-1:0]  twbDat;
  output        [twbEn_w-1:0]  twbEn;
  output          [gpo_w-1:0]  gpo;
  input        [uartIn_w-1:0]  uartIn;
  input       [ctrlSel_w-1:0]  ctrlSel;
  input           [gpi_w-1:0]  gpi;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire       [resetReg_w-1:0]  resetReg_q;
  wire       [resetReg_w-1:0]  resetReg_d;
  wire                         resetReg_weint;
  assign                       resetReg_weint = 0;

  wire       [rxRfCtrl_w-1:0]  rxRfCtrl_q;
  wire       [rxRfCtrl_w-1:0]  rxRfCtrl_d;
  wire                         rxRfCtrl_weint;
  assign                       rxRfCtrl_weint = 0;

  wire   [txDataSrcSel_w-1:0]  txDataSrcSel_q;
  wire   [txDataSrcSel_w-1:0]  txDataSrcSel_d;
  wire                         txDataSrcSel_weint;
  assign                       txDataSrcSel_weint = 0;

  wire        [twbClkR_w-1:0]  twbClkR_q;
  wire        [twbClkR_w-1:0]  twbClkR_d;
  wire                         twbClkR_weint;
  assign                       twbClkR_weint = 0;

  wire        [twbDatR_w-1:0]  twbDatR_q;
  wire        [twbDatR_w-1:0]  twbDatR_d;
  wire                         twbDatR_weint;
  assign                       twbDatR_weint = 0;

  wire         [twbEnR_w-1:0]  twbEnR_q;
  wire         [twbEnR_w-1:0]  twbEnR_d;
  wire                         twbEnR_weint;
  assign                       twbEnR_weint = 0;

  wire           [gpoR_w-1:0]  gpoR_q;
  wire           [gpoR_w-1:0]  gpoR_d;
  wire                         gpoR_weint;
  assign                       gpoR_weint = 0;

  wire           [gpiR_w-1:0]  gpiR_q;
  wire           [gpiR_w-1:0]  gpiR_d;
  wire                         gpiR_weint;

  wire           [stat_w-1:0]  stat_q;
  wire           [stat_w-1:0]  stat_d;
  wire                         stat_weint;
  assign                       stat_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg resetReg(resetReg_q, regBus, resetReg_d, resetReg_weint, regWe, regRe, clk, reset);
  defparam resetReg.w    = resetReg_w;
  defparam resetReg.rval = resetReg_r;
  defparam resetReg.sgn  = resetReg_s;
  defparam resetReg.adr  = R_resetReg;

  ereg rxRfCtrl(rxRfCtrl_q, regBus, rxRfCtrl_d, rxRfCtrl_weint, regWe, regRe, clk, reset);
  defparam rxRfCtrl.w    = rxRfCtrl_w;
  defparam rxRfCtrl.rval = rxRfCtrl_r;
  defparam rxRfCtrl.sgn  = rxRfCtrl_s;
  defparam rxRfCtrl.adr  = R_rxRfCtrl;

  ereg txDataSrcSel(txDataSrcSel_q, regBus, txDataSrcSel_d, txDataSrcSel_weint, regWe, regRe, clk, reset);
  defparam txDataSrcSel.w    = txDataSrcSel_w;
  defparam txDataSrcSel.rval = txDataSrcSel_r;
  defparam txDataSrcSel.sgn  = txDataSrcSel_s;
  defparam txDataSrcSel.adr  = R_txDataSrcSel;

  ereg twbClkR(twbClkR_q, regBus, twbClkR_d, twbClkR_weint, regWe, regRe, clk, reset);
  defparam twbClkR.w    = twbClkR_w;
  defparam twbClkR.rval = twbClkR_r;
  defparam twbClkR.sgn  = twbClkR_s;
  defparam twbClkR.adr  = R_twbClkR;

  ereg twbDatR(twbDatR_q, regBus, twbDatR_d, twbDatR_weint, regWe, regRe, clk, reset);
  defparam twbDatR.w    = twbDatR_w;
  defparam twbDatR.rval = twbDatR_r;
  defparam twbDatR.sgn  = twbDatR_s;
  defparam twbDatR.adr  = R_twbDatR;

  ereg twbEnR(twbEnR_q, regBus, twbEnR_d, twbEnR_weint, regWe, regRe, clk, reset);
  defparam twbEnR.w    = twbEnR_w;
  defparam twbEnR.rval = twbEnR_r;
  defparam twbEnR.sgn  = twbEnR_s;
  defparam twbEnR.adr  = R_twbEnR;

  ereg gpoR(gpoR_q, regBus, gpoR_d, gpoR_weint, regWe, regRe, clk, reset);
  defparam gpoR.w    = gpoR_w;
  defparam gpoR.rval = gpoR_r;
  defparam gpoR.sgn  = gpoR_s;
  defparam gpoR.adr  = R_gpoR;

  ereg gpiR(gpiR_q, regBus, gpiR_d, gpiR_weint, regWe, regRe, clk, reset);
  defparam gpiR.w    = gpiR_w;
  defparam gpiR.rval = gpiR_r;
  defparam gpiR.sgn  = gpiR_s;
  defparam gpiR.adr  = R_gpiR;

  ereg stat(stat_q, regBus, stat_d, stat_weint, regWe, regRe, clk, reset);
  defparam stat.w    = stat_w;
  defparam stat.rval = stat_r;
  defparam stat.sgn  = stat_s;
  defparam stat.adr  = R_stat;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "uart16_wlan.v"
  `include "extIf_0.v"
  `include "irqCtrl_wlan.v"
  `include "s1To2Sel_16.v"
  `include "s2To1Sel_16.v"
  `include "s2To1Sel_8.v"
  `include "X16_0.v"
  `include "main11_0.v"
  `include "timer_0.v"
  `include "txRfCtrl_0.v"
  `include "dcfBuf_0.v"
  `include "dataGen_0.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo extIf_0_tx -> s1To2Sel_16_x
  wire   [extIf2Host_w-1:0]  extIf2Host_q;
  wire                       extIf2Host_fe;
  wire                       extIf2Host_ff;
  wire                       extIf2Host_ff2;
  wire                       extIf2Host_fuf;
  wire                       extIf2Host_fof;
  wire   [extIf2Host_w-1:0]  extIf2Host_d;
  wire                       extIf2Host_re;
  wire                       extIf2Host_we;
  wire                       extIf2Host_ir;
  wire                       extIf2Host_or;
  wire                       extIf2Host_rst;

  fifoB extIf2Host(extIf2Host_q, extIf2Host_fe, extIf2Host_ff, extIf2Host_ff2, extIf2Host_fuf,
                   extIf2Host_fof, extIf2Host_d, extIf2Host_re, extIf2Host_we, extIf2Host_ir,
                   extIf2Host_or, extIf2Host_rst, clk);
  defparam extIf2Host.w = extIf2Host_w;
  defparam extIf2Host.m = extIf2Host_m;
  defparam extIf2Host.n = extIf2Host_n;
  defparam extIf2Host.a = R_extIf2Host;

  assign extIf2Host_d              = extIf_0_tx;
  assign extIf2Host_we             = extIf_0_tx_we;
  assign extIf_0_tx_ff             = extIf2Host_ff;
  assign extIf2Host_or             = extIf_0_tx_or;

  assign s1To2Sel_16_x             = extIf2Host_q;
  assign s1To2Sel_16_x_fe          = extIf2Host_fe;
  assign extIf2Host_re             = s1To2Sel_16_x_re;
  assign extIf2Host_ir             = s1To2Sel_16_x_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign s2To1Sel_16_sel           = ctrlSel;
  assign s2To1Sel_16_x0            = ctrlIn;
  assign s2To1Sel_16_x0_fe         = ctrlIn_fe;
  assign ctrlIn_ir                 = s2To1Sel_16_x0_ir;

  assign s2To1Sel_16_x1            = uart16_wlan_rxExtIf;
  assign s2To1Sel_16_x1_fe         = ~uart16_wlan_rxExtIf_or;
  assign uart16_wlan_rxExtIf_ff    = ~s2To1Sel_16_x1_ir;

  assign extIf_0_rx                = s2To1Sel_16_y;
  assign extIf_0_rx_fe             = ~s2To1Sel_16_y_or;
  assign s2To1Sel_16_y_ff          = ~extIf_0_rx_ir;

  assign s1To2Sel_16_sel           = ctrlSel;
  assign ctrlOut                   = s1To2Sel_16_y0;
  assign ctrlOut_or                = s1To2Sel_16_y0_or;
  assign s1To2Sel_16_y0_ff         = ctrlOut_ff;

  assign uart16_wlan_txExtIf       = s1To2Sel_16_y1;
  assign uart16_wlan_txExtIf_fe    = ~s1To2Sel_16_y1_or;
  assign s1To2Sel_16_y1_ff         = ~uart16_wlan_txExtIf_ir;

  assign uart16_wlan_rxs           = uartIn;
  assign uartOut                   = uart16_wlan_txs;
  assign dcfBuf_0_txHost           = dataTx;
  assign dcfBuf_0_txHost_fe        = dataTx_fe;
  assign dataTx_ir                 = dcfBuf_0_txHost_ir;

  assign s2To1Sel_8_x0             = dcfBuf_0_txPhy;
  assign s2To1Sel_8_x0_fe          = ~dcfBuf_0_txPhy_or;
  assign dcfBuf_0_txPhy_ff         = ~s2To1Sel_8_x0_ir;

  assign s2To1Sel_8_x1             = dataGen_0_y;
  assign s2To1Sel_8_x1_fe          = ~dataGen_0_y_or;
  assign dataGen_0_y_ff            = ~s2To1Sel_8_x1_ir;

  assign main11_0_bIn              = s2To1Sel_8_y;
  assign main11_0_bIn_fe           = ~s2To1Sel_8_y_or;
  assign s2To1Sel_8_y_ff           = ~main11_0_bIn_ir;

  assign s2To1Sel_8_sel            = txDataSrcSel_q;
  assign dcfBuf_0_rxPhy            = main11_0_bOut;
  assign dcfBuf_0_rxPhy_fe         = ~main11_0_bOut_or;
  assign main11_0_bOut_ff          = ~dcfBuf_0_rxPhy_ir;

  assign dataRx                    = dcfBuf_0_rxHost;
  assign dataRx_or                 = dcfBuf_0_rxHost_or;
  assign dcfBuf_0_rxHost_ff        = dataRx_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | uart16_wlan_regWe | extIf_0_regWe | irqCtrl_wlan_regWe
                      | s1To2Sel_16_regWe | s2To1Sel_16_regWe | s2To1Sel_8_regWe
                      | X16_0_regWe | main11_0_regWe | timer_0_regWe
                      | txRfCtrl_0_regWe | dcfBuf_0_regWe | dataGen_0_regWe;
  assign regReOut = 0 | uart16_wlan_regRe | extIf_0_regRe | irqCtrl_wlan_regRe
                      | s1To2Sel_16_regRe | s2To1Sel_16_regRe | s2To1Sel_8_regRe
                      | X16_0_regRe | main11_0_regRe | timer_0_regRe
                      | txRfCtrl_0_regRe | dcfBuf_0_regRe | dataGen_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Assign reset output
  assign resetOut                   = extIf_0_resetOut | resetReg_q;
  
  // ExtIf output FIFO reset
  assign extIf2Host_rst             = reset;
  
  // External X16-IRQ
  assign X16_0_irqExt                             = irqCtrl_wlan_irqOut;
  assign irqCtrl_wlan_irqIn[WlanIrqBitExtIfRx_C]  = extIf_0_irqRx;
  assign irqCtrl_wlan_irqIn[WlanIrqBitExtIfTx_C]  = extIf_0_irqTx;
  assign irqCtrl_wlan_irqIn[WlanIrqBitSs11a_C]    = main11_0_irq11a;
  assign irqCtrl_wlan_irqIn[WlanIrqBitSs11b_C]    = main11_0_irq11b;
  assign irqCtrl_wlan_irqIn[WlanIrqBitTMatch0_C]  = timer_0_irqOut[0];
  assign irqCtrl_wlan_irqIn[WlanIrqBitTMatch1_C]  = timer_0_irqOut[1];
  assign irqCtrl_wlan_irqIn[WlanIrqBitDcfRx_C]    = dcfBuf_0_irqRx;
  assign irqCtrl_wlan_irqIn[WlanIrqBitDcfTx_C]    = dcfBuf_0_irqTx;

  // Assign DACs
  assign dacRe                      = main11_0_tx80[11: 0];
  assign dacIm                      = main11_0_tx80[23:12];
  assign main11_0_tx80_ff           = ~txRfCtrl_0_bbOn | dacRe_ff | dacIm_ff;

  // Assign ADCs
  assign main11_0_rx80              = {adcIm[11:0], adcRe[11:0]};
  assign main11_0_rx80_fe           = adcRe_fe | adcIm_fe;

  // Connect RF control signals
  assign attn                       = main11_0_attn;
  assign attn_or                    = main11_0_attn_or;
  
  assign paOn                       = txRfCtrl_0_paOn;
  assign txOn                       = txRfCtrl_0_txOn;
  assign rxOn                       = rxRfCtrl_q;

  assign twbClk                     = twbClkR_q;
  assign twbDat                     = twbDatR_q;
  assign twbEn                      = twbEnR_q;

  // Connect GPIOs
  assign gpo                        = gpoR_q;   // Ereg  -> output
  assign gpiR_d                     = gpi;      // Input -> Ereg
  assign gpiR_weint                 = 1;        //  => always enable
  
  // Connect BB counter enable from timer -> TX-RF control
  assign txRfCtrl_0_tCnt            = timer_0_tCnt;
  
  // Debug LEDs
  assign statLed = stat_q;
    
//----------------------------------------------------------------------------------------

endmodule
//=========================================================================================

