//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   lsMul
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module lsMul(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             run1, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf2_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_20_y;
  assign y_or                      = buf2_20_y_or;
  assign buf2_20_y_ff              = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf2_20_regWe;
  assign regReOut = 0 | buf2_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg signed     [w-1:0]  xRe, xIm, xReS, xImS;
  reg          [2*w-1:0]  mulOut;
  reg             [63:0]  lsPat0, lsPat1;
  wire                    lsPatShift;
  
  // --------------------------------------------------------------------------------------
  // Enable output buffer run
  assign buf2_20_run1 = run1!=0;
  
  // Assign input and output enable
  assign x_ir         = run1!=0 & (buf2_20_x_ir | (lsPat0[63]==0 & (run1==2 | run1==3)));
  assign buf2_20_x_fe = ~(run1!=0 & (~x_fe & (lsPat0[63]==1 | run1==1)));
  assign buf2_20_x    = mulOut;
  
  // Define condition for shifing the LS pattern
  assign lsPatShift = x_re;

  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    // Split input from FFT into real and imag part
    xRe = x[  w-1:0];
    xIm = x[2*w-1:w];
    
    // Shift right >> 2 for CCF
    if (run1==1) begin
      xReS = xRe >>> 2;
      xImS = xIm >>> 2;
    end else begin
      xReS = xRe;
      xImS = xIm;
    end
    
    // Conditional inversion according to sequence output, depends on run mode
    mulOut = lsPat0[63]==0           ? 0              :   // Output is 0 if lsPat0[63]==0
             lsPat1[63]==0 | run1==3 ? { xImS,  xReS} :   // Invert only if run1!=3
                                       {-xImS, -xReS};
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin
      lsPat0    <= 64'b0000001111111111111111111111111101111111111111111111111111100000;
      lsPat1    <= 64'b0000000011001010000001100101000000110010101111100110101000000000;
      
    // Normal operation
    end else begin

      // Shift of LS pattern
      if (lsPatShift) begin
        lsPat0 <= {lsPat0[62:0], lsPat0[63]};
        lsPat1 <= {lsPat1[62:0], lsPat1[63]};
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

