//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter wdfCore_im1_x_w             = 14;
  parameter wdfCore_im1_c_w             = 12;
  parameter wdfCore_im1_selA_w          = 1;
  parameter wdfCore_im1_selB_w          = 2;
  parameter wdfCore_im1_selS_w          = 2;

  // Outputs
  parameter wdfCore_im1_y_w             = 14;

  // Input control lines
  parameter wdfCore_im1_run1_w          = 2;

  // Output control lines

  // Eregs

  // Parameters
  parameter wdfCore_im1_w               = 14;
  parameter wdfCore_im1_wc              = 12;

  // Iregs
  parameter wdfCore_im1_B_w             = 14;
  parameter wdfCore_im1_B_n             = 4;
  parameter wdfCore_im1_B_m             = `CLOG2(4);
  parameter wdfCore_im1_R_w             = 14;
  parameter wdfCore_im1_R_n             = 1;
  parameter wdfCore_im1_R_m             = `CLOG2(1);
  parameter wdfCore_im1_S_w             = 14;
  parameter wdfCore_im1_S_n             = 1;
  parameter wdfCore_im1_S_m             = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam wdfCore_im1.x_w             = wdfCore_im1_x_w;
  defparam wdfCore_im1.c_w             = wdfCore_im1_c_w;
  defparam wdfCore_im1.selA_w          = wdfCore_im1_selA_w;
  defparam wdfCore_im1.selB_w          = wdfCore_im1_selB_w;
  defparam wdfCore_im1.selS_w          = wdfCore_im1_selS_w;
  defparam wdfCore_im1.y_w             = wdfCore_im1_y_w;
  defparam wdfCore_im1.run1_w          = wdfCore_im1_run1_w;
  defparam wdfCore_im1.w               = wdfCore_im1_w;
  defparam wdfCore_im1.wc              = wdfCore_im1_wc;
  defparam wdfCore_im1.B_w             = wdfCore_im1_B_w;
  defparam wdfCore_im1.B_n             = wdfCore_im1_B_n;
  defparam wdfCore_im1.B_m             = wdfCore_im1_B_m;
  defparam wdfCore_im1.R_w             = wdfCore_im1_R_w;
  defparam wdfCore_im1.R_n             = wdfCore_im1_R_n;
  defparam wdfCore_im1.R_m             = wdfCore_im1_R_m;
  defparam wdfCore_im1.S_w             = wdfCore_im1_S_w;
  defparam wdfCore_im1.S_n             = wdfCore_im1_S_n;
  defparam wdfCore_im1.S_m             = wdfCore_im1_S_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [wdfCore_im1_y_w-1:0]  wdfCore_im1_y;
  wire                                      wdfCore_im1_y_or;
  wire                                      wdfCore_im1_y_ff;
  wire                                      wdfCore_im1_y_we;

  wire               [wdfCore_im1_x_w-1:0]  wdfCore_im1_x;
  wire                                      wdfCore_im1_x_ir;
  wire                                      wdfCore_im1_x_fe;
  wire                                      wdfCore_im1_x_re;

  wire               [wdfCore_im1_c_w-1:0]  wdfCore_im1_c;
  wire                                      wdfCore_im1_c_ir;
  wire                                      wdfCore_im1_c_fe;
  wire                                      wdfCore_im1_c_re;

  wire            [wdfCore_im1_selA_w-1:0]  wdfCore_im1_selA;
  wire                                      wdfCore_im1_selA_ir;
  wire                                      wdfCore_im1_selA_fe;
  wire                                      wdfCore_im1_selA_re;

  wire            [wdfCore_im1_selB_w-1:0]  wdfCore_im1_selB;
  wire                                      wdfCore_im1_selB_ir;
  wire                                      wdfCore_im1_selB_fe;
  wire                                      wdfCore_im1_selB_re;

  wire            [wdfCore_im1_selS_w-1:0]  wdfCore_im1_selS;
  wire                                      wdfCore_im1_selS_ir;
  wire                                      wdfCore_im1_selS_fe;
  wire                                      wdfCore_im1_selS_re;

  wire            [wdfCore_im1_run1_w-1:0]  wdfCore_im1_run1;

  wire                                      wdfCore_im1_regWe;
  wire                                      wdfCore_im1_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  wdfCore wdfCore_im1(wdfCore_im1_y, wdfCore_im1_y_or, wdfCore_im1_y_ff, wdfCore_im1_y_we,
                      wdfCore_im1_x, wdfCore_im1_x_ir, wdfCore_im1_x_fe, wdfCore_im1_x_re, 
                      wdfCore_im1_c, wdfCore_im1_c_ir, wdfCore_im1_c_fe, wdfCore_im1_c_re, 
                      wdfCore_im1_selA, wdfCore_im1_selA_ir, wdfCore_im1_selA_fe, wdfCore_im1_selA_re, 
                      wdfCore_im1_selB, wdfCore_im1_selB_ir, wdfCore_im1_selB_fe, wdfCore_im1_selB_re, 
                      wdfCore_im1_selS, wdfCore_im1_selS_ir, wdfCore_im1_selS_fe, wdfCore_im1_selS_re, 
                      wdfCore_im1_run1, 
                      regBus, regWe, regRe, wdfCore_im1_regWe, wdfCore_im1_regRe, clk, clk2, reset);


//==============================================================================
