//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitTbd_1_selA_w          = 32;
  parameter vitTbd_1_selB_w          = 32;

  // Outputs
  parameter vitTbd_1_b_w             = 1;
  parameter vitTbd_1_endIdx_w        = 6;
  parameter vitTbd_1_yIdx_w          = 6;

  // Input control lines
  parameter vitTbd_1_run1_w          = 1;
  parameter vitTbd_1_startIdx_w      = 6;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitTbd_1_ws              = 64;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitTbd_1.selA_w          = vitTbd_1_selA_w;
  defparam vitTbd_1.selB_w          = vitTbd_1_selB_w;
  defparam vitTbd_1.b_w             = vitTbd_1_b_w;
  defparam vitTbd_1.endIdx_w        = vitTbd_1_endIdx_w;
  defparam vitTbd_1.yIdx_w          = vitTbd_1_yIdx_w;
  defparam vitTbd_1.run1_w          = vitTbd_1_run1_w;
  defparam vitTbd_1.startIdx_w      = vitTbd_1_startIdx_w;
  defparam vitTbd_1.ws              = vitTbd_1_ws;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [vitTbd_1_b_w-1:0]  vitTbd_1_b;
  wire                                      vitTbd_1_b_or;
  wire                                      vitTbd_1_b_ff;
  wire                                      vitTbd_1_b_we;

  wire             [vitTbd_1_endIdx_w-1:0]  vitTbd_1_endIdx;
  wire                                      vitTbd_1_endIdx_or;
  wire                                      vitTbd_1_endIdx_ff;
  wire                                      vitTbd_1_endIdx_we;

  wire               [vitTbd_1_yIdx_w-1:0]  vitTbd_1_yIdx;
  wire                                      vitTbd_1_yIdx_or;
  wire                                      vitTbd_1_yIdx_ff;
  wire                                      vitTbd_1_yIdx_we;

  wire               [vitTbd_1_selA_w-1:0]  vitTbd_1_selA;
  wire                                      vitTbd_1_selA_ir;
  wire                                      vitTbd_1_selA_fe;
  wire                                      vitTbd_1_selA_re;

  wire               [vitTbd_1_selB_w-1:0]  vitTbd_1_selB;
  wire                                      vitTbd_1_selB_ir;
  wire                                      vitTbd_1_selB_fe;
  wire                                      vitTbd_1_selB_re;

  wire               [vitTbd_1_run1_w-1:0]  vitTbd_1_run1;
  wire           [vitTbd_1_startIdx_w-1:0]  vitTbd_1_startIdx;

  wire                                      vitTbd_1_regWe;
  wire                                      vitTbd_1_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitTbd vitTbd_1(vitTbd_1_b, vitTbd_1_b_or, vitTbd_1_b_ff, vitTbd_1_b_we,
                  vitTbd_1_endIdx, vitTbd_1_endIdx_or, vitTbd_1_endIdx_ff, vitTbd_1_endIdx_we,
                  vitTbd_1_yIdx, vitTbd_1_yIdx_or, vitTbd_1_yIdx_ff, vitTbd_1_yIdx_we,
                  vitTbd_1_selA, vitTbd_1_selA_ir, vitTbd_1_selA_fe, vitTbd_1_selA_re, 
                  vitTbd_1_selB, vitTbd_1_selB_ir, vitTbd_1_selB_fe, vitTbd_1_selB_re, 
                  vitTbd_1_run1, 
                  vitTbd_1_startIdx, 
                  regBus, regWe, regRe, vitTbd_1_regWe, vitTbd_1_regRe, clk, clk2, reset);


//==============================================================================
