//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitTbd_0_selA_w          = 32;
  parameter vitTbd_0_selB_w          = 32;

  // Outputs
  parameter vitTbd_0_b_w             = 1;
  parameter vitTbd_0_endIdx_w        = 6;
  parameter vitTbd_0_yIdx_w          = 6;

  // Input control lines
  parameter vitTbd_0_run1_w          = 1;
  parameter vitTbd_0_startIdx_w      = 6;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitTbd_0_ws              = 64;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitTbd_0.selA_w          = vitTbd_0_selA_w;
  defparam vitTbd_0.selB_w          = vitTbd_0_selB_w;
  defparam vitTbd_0.b_w             = vitTbd_0_b_w;
  defparam vitTbd_0.endIdx_w        = vitTbd_0_endIdx_w;
  defparam vitTbd_0.yIdx_w          = vitTbd_0_yIdx_w;
  defparam vitTbd_0.run1_w          = vitTbd_0_run1_w;
  defparam vitTbd_0.startIdx_w      = vitTbd_0_startIdx_w;
  defparam vitTbd_0.ws              = vitTbd_0_ws;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [vitTbd_0_b_w-1:0]  vitTbd_0_b;
  wire                                      vitTbd_0_b_or;
  wire                                      vitTbd_0_b_ff;
  wire                                      vitTbd_0_b_we;

  wire             [vitTbd_0_endIdx_w-1:0]  vitTbd_0_endIdx;
  wire                                      vitTbd_0_endIdx_or;
  wire                                      vitTbd_0_endIdx_ff;
  wire                                      vitTbd_0_endIdx_we;

  wire               [vitTbd_0_yIdx_w-1:0]  vitTbd_0_yIdx;
  wire                                      vitTbd_0_yIdx_or;
  wire                                      vitTbd_0_yIdx_ff;
  wire                                      vitTbd_0_yIdx_we;

  wire               [vitTbd_0_selA_w-1:0]  vitTbd_0_selA;
  wire                                      vitTbd_0_selA_ir;
  wire                                      vitTbd_0_selA_fe;
  wire                                      vitTbd_0_selA_re;

  wire               [vitTbd_0_selB_w-1:0]  vitTbd_0_selB;
  wire                                      vitTbd_0_selB_ir;
  wire                                      vitTbd_0_selB_fe;
  wire                                      vitTbd_0_selB_re;

  wire               [vitTbd_0_run1_w-1:0]  vitTbd_0_run1;
  wire           [vitTbd_0_startIdx_w-1:0]  vitTbd_0_startIdx;

  wire                                      vitTbd_0_regWe;
  wire                                      vitTbd_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitTbd vitTbd_0(vitTbd_0_b, vitTbd_0_b_or, vitTbd_0_b_ff, vitTbd_0_b_we,
                  vitTbd_0_endIdx, vitTbd_0_endIdx_or, vitTbd_0_endIdx_ff, vitTbd_0_endIdx_we,
                  vitTbd_0_yIdx, vitTbd_0_yIdx_or, vitTbd_0_yIdx_ff, vitTbd_0_yIdx_we,
                  vitTbd_0_selA, vitTbd_0_selA_ir, vitTbd_0_selA_fe, vitTbd_0_selA_re, 
                  vitTbd_0_selB, vitTbd_0_selB_ir, vitTbd_0_selB_fe, vitTbd_0_selB_re, 
                  vitTbd_0_run1, 
                  vitTbd_0_startIdx, 
                  regBus, regWe, regRe, vitTbd_0_regWe, vitTbd_0_regRe, clk, clk2, reset);


//==============================================================================
