//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitMem_0_wrAdr_w         = 8;
  parameter vitMem_0_rdAdr0_w        = 8;
  parameter vitMem_0_rdAdr1_w        = 8;
  parameter vitMem_0_memInA_w        = 32;
  parameter vitMem_0_memInB_w        = 32;

  // Outputs
  parameter vitMem_0_memOut0A_w      = 32;
  parameter vitMem_0_memOut0B_w      = 32;
  parameter vitMem_0_memOut1A_w      = 32;
  parameter vitMem_0_memOut1B_w      = 32;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters

  // Iregs

  // Single ported memories
  parameter vitMem_0_mem0A_w         = 32;
  parameter vitMem_0_mem0A_n         = 64;
  parameter vitMem_0_mem0A_m         = `CLOG2(64);
  parameter vitMem_0_mem0B_w         = 32;
  parameter vitMem_0_mem0B_n         = 64;
  parameter vitMem_0_mem0B_m         = `CLOG2(64);
  parameter vitMem_0_mem1A_w         = 32;
  parameter vitMem_0_mem1A_n         = 64;
  parameter vitMem_0_mem1A_m         = `CLOG2(64);
  parameter vitMem_0_mem1B_w         = 32;
  parameter vitMem_0_mem1B_n         = 64;
  parameter vitMem_0_mem1B_m         = `CLOG2(64);
  parameter vitMem_0_mem2A_w         = 32;
  parameter vitMem_0_mem2A_n         = 64;
  parameter vitMem_0_mem2A_m         = `CLOG2(64);
  parameter vitMem_0_mem2B_w         = 32;
  parameter vitMem_0_mem2B_n         = 64;
  parameter vitMem_0_mem2B_m         = `CLOG2(64);
  parameter vitMem_0_mem3A_w         = 32;
  parameter vitMem_0_mem3A_n         = 64;
  parameter vitMem_0_mem3A_m         = `CLOG2(64);
  parameter vitMem_0_mem3B_w         = 32;
  parameter vitMem_0_mem3B_n         = 64;
  parameter vitMem_0_mem3B_m         = `CLOG2(64);

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitMem_0.wrAdr_w         = vitMem_0_wrAdr_w;
  defparam vitMem_0.rdAdr0_w        = vitMem_0_rdAdr0_w;
  defparam vitMem_0.rdAdr1_w        = vitMem_0_rdAdr1_w;
  defparam vitMem_0.memInA_w        = vitMem_0_memInA_w;
  defparam vitMem_0.memInB_w        = vitMem_0_memInB_w;
  defparam vitMem_0.memOut0A_w      = vitMem_0_memOut0A_w;
  defparam vitMem_0.memOut0B_w      = vitMem_0_memOut0B_w;
  defparam vitMem_0.memOut1A_w      = vitMem_0_memOut1A_w;
  defparam vitMem_0.memOut1B_w      = vitMem_0_memOut1B_w;
  defparam vitMem_0.mem0A_w         = vitMem_0_mem0A_w;
  defparam vitMem_0.mem0A_n         = vitMem_0_mem0A_n;
  defparam vitMem_0.mem0A_m         = vitMem_0_mem0A_m;
  defparam vitMem_0.mem0B_w         = vitMem_0_mem0B_w;
  defparam vitMem_0.mem0B_n         = vitMem_0_mem0B_n;
  defparam vitMem_0.mem0B_m         = vitMem_0_mem0B_m;
  defparam vitMem_0.mem1A_w         = vitMem_0_mem1A_w;
  defparam vitMem_0.mem1A_n         = vitMem_0_mem1A_n;
  defparam vitMem_0.mem1A_m         = vitMem_0_mem1A_m;
  defparam vitMem_0.mem1B_w         = vitMem_0_mem1B_w;
  defparam vitMem_0.mem1B_n         = vitMem_0_mem1B_n;
  defparam vitMem_0.mem1B_m         = vitMem_0_mem1B_m;
  defparam vitMem_0.mem2A_w         = vitMem_0_mem2A_w;
  defparam vitMem_0.mem2A_n         = vitMem_0_mem2A_n;
  defparam vitMem_0.mem2A_m         = vitMem_0_mem2A_m;
  defparam vitMem_0.mem2B_w         = vitMem_0_mem2B_w;
  defparam vitMem_0.mem2B_n         = vitMem_0_mem2B_n;
  defparam vitMem_0.mem2B_m         = vitMem_0_mem2B_m;
  defparam vitMem_0.mem3A_w         = vitMem_0_mem3A_w;
  defparam vitMem_0.mem3A_n         = vitMem_0_mem3A_n;
  defparam vitMem_0.mem3A_m         = vitMem_0_mem3A_m;
  defparam vitMem_0.mem3B_w         = vitMem_0_mem3B_w;
  defparam vitMem_0.mem3B_n         = vitMem_0_mem3B_n;
  defparam vitMem_0.mem3B_m         = vitMem_0_mem3B_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire           [vitMem_0_memOut0A_w-1:0]  vitMem_0_memOut0A;
  wire                                      vitMem_0_memOut0A_or;
  wire                                      vitMem_0_memOut0A_ff;
  wire                                      vitMem_0_memOut0A_we;

  wire           [vitMem_0_memOut0B_w-1:0]  vitMem_0_memOut0B;
  wire                                      vitMem_0_memOut0B_or;
  wire                                      vitMem_0_memOut0B_ff;
  wire                                      vitMem_0_memOut0B_we;

  wire           [vitMem_0_memOut1A_w-1:0]  vitMem_0_memOut1A;
  wire                                      vitMem_0_memOut1A_or;
  wire                                      vitMem_0_memOut1A_ff;
  wire                                      vitMem_0_memOut1A_we;

  wire           [vitMem_0_memOut1B_w-1:0]  vitMem_0_memOut1B;
  wire                                      vitMem_0_memOut1B_or;
  wire                                      vitMem_0_memOut1B_ff;
  wire                                      vitMem_0_memOut1B_we;

  wire              [vitMem_0_wrAdr_w-1:0]  vitMem_0_wrAdr;
  wire                                      vitMem_0_wrAdr_ir;
  wire                                      vitMem_0_wrAdr_fe;
  wire                                      vitMem_0_wrAdr_re;

  wire             [vitMem_0_rdAdr0_w-1:0]  vitMem_0_rdAdr0;
  wire                                      vitMem_0_rdAdr0_ir;
  wire                                      vitMem_0_rdAdr0_fe;
  wire                                      vitMem_0_rdAdr0_re;

  wire             [vitMem_0_rdAdr1_w-1:0]  vitMem_0_rdAdr1;
  wire                                      vitMem_0_rdAdr1_ir;
  wire                                      vitMem_0_rdAdr1_fe;
  wire                                      vitMem_0_rdAdr1_re;

  wire             [vitMem_0_memInA_w-1:0]  vitMem_0_memInA;
  wire                                      vitMem_0_memInA_ir;
  wire                                      vitMem_0_memInA_fe;
  wire                                      vitMem_0_memInA_re;

  wire             [vitMem_0_memInB_w-1:0]  vitMem_0_memInB;
  wire                                      vitMem_0_memInB_ir;
  wire                                      vitMem_0_memInB_fe;
  wire                                      vitMem_0_memInB_re;

  wire                                      vitMem_0_regWe;
  wire                                      vitMem_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitMem vitMem_0(vitMem_0_memOut0A, vitMem_0_memOut0A_or, vitMem_0_memOut0A_ff, vitMem_0_memOut0A_we,
                  vitMem_0_memOut0B, vitMem_0_memOut0B_or, vitMem_0_memOut0B_ff, vitMem_0_memOut0B_we,
                  vitMem_0_memOut1A, vitMem_0_memOut1A_or, vitMem_0_memOut1A_ff, vitMem_0_memOut1A_we,
                  vitMem_0_memOut1B, vitMem_0_memOut1B_or, vitMem_0_memOut1B_ff, vitMem_0_memOut1B_we,
                  vitMem_0_wrAdr, vitMem_0_wrAdr_ir, vitMem_0_wrAdr_fe, vitMem_0_wrAdr_re, 
                  vitMem_0_rdAdr0, vitMem_0_rdAdr0_ir, vitMem_0_rdAdr0_fe, vitMem_0_rdAdr0_re, 
                  vitMem_0_rdAdr1, vitMem_0_rdAdr1_ir, vitMem_0_rdAdr1_fe, vitMem_0_rdAdr1_re, 
                  vitMem_0_memInA, vitMem_0_memInA_ir, vitMem_0_memInA_fe, vitMem_0_memInA_re, 
                  vitMem_0_memInB, vitMem_0_memInB_ir, vitMem_0_memInB_fe, vitMem_0_memInB_re, 
                  regBus, regWe, regRe, vitMem_0_regWe, vitMem_0_regRe, clk, clk2, reset);


//==============================================================================
