//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitMain_0_x_w             = 8;

  // Outputs
  parameter vitMain_0_y_w             = 8;
  parameter vitMain_0_yIdx0_w         = 6;
  parameter vitMain_0_yIdx1_w         = 6;

  // Input control lines

  // Output control lines
  parameter vitMain_0_irqDone_w       = 2;

  // Eregs
  parameter vitMain_0_run1_w          = 2;
  parameter vitMain_0_run1_r          = 0;
  parameter vitMain_0_run1_s          = 0;
  parameter vitMain_0_numBits_w       = 16;
  parameter vitMain_0_numBits_r       = 0;
  parameter vitMain_0_numBits_s       = 0;
  parameter vitMain_0_rxMode_w        = 3;
  parameter vitMain_0_rxMode_r        = 0;
  parameter vitMain_0_rxMode_s        = 0;
  parameter vitMain_0_rxLen_w         = 12;
  parameter vitMain_0_rxLen_r         = 0;
  parameter vitMain_0_rxLen_s         = 0;
  parameter vitMain_0_pm00_w          = 9;
  parameter vitMain_0_pm00_r          = 0;
  parameter vitMain_0_pm00_s          = 0;

  // Parameters
  parameter vitMain_0_ws              = 4;
  parameter vitMain_0_StPsduReset     = 0;
  parameter vitMain_0_StPsduStart     = 1;
  parameter vitMain_0_StPsduMid       = 2;
  parameter vitMain_0_StPsduMax       = 3;
  parameter vitMain_0_StPsduEnd       = 4;
  parameter vitMain_0_StPsduWait      = 5;
  parameter vitMain_0_StPsduDone      = 6;

  // Iregs
  parameter vitMain_0_cntIn_w         = 16;
  parameter vitMain_0_cntIn_n         = 1;
  parameter vitMain_0_cntIn_m         = `CLOG2(1);
  parameter vitMain_0_stPsdu_w        = 3;
  parameter vitMain_0_stPsdu_n        = 1;
  parameter vitMain_0_stPsdu_m        = `CLOG2(1);
  parameter vitMain_0_wrAdr_w         = 8;
  parameter vitMain_0_wrAdr_n         = 1;
  parameter vitMain_0_wrAdr_m         = `CLOG2(1);
  parameter vitMain_0_rdAdr0_w        = 8;
  parameter vitMain_0_rdAdr0_n        = 1;
  parameter vitMain_0_rdAdr0_m        = `CLOG2(1);
  parameter vitMain_0_rdAdr1_w        = 8;
  parameter vitMain_0_rdAdr1_n        = 1;
  parameter vitMain_0_rdAdr1_m        = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitMain_0.x_w             = vitMain_0_x_w;
  defparam vitMain_0.y_w             = vitMain_0_y_w;
  defparam vitMain_0.yIdx0_w         = vitMain_0_yIdx0_w;
  defparam vitMain_0.yIdx1_w         = vitMain_0_yIdx1_w;
  defparam vitMain_0.irqDone_w       = vitMain_0_irqDone_w;
  defparam vitMain_0.run1_w          = vitMain_0_run1_w;
  defparam vitMain_0.run1_r          = vitMain_0_run1_r;
  defparam vitMain_0.run1_s          = vitMain_0_run1_s;
  defparam vitMain_0.numBits_w       = vitMain_0_numBits_w;
  defparam vitMain_0.numBits_r       = vitMain_0_numBits_r;
  defparam vitMain_0.numBits_s       = vitMain_0_numBits_s;
  defparam vitMain_0.rxMode_w        = vitMain_0_rxMode_w;
  defparam vitMain_0.rxMode_r        = vitMain_0_rxMode_r;
  defparam vitMain_0.rxMode_s        = vitMain_0_rxMode_s;
  defparam vitMain_0.rxLen_w         = vitMain_0_rxLen_w;
  defparam vitMain_0.rxLen_r         = vitMain_0_rxLen_r;
  defparam vitMain_0.rxLen_s         = vitMain_0_rxLen_s;
  defparam vitMain_0.pm00_w          = vitMain_0_pm00_w;
  defparam vitMain_0.pm00_r          = vitMain_0_pm00_r;
  defparam vitMain_0.pm00_s          = vitMain_0_pm00_s;
  defparam vitMain_0.ws              = vitMain_0_ws;
  defparam vitMain_0.StPsduReset     = vitMain_0_StPsduReset;
  defparam vitMain_0.StPsduStart     = vitMain_0_StPsduStart;
  defparam vitMain_0.StPsduMid       = vitMain_0_StPsduMid;
  defparam vitMain_0.StPsduMax       = vitMain_0_StPsduMax;
  defparam vitMain_0.StPsduEnd       = vitMain_0_StPsduEnd;
  defparam vitMain_0.StPsduWait      = vitMain_0_StPsduWait;
  defparam vitMain_0.StPsduDone      = vitMain_0_StPsduDone;
  defparam vitMain_0.cntIn_w         = vitMain_0_cntIn_w;
  defparam vitMain_0.cntIn_n         = vitMain_0_cntIn_n;
  defparam vitMain_0.cntIn_m         = vitMain_0_cntIn_m;
  defparam vitMain_0.stPsdu_w        = vitMain_0_stPsdu_w;
  defparam vitMain_0.stPsdu_n        = vitMain_0_stPsdu_n;
  defparam vitMain_0.stPsdu_m        = vitMain_0_stPsdu_m;
  defparam vitMain_0.wrAdr_w         = vitMain_0_wrAdr_w;
  defparam vitMain_0.wrAdr_n         = vitMain_0_wrAdr_n;
  defparam vitMain_0.wrAdr_m         = vitMain_0_wrAdr_m;
  defparam vitMain_0.rdAdr0_w        = vitMain_0_rdAdr0_w;
  defparam vitMain_0.rdAdr0_n        = vitMain_0_rdAdr0_n;
  defparam vitMain_0.rdAdr0_m        = vitMain_0_rdAdr0_m;
  defparam vitMain_0.rdAdr1_w        = vitMain_0_rdAdr1_w;
  defparam vitMain_0.rdAdr1_n        = vitMain_0_rdAdr1_n;
  defparam vitMain_0.rdAdr1_m        = vitMain_0_rdAdr1_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_vitMain_0_run1                                             = 0;
  defparam  vitMain_0.R_run1                                             = R_vitMain_0_run1;
  parameter R_vitMain_0_numBits                                          = 1;
  defparam  vitMain_0.R_numBits                                          = R_vitMain_0_numBits;
  parameter R_vitMain_0_rxMode                                           = 2;
  defparam  vitMain_0.R_rxMode                                           = R_vitMain_0_rxMode;
  parameter R_vitMain_0_rxLen                                            = 3;
  defparam  vitMain_0.R_rxLen                                            = R_vitMain_0_rxLen;
  parameter R_vitMain_0_pm00                                             = 4;
  defparam  vitMain_0.R_pm00                                             = R_vitMain_0_pm00;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [vitMain_0_y_w-1:0]  vitMain_0_y;
  wire                                      vitMain_0_y_or;
  wire                                      vitMain_0_y_ff;
  wire                                      vitMain_0_y_we;

  wire             [vitMain_0_yIdx0_w-1:0]  vitMain_0_yIdx0;
  wire                                      vitMain_0_yIdx0_or;
  wire                                      vitMain_0_yIdx0_ff;
  wire                                      vitMain_0_yIdx0_we;

  wire             [vitMain_0_yIdx1_w-1:0]  vitMain_0_yIdx1;
  wire                                      vitMain_0_yIdx1_or;
  wire                                      vitMain_0_yIdx1_ff;
  wire                                      vitMain_0_yIdx1_we;

  wire                 [vitMain_0_x_w-1:0]  vitMain_0_x;
  wire                                      vitMain_0_x_ir;
  wire                                      vitMain_0_x_fe;
  wire                                      vitMain_0_x_re;

  wire           [vitMain_0_irqDone_w-1:0]  vitMain_0_irqDone;

  wire                                      vitMain_0_regWe;
  wire                                      vitMain_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitMain vitMain_0(vitMain_0_y, vitMain_0_y_or, vitMain_0_y_ff, vitMain_0_y_we,
                    vitMain_0_yIdx0, vitMain_0_yIdx0_or, vitMain_0_yIdx0_ff, vitMain_0_yIdx0_we,
                    vitMain_0_yIdx1, vitMain_0_yIdx1_or, vitMain_0_yIdx1_ff, vitMain_0_yIdx1_we,
                    vitMain_0_x, vitMain_0_x_ir, vitMain_0_x_fe, vitMain_0_x_re, 
                    vitMain_0_irqDone, 
                    regBus, regWe, regRe, vitMain_0_regWe, vitMain_0_regRe, clk, clk2, reset);


//==============================================================================
