//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitBrev_0_x0_w            = 1;
  parameter vitBrev_0_x1_w            = 1;

  // Outputs
  parameter vitBrev_0_y_w             = 8;
  parameter vitBrev_0_yHdr_w          = 24;

  // Input control lines
  parameter vitBrev_0_run1_w          = 2;
  parameter vitBrev_0_numIn0_w        = 7;

  // Output control lines
  parameter vitBrev_0_irqDone_w       = 2;

  // Eregs

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitBrev_0.x0_w            = vitBrev_0_x0_w;
  defparam vitBrev_0.x1_w            = vitBrev_0_x1_w;
  defparam vitBrev_0.y_w             = vitBrev_0_y_w;
  defparam vitBrev_0.yHdr_w          = vitBrev_0_yHdr_w;
  defparam vitBrev_0.run1_w          = vitBrev_0_run1_w;
  defparam vitBrev_0.numIn0_w        = vitBrev_0_numIn0_w;
  defparam vitBrev_0.irqDone_w       = vitBrev_0_irqDone_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [vitBrev_0_y_w-1:0]  vitBrev_0_y;
  wire                                      vitBrev_0_y_or;
  wire                                      vitBrev_0_y_ff;
  wire                                      vitBrev_0_y_we;

  wire              [vitBrev_0_yHdr_w-1:0]  vitBrev_0_yHdr;
  wire                                      vitBrev_0_yHdr_or;
  wire                                      vitBrev_0_yHdr_ff;
  wire                                      vitBrev_0_yHdr_we;

  wire                [vitBrev_0_x0_w-1:0]  vitBrev_0_x0;
  wire                                      vitBrev_0_x0_ir;
  wire                                      vitBrev_0_x0_fe;
  wire                                      vitBrev_0_x0_re;

  wire                [vitBrev_0_x1_w-1:0]  vitBrev_0_x1;
  wire                                      vitBrev_0_x1_ir;
  wire                                      vitBrev_0_x1_fe;
  wire                                      vitBrev_0_x1_re;

  wire           [vitBrev_0_irqDone_w-1:0]  vitBrev_0_irqDone;

  wire              [vitBrev_0_run1_w-1:0]  vitBrev_0_run1;
  wire            [vitBrev_0_numIn0_w-1:0]  vitBrev_0_numIn0;

  wire                                      vitBrev_0_regWe;
  wire                                      vitBrev_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitBrev vitBrev_0(vitBrev_0_y, vitBrev_0_y_or, vitBrev_0_y_ff, vitBrev_0_y_we,
                    vitBrev_0_yHdr, vitBrev_0_yHdr_or, vitBrev_0_yHdr_ff, vitBrev_0_yHdr_we,
                    vitBrev_0_x0, vitBrev_0_x0_ir, vitBrev_0_x0_fe, vitBrev_0_x0_re, 
                    vitBrev_0_x1, vitBrev_0_x1_ir, vitBrev_0_x1_fe, vitBrev_0_x1_re, 
                    vitBrev_0_irqDone, 
                    vitBrev_0_run1, 
                    vitBrev_0_numIn0, 
                    regBus, regWe, regRe, vitBrev_0_regWe, vitBrev_0_regRe, clk, clk2, reset);


//==============================================================================
