//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_62_sb_w            = 8;
  parameter vitAcs_62_pmIn0_w         = 9;
  parameter vitAcs_62_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_62_sel_w           = 1;
  parameter vitAcs_62_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_62_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_62_i0              = 1;
  parameter vitAcs_62_i1              = 1;
  parameter vitAcs_62_pbrv            = 412;
  parameter vitAcs_62_ws              = 4;
  parameter vitAcs_62_wp              = 9;

  // Iregs
  parameter vitAcs_62_pmBuf_w         = 9;
  parameter vitAcs_62_pmBuf_n         = 1;
  parameter vitAcs_62_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_62.sb_w            = vitAcs_62_sb_w;
  defparam vitAcs_62.pmIn0_w         = vitAcs_62_pmIn0_w;
  defparam vitAcs_62.pmIn1_w         = vitAcs_62_pmIn1_w;
  defparam vitAcs_62.sel_w           = vitAcs_62_sel_w;
  defparam vitAcs_62.pmOut_w         = vitAcs_62_pmOut_w;
  defparam vitAcs_62.run1_w          = vitAcs_62_run1_w;
  defparam vitAcs_62.i0              = vitAcs_62_i0;
  defparam vitAcs_62.i1              = vitAcs_62_i1;
  defparam vitAcs_62.pbrv            = vitAcs_62_pbrv;
  defparam vitAcs_62.ws              = vitAcs_62_ws;
  defparam vitAcs_62.wp              = vitAcs_62_wp;
  defparam vitAcs_62.pmBuf_w         = vitAcs_62_pmBuf_w;
  defparam vitAcs_62.pmBuf_n         = vitAcs_62_pmBuf_n;
  defparam vitAcs_62.pmBuf_m         = vitAcs_62_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_62_sel_w-1:0]  vitAcs_62_sel;
  wire                                      vitAcs_62_sel_or;
  wire                                      vitAcs_62_sel_ff;
  wire                                      vitAcs_62_sel_we;

  wire             [vitAcs_62_pmOut_w-1:0]  vitAcs_62_pmOut;
  wire                                      vitAcs_62_pmOut_or;
  wire                                      vitAcs_62_pmOut_ff;
  wire                                      vitAcs_62_pmOut_we;

  wire                [vitAcs_62_sb_w-1:0]  vitAcs_62_sb;
  wire                                      vitAcs_62_sb_ir;
  wire                                      vitAcs_62_sb_fe;
  wire                                      vitAcs_62_sb_re;

  wire             [vitAcs_62_pmIn0_w-1:0]  vitAcs_62_pmIn0;
  wire                                      vitAcs_62_pmIn0_ir;
  wire                                      vitAcs_62_pmIn0_fe;
  wire                                      vitAcs_62_pmIn0_re;

  wire             [vitAcs_62_pmIn1_w-1:0]  vitAcs_62_pmIn1;
  wire                                      vitAcs_62_pmIn1_ir;
  wire                                      vitAcs_62_pmIn1_fe;
  wire                                      vitAcs_62_pmIn1_re;

  wire              [vitAcs_62_run1_w-1:0]  vitAcs_62_run1;

  wire                                      vitAcs_62_regWe;
  wire                                      vitAcs_62_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_62(vitAcs_62_sel, vitAcs_62_sel_or, vitAcs_62_sel_ff, vitAcs_62_sel_we,
                   vitAcs_62_pmOut, vitAcs_62_pmOut_or, vitAcs_62_pmOut_ff, vitAcs_62_pmOut_we,
                   vitAcs_62_sb, vitAcs_62_sb_ir, vitAcs_62_sb_fe, vitAcs_62_sb_re, 
                   vitAcs_62_pmIn0, vitAcs_62_pmIn0_ir, vitAcs_62_pmIn0_fe, vitAcs_62_pmIn0_re, 
                   vitAcs_62_pmIn1, vitAcs_62_pmIn1_ir, vitAcs_62_pmIn1_fe, vitAcs_62_pmIn1_re, 
                   vitAcs_62_run1, 
                   regBus, regWe, regRe, vitAcs_62_regWe, vitAcs_62_regRe, clk, clk2, reset);


//==============================================================================
