//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_54_sb_w            = 8;
  parameter vitAcs_54_pmIn0_w         = 9;
  parameter vitAcs_54_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_54_sel_w           = 1;
  parameter vitAcs_54_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_54_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_54_i0              = 0;
  parameter vitAcs_54_i1              = 0;
  parameter vitAcs_54_pbrv            = 412;
  parameter vitAcs_54_ws              = 4;
  parameter vitAcs_54_wp              = 9;

  // Iregs
  parameter vitAcs_54_pmBuf_w         = 9;
  parameter vitAcs_54_pmBuf_n         = 1;
  parameter vitAcs_54_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_54.sb_w            = vitAcs_54_sb_w;
  defparam vitAcs_54.pmIn0_w         = vitAcs_54_pmIn0_w;
  defparam vitAcs_54.pmIn1_w         = vitAcs_54_pmIn1_w;
  defparam vitAcs_54.sel_w           = vitAcs_54_sel_w;
  defparam vitAcs_54.pmOut_w         = vitAcs_54_pmOut_w;
  defparam vitAcs_54.run1_w          = vitAcs_54_run1_w;
  defparam vitAcs_54.i0              = vitAcs_54_i0;
  defparam vitAcs_54.i1              = vitAcs_54_i1;
  defparam vitAcs_54.pbrv            = vitAcs_54_pbrv;
  defparam vitAcs_54.ws              = vitAcs_54_ws;
  defparam vitAcs_54.wp              = vitAcs_54_wp;
  defparam vitAcs_54.pmBuf_w         = vitAcs_54_pmBuf_w;
  defparam vitAcs_54.pmBuf_n         = vitAcs_54_pmBuf_n;
  defparam vitAcs_54.pmBuf_m         = vitAcs_54_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_54_sel_w-1:0]  vitAcs_54_sel;
  wire                                      vitAcs_54_sel_or;
  wire                                      vitAcs_54_sel_ff;
  wire                                      vitAcs_54_sel_we;

  wire             [vitAcs_54_pmOut_w-1:0]  vitAcs_54_pmOut;
  wire                                      vitAcs_54_pmOut_or;
  wire                                      vitAcs_54_pmOut_ff;
  wire                                      vitAcs_54_pmOut_we;

  wire                [vitAcs_54_sb_w-1:0]  vitAcs_54_sb;
  wire                                      vitAcs_54_sb_ir;
  wire                                      vitAcs_54_sb_fe;
  wire                                      vitAcs_54_sb_re;

  wire             [vitAcs_54_pmIn0_w-1:0]  vitAcs_54_pmIn0;
  wire                                      vitAcs_54_pmIn0_ir;
  wire                                      vitAcs_54_pmIn0_fe;
  wire                                      vitAcs_54_pmIn0_re;

  wire             [vitAcs_54_pmIn1_w-1:0]  vitAcs_54_pmIn1;
  wire                                      vitAcs_54_pmIn1_ir;
  wire                                      vitAcs_54_pmIn1_fe;
  wire                                      vitAcs_54_pmIn1_re;

  wire              [vitAcs_54_run1_w-1:0]  vitAcs_54_run1;

  wire                                      vitAcs_54_regWe;
  wire                                      vitAcs_54_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_54(vitAcs_54_sel, vitAcs_54_sel_or, vitAcs_54_sel_ff, vitAcs_54_sel_we,
                   vitAcs_54_pmOut, vitAcs_54_pmOut_or, vitAcs_54_pmOut_ff, vitAcs_54_pmOut_we,
                   vitAcs_54_sb, vitAcs_54_sb_ir, vitAcs_54_sb_fe, vitAcs_54_sb_re, 
                   vitAcs_54_pmIn0, vitAcs_54_pmIn0_ir, vitAcs_54_pmIn0_fe, vitAcs_54_pmIn0_re, 
                   vitAcs_54_pmIn1, vitAcs_54_pmIn1_ir, vitAcs_54_pmIn1_fe, vitAcs_54_pmIn1_re, 
                   vitAcs_54_run1, 
                   regBus, regWe, regRe, vitAcs_54_regWe, vitAcs_54_regRe, clk, clk2, reset);


//==============================================================================
