//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_53_sb_w            = 8;
  parameter vitAcs_53_pmIn0_w         = 9;
  parameter vitAcs_53_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_53_sel_w           = 1;
  parameter vitAcs_53_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_53_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_53_i0              = 1;
  parameter vitAcs_53_i1              = 0;
  parameter vitAcs_53_pbrv            = 412;
  parameter vitAcs_53_ws              = 4;
  parameter vitAcs_53_wp              = 9;

  // Iregs
  parameter vitAcs_53_pmBuf_w         = 9;
  parameter vitAcs_53_pmBuf_n         = 1;
  parameter vitAcs_53_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_53.sb_w            = vitAcs_53_sb_w;
  defparam vitAcs_53.pmIn0_w         = vitAcs_53_pmIn0_w;
  defparam vitAcs_53.pmIn1_w         = vitAcs_53_pmIn1_w;
  defparam vitAcs_53.sel_w           = vitAcs_53_sel_w;
  defparam vitAcs_53.pmOut_w         = vitAcs_53_pmOut_w;
  defparam vitAcs_53.run1_w          = vitAcs_53_run1_w;
  defparam vitAcs_53.i0              = vitAcs_53_i0;
  defparam vitAcs_53.i1              = vitAcs_53_i1;
  defparam vitAcs_53.pbrv            = vitAcs_53_pbrv;
  defparam vitAcs_53.ws              = vitAcs_53_ws;
  defparam vitAcs_53.wp              = vitAcs_53_wp;
  defparam vitAcs_53.pmBuf_w         = vitAcs_53_pmBuf_w;
  defparam vitAcs_53.pmBuf_n         = vitAcs_53_pmBuf_n;
  defparam vitAcs_53.pmBuf_m         = vitAcs_53_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_53_sel_w-1:0]  vitAcs_53_sel;
  wire                                      vitAcs_53_sel_or;
  wire                                      vitAcs_53_sel_ff;
  wire                                      vitAcs_53_sel_we;

  wire             [vitAcs_53_pmOut_w-1:0]  vitAcs_53_pmOut;
  wire                                      vitAcs_53_pmOut_or;
  wire                                      vitAcs_53_pmOut_ff;
  wire                                      vitAcs_53_pmOut_we;

  wire                [vitAcs_53_sb_w-1:0]  vitAcs_53_sb;
  wire                                      vitAcs_53_sb_ir;
  wire                                      vitAcs_53_sb_fe;
  wire                                      vitAcs_53_sb_re;

  wire             [vitAcs_53_pmIn0_w-1:0]  vitAcs_53_pmIn0;
  wire                                      vitAcs_53_pmIn0_ir;
  wire                                      vitAcs_53_pmIn0_fe;
  wire                                      vitAcs_53_pmIn0_re;

  wire             [vitAcs_53_pmIn1_w-1:0]  vitAcs_53_pmIn1;
  wire                                      vitAcs_53_pmIn1_ir;
  wire                                      vitAcs_53_pmIn1_fe;
  wire                                      vitAcs_53_pmIn1_re;

  wire              [vitAcs_53_run1_w-1:0]  vitAcs_53_run1;

  wire                                      vitAcs_53_regWe;
  wire                                      vitAcs_53_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_53(vitAcs_53_sel, vitAcs_53_sel_or, vitAcs_53_sel_ff, vitAcs_53_sel_we,
                   vitAcs_53_pmOut, vitAcs_53_pmOut_or, vitAcs_53_pmOut_ff, vitAcs_53_pmOut_we,
                   vitAcs_53_sb, vitAcs_53_sb_ir, vitAcs_53_sb_fe, vitAcs_53_sb_re, 
                   vitAcs_53_pmIn0, vitAcs_53_pmIn0_ir, vitAcs_53_pmIn0_fe, vitAcs_53_pmIn0_re, 
                   vitAcs_53_pmIn1, vitAcs_53_pmIn1_ir, vitAcs_53_pmIn1_fe, vitAcs_53_pmIn1_re, 
                   vitAcs_53_run1, 
                   regBus, regWe, regRe, vitAcs_53_regWe, vitAcs_53_regRe, clk, clk2, reset);


//==============================================================================
