//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_51_sb_w            = 8;
  parameter vitAcs_51_pmIn0_w         = 9;
  parameter vitAcs_51_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_51_sel_w           = 1;
  parameter vitAcs_51_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_51_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_51_i0              = 0;
  parameter vitAcs_51_i1              = 0;
  parameter vitAcs_51_pbrv            = 412;
  parameter vitAcs_51_ws              = 4;
  parameter vitAcs_51_wp              = 9;

  // Iregs
  parameter vitAcs_51_pmBuf_w         = 9;
  parameter vitAcs_51_pmBuf_n         = 1;
  parameter vitAcs_51_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_51.sb_w            = vitAcs_51_sb_w;
  defparam vitAcs_51.pmIn0_w         = vitAcs_51_pmIn0_w;
  defparam vitAcs_51.pmIn1_w         = vitAcs_51_pmIn1_w;
  defparam vitAcs_51.sel_w           = vitAcs_51_sel_w;
  defparam vitAcs_51.pmOut_w         = vitAcs_51_pmOut_w;
  defparam vitAcs_51.run1_w          = vitAcs_51_run1_w;
  defparam vitAcs_51.i0              = vitAcs_51_i0;
  defparam vitAcs_51.i1              = vitAcs_51_i1;
  defparam vitAcs_51.pbrv            = vitAcs_51_pbrv;
  defparam vitAcs_51.ws              = vitAcs_51_ws;
  defparam vitAcs_51.wp              = vitAcs_51_wp;
  defparam vitAcs_51.pmBuf_w         = vitAcs_51_pmBuf_w;
  defparam vitAcs_51.pmBuf_n         = vitAcs_51_pmBuf_n;
  defparam vitAcs_51.pmBuf_m         = vitAcs_51_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_51_sel_w-1:0]  vitAcs_51_sel;
  wire                                      vitAcs_51_sel_or;
  wire                                      vitAcs_51_sel_ff;
  wire                                      vitAcs_51_sel_we;

  wire             [vitAcs_51_pmOut_w-1:0]  vitAcs_51_pmOut;
  wire                                      vitAcs_51_pmOut_or;
  wire                                      vitAcs_51_pmOut_ff;
  wire                                      vitAcs_51_pmOut_we;

  wire                [vitAcs_51_sb_w-1:0]  vitAcs_51_sb;
  wire                                      vitAcs_51_sb_ir;
  wire                                      vitAcs_51_sb_fe;
  wire                                      vitAcs_51_sb_re;

  wire             [vitAcs_51_pmIn0_w-1:0]  vitAcs_51_pmIn0;
  wire                                      vitAcs_51_pmIn0_ir;
  wire                                      vitAcs_51_pmIn0_fe;
  wire                                      vitAcs_51_pmIn0_re;

  wire             [vitAcs_51_pmIn1_w-1:0]  vitAcs_51_pmIn1;
  wire                                      vitAcs_51_pmIn1_ir;
  wire                                      vitAcs_51_pmIn1_fe;
  wire                                      vitAcs_51_pmIn1_re;

  wire              [vitAcs_51_run1_w-1:0]  vitAcs_51_run1;

  wire                                      vitAcs_51_regWe;
  wire                                      vitAcs_51_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_51(vitAcs_51_sel, vitAcs_51_sel_or, vitAcs_51_sel_ff, vitAcs_51_sel_we,
                   vitAcs_51_pmOut, vitAcs_51_pmOut_or, vitAcs_51_pmOut_ff, vitAcs_51_pmOut_we,
                   vitAcs_51_sb, vitAcs_51_sb_ir, vitAcs_51_sb_fe, vitAcs_51_sb_re, 
                   vitAcs_51_pmIn0, vitAcs_51_pmIn0_ir, vitAcs_51_pmIn0_fe, vitAcs_51_pmIn0_re, 
                   vitAcs_51_pmIn1, vitAcs_51_pmIn1_ir, vitAcs_51_pmIn1_fe, vitAcs_51_pmIn1_re, 
                   vitAcs_51_run1, 
                   regBus, regWe, regRe, vitAcs_51_regWe, vitAcs_51_regRe, clk, clk2, reset);


//==============================================================================
