//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_50_sb_w            = 8;
  parameter vitAcs_50_pmIn0_w         = 9;
  parameter vitAcs_50_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_50_sel_w           = 1;
  parameter vitAcs_50_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_50_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_50_i0              = 1;
  parameter vitAcs_50_i1              = 1;
  parameter vitAcs_50_pbrv            = 412;
  parameter vitAcs_50_ws              = 4;
  parameter vitAcs_50_wp              = 9;

  // Iregs
  parameter vitAcs_50_pmBuf_w         = 9;
  parameter vitAcs_50_pmBuf_n         = 1;
  parameter vitAcs_50_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_50.sb_w            = vitAcs_50_sb_w;
  defparam vitAcs_50.pmIn0_w         = vitAcs_50_pmIn0_w;
  defparam vitAcs_50.pmIn1_w         = vitAcs_50_pmIn1_w;
  defparam vitAcs_50.sel_w           = vitAcs_50_sel_w;
  defparam vitAcs_50.pmOut_w         = vitAcs_50_pmOut_w;
  defparam vitAcs_50.run1_w          = vitAcs_50_run1_w;
  defparam vitAcs_50.i0              = vitAcs_50_i0;
  defparam vitAcs_50.i1              = vitAcs_50_i1;
  defparam vitAcs_50.pbrv            = vitAcs_50_pbrv;
  defparam vitAcs_50.ws              = vitAcs_50_ws;
  defparam vitAcs_50.wp              = vitAcs_50_wp;
  defparam vitAcs_50.pmBuf_w         = vitAcs_50_pmBuf_w;
  defparam vitAcs_50.pmBuf_n         = vitAcs_50_pmBuf_n;
  defparam vitAcs_50.pmBuf_m         = vitAcs_50_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_50_sel_w-1:0]  vitAcs_50_sel;
  wire                                      vitAcs_50_sel_or;
  wire                                      vitAcs_50_sel_ff;
  wire                                      vitAcs_50_sel_we;

  wire             [vitAcs_50_pmOut_w-1:0]  vitAcs_50_pmOut;
  wire                                      vitAcs_50_pmOut_or;
  wire                                      vitAcs_50_pmOut_ff;
  wire                                      vitAcs_50_pmOut_we;

  wire                [vitAcs_50_sb_w-1:0]  vitAcs_50_sb;
  wire                                      vitAcs_50_sb_ir;
  wire                                      vitAcs_50_sb_fe;
  wire                                      vitAcs_50_sb_re;

  wire             [vitAcs_50_pmIn0_w-1:0]  vitAcs_50_pmIn0;
  wire                                      vitAcs_50_pmIn0_ir;
  wire                                      vitAcs_50_pmIn0_fe;
  wire                                      vitAcs_50_pmIn0_re;

  wire             [vitAcs_50_pmIn1_w-1:0]  vitAcs_50_pmIn1;
  wire                                      vitAcs_50_pmIn1_ir;
  wire                                      vitAcs_50_pmIn1_fe;
  wire                                      vitAcs_50_pmIn1_re;

  wire              [vitAcs_50_run1_w-1:0]  vitAcs_50_run1;

  wire                                      vitAcs_50_regWe;
  wire                                      vitAcs_50_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_50(vitAcs_50_sel, vitAcs_50_sel_or, vitAcs_50_sel_ff, vitAcs_50_sel_we,
                   vitAcs_50_pmOut, vitAcs_50_pmOut_or, vitAcs_50_pmOut_ff, vitAcs_50_pmOut_we,
                   vitAcs_50_sb, vitAcs_50_sb_ir, vitAcs_50_sb_fe, vitAcs_50_sb_re, 
                   vitAcs_50_pmIn0, vitAcs_50_pmIn0_ir, vitAcs_50_pmIn0_fe, vitAcs_50_pmIn0_re, 
                   vitAcs_50_pmIn1, vitAcs_50_pmIn1_ir, vitAcs_50_pmIn1_fe, vitAcs_50_pmIn1_re, 
                   vitAcs_50_run1, 
                   regBus, regWe, regRe, vitAcs_50_regWe, vitAcs_50_regRe, clk, clk2, reset);


//==============================================================================
