//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_49_sb_w            = 8;
  parameter vitAcs_49_pmIn0_w         = 9;
  parameter vitAcs_49_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_49_sel_w           = 1;
  parameter vitAcs_49_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_49_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_49_i0              = 0;
  parameter vitAcs_49_i1              = 1;
  parameter vitAcs_49_pbrv            = 412;
  parameter vitAcs_49_ws              = 4;
  parameter vitAcs_49_wp              = 9;

  // Iregs
  parameter vitAcs_49_pmBuf_w         = 9;
  parameter vitAcs_49_pmBuf_n         = 1;
  parameter vitAcs_49_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_49.sb_w            = vitAcs_49_sb_w;
  defparam vitAcs_49.pmIn0_w         = vitAcs_49_pmIn0_w;
  defparam vitAcs_49.pmIn1_w         = vitAcs_49_pmIn1_w;
  defparam vitAcs_49.sel_w           = vitAcs_49_sel_w;
  defparam vitAcs_49.pmOut_w         = vitAcs_49_pmOut_w;
  defparam vitAcs_49.run1_w          = vitAcs_49_run1_w;
  defparam vitAcs_49.i0              = vitAcs_49_i0;
  defparam vitAcs_49.i1              = vitAcs_49_i1;
  defparam vitAcs_49.pbrv            = vitAcs_49_pbrv;
  defparam vitAcs_49.ws              = vitAcs_49_ws;
  defparam vitAcs_49.wp              = vitAcs_49_wp;
  defparam vitAcs_49.pmBuf_w         = vitAcs_49_pmBuf_w;
  defparam vitAcs_49.pmBuf_n         = vitAcs_49_pmBuf_n;
  defparam vitAcs_49.pmBuf_m         = vitAcs_49_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_49_sel_w-1:0]  vitAcs_49_sel;
  wire                                      vitAcs_49_sel_or;
  wire                                      vitAcs_49_sel_ff;
  wire                                      vitAcs_49_sel_we;

  wire             [vitAcs_49_pmOut_w-1:0]  vitAcs_49_pmOut;
  wire                                      vitAcs_49_pmOut_or;
  wire                                      vitAcs_49_pmOut_ff;
  wire                                      vitAcs_49_pmOut_we;

  wire                [vitAcs_49_sb_w-1:0]  vitAcs_49_sb;
  wire                                      vitAcs_49_sb_ir;
  wire                                      vitAcs_49_sb_fe;
  wire                                      vitAcs_49_sb_re;

  wire             [vitAcs_49_pmIn0_w-1:0]  vitAcs_49_pmIn0;
  wire                                      vitAcs_49_pmIn0_ir;
  wire                                      vitAcs_49_pmIn0_fe;
  wire                                      vitAcs_49_pmIn0_re;

  wire             [vitAcs_49_pmIn1_w-1:0]  vitAcs_49_pmIn1;
  wire                                      vitAcs_49_pmIn1_ir;
  wire                                      vitAcs_49_pmIn1_fe;
  wire                                      vitAcs_49_pmIn1_re;

  wire              [vitAcs_49_run1_w-1:0]  vitAcs_49_run1;

  wire                                      vitAcs_49_regWe;
  wire                                      vitAcs_49_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_49(vitAcs_49_sel, vitAcs_49_sel_or, vitAcs_49_sel_ff, vitAcs_49_sel_we,
                   vitAcs_49_pmOut, vitAcs_49_pmOut_or, vitAcs_49_pmOut_ff, vitAcs_49_pmOut_we,
                   vitAcs_49_sb, vitAcs_49_sb_ir, vitAcs_49_sb_fe, vitAcs_49_sb_re, 
                   vitAcs_49_pmIn0, vitAcs_49_pmIn0_ir, vitAcs_49_pmIn0_fe, vitAcs_49_pmIn0_re, 
                   vitAcs_49_pmIn1, vitAcs_49_pmIn1_ir, vitAcs_49_pmIn1_fe, vitAcs_49_pmIn1_re, 
                   vitAcs_49_run1, 
                   regBus, regWe, regRe, vitAcs_49_regWe, vitAcs_49_regRe, clk, clk2, reset);


//==============================================================================
