//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_48_sb_w            = 8;
  parameter vitAcs_48_pmIn0_w         = 9;
  parameter vitAcs_48_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_48_sel_w           = 1;
  parameter vitAcs_48_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_48_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_48_i0              = 1;
  parameter vitAcs_48_i1              = 0;
  parameter vitAcs_48_pbrv            = 412;
  parameter vitAcs_48_ws              = 4;
  parameter vitAcs_48_wp              = 9;

  // Iregs
  parameter vitAcs_48_pmBuf_w         = 9;
  parameter vitAcs_48_pmBuf_n         = 1;
  parameter vitAcs_48_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_48.sb_w            = vitAcs_48_sb_w;
  defparam vitAcs_48.pmIn0_w         = vitAcs_48_pmIn0_w;
  defparam vitAcs_48.pmIn1_w         = vitAcs_48_pmIn1_w;
  defparam vitAcs_48.sel_w           = vitAcs_48_sel_w;
  defparam vitAcs_48.pmOut_w         = vitAcs_48_pmOut_w;
  defparam vitAcs_48.run1_w          = vitAcs_48_run1_w;
  defparam vitAcs_48.i0              = vitAcs_48_i0;
  defparam vitAcs_48.i1              = vitAcs_48_i1;
  defparam vitAcs_48.pbrv            = vitAcs_48_pbrv;
  defparam vitAcs_48.ws              = vitAcs_48_ws;
  defparam vitAcs_48.wp              = vitAcs_48_wp;
  defparam vitAcs_48.pmBuf_w         = vitAcs_48_pmBuf_w;
  defparam vitAcs_48.pmBuf_n         = vitAcs_48_pmBuf_n;
  defparam vitAcs_48.pmBuf_m         = vitAcs_48_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_48_sel_w-1:0]  vitAcs_48_sel;
  wire                                      vitAcs_48_sel_or;
  wire                                      vitAcs_48_sel_ff;
  wire                                      vitAcs_48_sel_we;

  wire             [vitAcs_48_pmOut_w-1:0]  vitAcs_48_pmOut;
  wire                                      vitAcs_48_pmOut_or;
  wire                                      vitAcs_48_pmOut_ff;
  wire                                      vitAcs_48_pmOut_we;

  wire                [vitAcs_48_sb_w-1:0]  vitAcs_48_sb;
  wire                                      vitAcs_48_sb_ir;
  wire                                      vitAcs_48_sb_fe;
  wire                                      vitAcs_48_sb_re;

  wire             [vitAcs_48_pmIn0_w-1:0]  vitAcs_48_pmIn0;
  wire                                      vitAcs_48_pmIn0_ir;
  wire                                      vitAcs_48_pmIn0_fe;
  wire                                      vitAcs_48_pmIn0_re;

  wire             [vitAcs_48_pmIn1_w-1:0]  vitAcs_48_pmIn1;
  wire                                      vitAcs_48_pmIn1_ir;
  wire                                      vitAcs_48_pmIn1_fe;
  wire                                      vitAcs_48_pmIn1_re;

  wire              [vitAcs_48_run1_w-1:0]  vitAcs_48_run1;

  wire                                      vitAcs_48_regWe;
  wire                                      vitAcs_48_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_48(vitAcs_48_sel, vitAcs_48_sel_or, vitAcs_48_sel_ff, vitAcs_48_sel_we,
                   vitAcs_48_pmOut, vitAcs_48_pmOut_or, vitAcs_48_pmOut_ff, vitAcs_48_pmOut_we,
                   vitAcs_48_sb, vitAcs_48_sb_ir, vitAcs_48_sb_fe, vitAcs_48_sb_re, 
                   vitAcs_48_pmIn0, vitAcs_48_pmIn0_ir, vitAcs_48_pmIn0_fe, vitAcs_48_pmIn0_re, 
                   vitAcs_48_pmIn1, vitAcs_48_pmIn1_ir, vitAcs_48_pmIn1_fe, vitAcs_48_pmIn1_re, 
                   vitAcs_48_run1, 
                   regBus, regWe, regRe, vitAcs_48_regWe, vitAcs_48_regRe, clk, clk2, reset);


//==============================================================================
