//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_47_sb_w            = 8;
  parameter vitAcs_47_pmIn0_w         = 9;
  parameter vitAcs_47_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_47_sel_w           = 1;
  parameter vitAcs_47_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_47_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_47_i0              = 0;
  parameter vitAcs_47_i1              = 0;
  parameter vitAcs_47_pbrv            = 412;
  parameter vitAcs_47_ws              = 4;
  parameter vitAcs_47_wp              = 9;

  // Iregs
  parameter vitAcs_47_pmBuf_w         = 9;
  parameter vitAcs_47_pmBuf_n         = 1;
  parameter vitAcs_47_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_47.sb_w            = vitAcs_47_sb_w;
  defparam vitAcs_47.pmIn0_w         = vitAcs_47_pmIn0_w;
  defparam vitAcs_47.pmIn1_w         = vitAcs_47_pmIn1_w;
  defparam vitAcs_47.sel_w           = vitAcs_47_sel_w;
  defparam vitAcs_47.pmOut_w         = vitAcs_47_pmOut_w;
  defparam vitAcs_47.run1_w          = vitAcs_47_run1_w;
  defparam vitAcs_47.i0              = vitAcs_47_i0;
  defparam vitAcs_47.i1              = vitAcs_47_i1;
  defparam vitAcs_47.pbrv            = vitAcs_47_pbrv;
  defparam vitAcs_47.ws              = vitAcs_47_ws;
  defparam vitAcs_47.wp              = vitAcs_47_wp;
  defparam vitAcs_47.pmBuf_w         = vitAcs_47_pmBuf_w;
  defparam vitAcs_47.pmBuf_n         = vitAcs_47_pmBuf_n;
  defparam vitAcs_47.pmBuf_m         = vitAcs_47_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_47_sel_w-1:0]  vitAcs_47_sel;
  wire                                      vitAcs_47_sel_or;
  wire                                      vitAcs_47_sel_ff;
  wire                                      vitAcs_47_sel_we;

  wire             [vitAcs_47_pmOut_w-1:0]  vitAcs_47_pmOut;
  wire                                      vitAcs_47_pmOut_or;
  wire                                      vitAcs_47_pmOut_ff;
  wire                                      vitAcs_47_pmOut_we;

  wire                [vitAcs_47_sb_w-1:0]  vitAcs_47_sb;
  wire                                      vitAcs_47_sb_ir;
  wire                                      vitAcs_47_sb_fe;
  wire                                      vitAcs_47_sb_re;

  wire             [vitAcs_47_pmIn0_w-1:0]  vitAcs_47_pmIn0;
  wire                                      vitAcs_47_pmIn0_ir;
  wire                                      vitAcs_47_pmIn0_fe;
  wire                                      vitAcs_47_pmIn0_re;

  wire             [vitAcs_47_pmIn1_w-1:0]  vitAcs_47_pmIn1;
  wire                                      vitAcs_47_pmIn1_ir;
  wire                                      vitAcs_47_pmIn1_fe;
  wire                                      vitAcs_47_pmIn1_re;

  wire              [vitAcs_47_run1_w-1:0]  vitAcs_47_run1;

  wire                                      vitAcs_47_regWe;
  wire                                      vitAcs_47_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_47(vitAcs_47_sel, vitAcs_47_sel_or, vitAcs_47_sel_ff, vitAcs_47_sel_we,
                   vitAcs_47_pmOut, vitAcs_47_pmOut_or, vitAcs_47_pmOut_ff, vitAcs_47_pmOut_we,
                   vitAcs_47_sb, vitAcs_47_sb_ir, vitAcs_47_sb_fe, vitAcs_47_sb_re, 
                   vitAcs_47_pmIn0, vitAcs_47_pmIn0_ir, vitAcs_47_pmIn0_fe, vitAcs_47_pmIn0_re, 
                   vitAcs_47_pmIn1, vitAcs_47_pmIn1_ir, vitAcs_47_pmIn1_fe, vitAcs_47_pmIn1_re, 
                   vitAcs_47_run1, 
                   regBus, regWe, regRe, vitAcs_47_regWe, vitAcs_47_regRe, clk, clk2, reset);


//==============================================================================
