//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_46_sb_w            = 8;
  parameter vitAcs_46_pmIn0_w         = 9;
  parameter vitAcs_46_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_46_sel_w           = 1;
  parameter vitAcs_46_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_46_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_46_i0              = 1;
  parameter vitAcs_46_i1              = 1;
  parameter vitAcs_46_pbrv            = 412;
  parameter vitAcs_46_ws              = 4;
  parameter vitAcs_46_wp              = 9;

  // Iregs
  parameter vitAcs_46_pmBuf_w         = 9;
  parameter vitAcs_46_pmBuf_n         = 1;
  parameter vitAcs_46_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_46.sb_w            = vitAcs_46_sb_w;
  defparam vitAcs_46.pmIn0_w         = vitAcs_46_pmIn0_w;
  defparam vitAcs_46.pmIn1_w         = vitAcs_46_pmIn1_w;
  defparam vitAcs_46.sel_w           = vitAcs_46_sel_w;
  defparam vitAcs_46.pmOut_w         = vitAcs_46_pmOut_w;
  defparam vitAcs_46.run1_w          = vitAcs_46_run1_w;
  defparam vitAcs_46.i0              = vitAcs_46_i0;
  defparam vitAcs_46.i1              = vitAcs_46_i1;
  defparam vitAcs_46.pbrv            = vitAcs_46_pbrv;
  defparam vitAcs_46.ws              = vitAcs_46_ws;
  defparam vitAcs_46.wp              = vitAcs_46_wp;
  defparam vitAcs_46.pmBuf_w         = vitAcs_46_pmBuf_w;
  defparam vitAcs_46.pmBuf_n         = vitAcs_46_pmBuf_n;
  defparam vitAcs_46.pmBuf_m         = vitAcs_46_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_46_sel_w-1:0]  vitAcs_46_sel;
  wire                                      vitAcs_46_sel_or;
  wire                                      vitAcs_46_sel_ff;
  wire                                      vitAcs_46_sel_we;

  wire             [vitAcs_46_pmOut_w-1:0]  vitAcs_46_pmOut;
  wire                                      vitAcs_46_pmOut_or;
  wire                                      vitAcs_46_pmOut_ff;
  wire                                      vitAcs_46_pmOut_we;

  wire                [vitAcs_46_sb_w-1:0]  vitAcs_46_sb;
  wire                                      vitAcs_46_sb_ir;
  wire                                      vitAcs_46_sb_fe;
  wire                                      vitAcs_46_sb_re;

  wire             [vitAcs_46_pmIn0_w-1:0]  vitAcs_46_pmIn0;
  wire                                      vitAcs_46_pmIn0_ir;
  wire                                      vitAcs_46_pmIn0_fe;
  wire                                      vitAcs_46_pmIn0_re;

  wire             [vitAcs_46_pmIn1_w-1:0]  vitAcs_46_pmIn1;
  wire                                      vitAcs_46_pmIn1_ir;
  wire                                      vitAcs_46_pmIn1_fe;
  wire                                      vitAcs_46_pmIn1_re;

  wire              [vitAcs_46_run1_w-1:0]  vitAcs_46_run1;

  wire                                      vitAcs_46_regWe;
  wire                                      vitAcs_46_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_46(vitAcs_46_sel, vitAcs_46_sel_or, vitAcs_46_sel_ff, vitAcs_46_sel_we,
                   vitAcs_46_pmOut, vitAcs_46_pmOut_or, vitAcs_46_pmOut_ff, vitAcs_46_pmOut_we,
                   vitAcs_46_sb, vitAcs_46_sb_ir, vitAcs_46_sb_fe, vitAcs_46_sb_re, 
                   vitAcs_46_pmIn0, vitAcs_46_pmIn0_ir, vitAcs_46_pmIn0_fe, vitAcs_46_pmIn0_re, 
                   vitAcs_46_pmIn1, vitAcs_46_pmIn1_ir, vitAcs_46_pmIn1_fe, vitAcs_46_pmIn1_re, 
                   vitAcs_46_run1, 
                   regBus, regWe, regRe, vitAcs_46_regWe, vitAcs_46_regRe, clk, clk2, reset);


//==============================================================================
