//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_45_sb_w            = 8;
  parameter vitAcs_45_pmIn0_w         = 9;
  parameter vitAcs_45_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_45_sel_w           = 1;
  parameter vitAcs_45_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_45_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_45_i0              = 0;
  parameter vitAcs_45_i1              = 1;
  parameter vitAcs_45_pbrv            = 412;
  parameter vitAcs_45_ws              = 4;
  parameter vitAcs_45_wp              = 9;

  // Iregs
  parameter vitAcs_45_pmBuf_w         = 9;
  parameter vitAcs_45_pmBuf_n         = 1;
  parameter vitAcs_45_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_45.sb_w            = vitAcs_45_sb_w;
  defparam vitAcs_45.pmIn0_w         = vitAcs_45_pmIn0_w;
  defparam vitAcs_45.pmIn1_w         = vitAcs_45_pmIn1_w;
  defparam vitAcs_45.sel_w           = vitAcs_45_sel_w;
  defparam vitAcs_45.pmOut_w         = vitAcs_45_pmOut_w;
  defparam vitAcs_45.run1_w          = vitAcs_45_run1_w;
  defparam vitAcs_45.i0              = vitAcs_45_i0;
  defparam vitAcs_45.i1              = vitAcs_45_i1;
  defparam vitAcs_45.pbrv            = vitAcs_45_pbrv;
  defparam vitAcs_45.ws              = vitAcs_45_ws;
  defparam vitAcs_45.wp              = vitAcs_45_wp;
  defparam vitAcs_45.pmBuf_w         = vitAcs_45_pmBuf_w;
  defparam vitAcs_45.pmBuf_n         = vitAcs_45_pmBuf_n;
  defparam vitAcs_45.pmBuf_m         = vitAcs_45_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_45_sel_w-1:0]  vitAcs_45_sel;
  wire                                      vitAcs_45_sel_or;
  wire                                      vitAcs_45_sel_ff;
  wire                                      vitAcs_45_sel_we;

  wire             [vitAcs_45_pmOut_w-1:0]  vitAcs_45_pmOut;
  wire                                      vitAcs_45_pmOut_or;
  wire                                      vitAcs_45_pmOut_ff;
  wire                                      vitAcs_45_pmOut_we;

  wire                [vitAcs_45_sb_w-1:0]  vitAcs_45_sb;
  wire                                      vitAcs_45_sb_ir;
  wire                                      vitAcs_45_sb_fe;
  wire                                      vitAcs_45_sb_re;

  wire             [vitAcs_45_pmIn0_w-1:0]  vitAcs_45_pmIn0;
  wire                                      vitAcs_45_pmIn0_ir;
  wire                                      vitAcs_45_pmIn0_fe;
  wire                                      vitAcs_45_pmIn0_re;

  wire             [vitAcs_45_pmIn1_w-1:0]  vitAcs_45_pmIn1;
  wire                                      vitAcs_45_pmIn1_ir;
  wire                                      vitAcs_45_pmIn1_fe;
  wire                                      vitAcs_45_pmIn1_re;

  wire              [vitAcs_45_run1_w-1:0]  vitAcs_45_run1;

  wire                                      vitAcs_45_regWe;
  wire                                      vitAcs_45_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_45(vitAcs_45_sel, vitAcs_45_sel_or, vitAcs_45_sel_ff, vitAcs_45_sel_we,
                   vitAcs_45_pmOut, vitAcs_45_pmOut_or, vitAcs_45_pmOut_ff, vitAcs_45_pmOut_we,
                   vitAcs_45_sb, vitAcs_45_sb_ir, vitAcs_45_sb_fe, vitAcs_45_sb_re, 
                   vitAcs_45_pmIn0, vitAcs_45_pmIn0_ir, vitAcs_45_pmIn0_fe, vitAcs_45_pmIn0_re, 
                   vitAcs_45_pmIn1, vitAcs_45_pmIn1_ir, vitAcs_45_pmIn1_fe, vitAcs_45_pmIn1_re, 
                   vitAcs_45_run1, 
                   regBus, regWe, regRe, vitAcs_45_regWe, vitAcs_45_regRe, clk, clk2, reset);


//==============================================================================
