//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_43_sb_w            = 8;
  parameter vitAcs_43_pmIn0_w         = 9;
  parameter vitAcs_43_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_43_sel_w           = 1;
  parameter vitAcs_43_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_43_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_43_i0              = 1;
  parameter vitAcs_43_i1              = 1;
  parameter vitAcs_43_pbrv            = 412;
  parameter vitAcs_43_ws              = 4;
  parameter vitAcs_43_wp              = 9;

  // Iregs
  parameter vitAcs_43_pmBuf_w         = 9;
  parameter vitAcs_43_pmBuf_n         = 1;
  parameter vitAcs_43_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_43.sb_w            = vitAcs_43_sb_w;
  defparam vitAcs_43.pmIn0_w         = vitAcs_43_pmIn0_w;
  defparam vitAcs_43.pmIn1_w         = vitAcs_43_pmIn1_w;
  defparam vitAcs_43.sel_w           = vitAcs_43_sel_w;
  defparam vitAcs_43.pmOut_w         = vitAcs_43_pmOut_w;
  defparam vitAcs_43.run1_w          = vitAcs_43_run1_w;
  defparam vitAcs_43.i0              = vitAcs_43_i0;
  defparam vitAcs_43.i1              = vitAcs_43_i1;
  defparam vitAcs_43.pbrv            = vitAcs_43_pbrv;
  defparam vitAcs_43.ws              = vitAcs_43_ws;
  defparam vitAcs_43.wp              = vitAcs_43_wp;
  defparam vitAcs_43.pmBuf_w         = vitAcs_43_pmBuf_w;
  defparam vitAcs_43.pmBuf_n         = vitAcs_43_pmBuf_n;
  defparam vitAcs_43.pmBuf_m         = vitAcs_43_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_43_sel_w-1:0]  vitAcs_43_sel;
  wire                                      vitAcs_43_sel_or;
  wire                                      vitAcs_43_sel_ff;
  wire                                      vitAcs_43_sel_we;

  wire             [vitAcs_43_pmOut_w-1:0]  vitAcs_43_pmOut;
  wire                                      vitAcs_43_pmOut_or;
  wire                                      vitAcs_43_pmOut_ff;
  wire                                      vitAcs_43_pmOut_we;

  wire                [vitAcs_43_sb_w-1:0]  vitAcs_43_sb;
  wire                                      vitAcs_43_sb_ir;
  wire                                      vitAcs_43_sb_fe;
  wire                                      vitAcs_43_sb_re;

  wire             [vitAcs_43_pmIn0_w-1:0]  vitAcs_43_pmIn0;
  wire                                      vitAcs_43_pmIn0_ir;
  wire                                      vitAcs_43_pmIn0_fe;
  wire                                      vitAcs_43_pmIn0_re;

  wire             [vitAcs_43_pmIn1_w-1:0]  vitAcs_43_pmIn1;
  wire                                      vitAcs_43_pmIn1_ir;
  wire                                      vitAcs_43_pmIn1_fe;
  wire                                      vitAcs_43_pmIn1_re;

  wire              [vitAcs_43_run1_w-1:0]  vitAcs_43_run1;

  wire                                      vitAcs_43_regWe;
  wire                                      vitAcs_43_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_43(vitAcs_43_sel, vitAcs_43_sel_or, vitAcs_43_sel_ff, vitAcs_43_sel_we,
                   vitAcs_43_pmOut, vitAcs_43_pmOut_or, vitAcs_43_pmOut_ff, vitAcs_43_pmOut_we,
                   vitAcs_43_sb, vitAcs_43_sb_ir, vitAcs_43_sb_fe, vitAcs_43_sb_re, 
                   vitAcs_43_pmIn0, vitAcs_43_pmIn0_ir, vitAcs_43_pmIn0_fe, vitAcs_43_pmIn0_re, 
                   vitAcs_43_pmIn1, vitAcs_43_pmIn1_ir, vitAcs_43_pmIn1_fe, vitAcs_43_pmIn1_re, 
                   vitAcs_43_run1, 
                   regBus, regWe, regRe, vitAcs_43_regWe, vitAcs_43_regRe, clk, clk2, reset);


//==============================================================================
