//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_42_sb_w            = 8;
  parameter vitAcs_42_pmIn0_w         = 9;
  parameter vitAcs_42_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_42_sel_w           = 1;
  parameter vitAcs_42_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_42_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_42_i0              = 0;
  parameter vitAcs_42_i1              = 0;
  parameter vitAcs_42_pbrv            = 412;
  parameter vitAcs_42_ws              = 4;
  parameter vitAcs_42_wp              = 9;

  // Iregs
  parameter vitAcs_42_pmBuf_w         = 9;
  parameter vitAcs_42_pmBuf_n         = 1;
  parameter vitAcs_42_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_42.sb_w            = vitAcs_42_sb_w;
  defparam vitAcs_42.pmIn0_w         = vitAcs_42_pmIn0_w;
  defparam vitAcs_42.pmIn1_w         = vitAcs_42_pmIn1_w;
  defparam vitAcs_42.sel_w           = vitAcs_42_sel_w;
  defparam vitAcs_42.pmOut_w         = vitAcs_42_pmOut_w;
  defparam vitAcs_42.run1_w          = vitAcs_42_run1_w;
  defparam vitAcs_42.i0              = vitAcs_42_i0;
  defparam vitAcs_42.i1              = vitAcs_42_i1;
  defparam vitAcs_42.pbrv            = vitAcs_42_pbrv;
  defparam vitAcs_42.ws              = vitAcs_42_ws;
  defparam vitAcs_42.wp              = vitAcs_42_wp;
  defparam vitAcs_42.pmBuf_w         = vitAcs_42_pmBuf_w;
  defparam vitAcs_42.pmBuf_n         = vitAcs_42_pmBuf_n;
  defparam vitAcs_42.pmBuf_m         = vitAcs_42_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_42_sel_w-1:0]  vitAcs_42_sel;
  wire                                      vitAcs_42_sel_or;
  wire                                      vitAcs_42_sel_ff;
  wire                                      vitAcs_42_sel_we;

  wire             [vitAcs_42_pmOut_w-1:0]  vitAcs_42_pmOut;
  wire                                      vitAcs_42_pmOut_or;
  wire                                      vitAcs_42_pmOut_ff;
  wire                                      vitAcs_42_pmOut_we;

  wire                [vitAcs_42_sb_w-1:0]  vitAcs_42_sb;
  wire                                      vitAcs_42_sb_ir;
  wire                                      vitAcs_42_sb_fe;
  wire                                      vitAcs_42_sb_re;

  wire             [vitAcs_42_pmIn0_w-1:0]  vitAcs_42_pmIn0;
  wire                                      vitAcs_42_pmIn0_ir;
  wire                                      vitAcs_42_pmIn0_fe;
  wire                                      vitAcs_42_pmIn0_re;

  wire             [vitAcs_42_pmIn1_w-1:0]  vitAcs_42_pmIn1;
  wire                                      vitAcs_42_pmIn1_ir;
  wire                                      vitAcs_42_pmIn1_fe;
  wire                                      vitAcs_42_pmIn1_re;

  wire              [vitAcs_42_run1_w-1:0]  vitAcs_42_run1;

  wire                                      vitAcs_42_regWe;
  wire                                      vitAcs_42_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_42(vitAcs_42_sel, vitAcs_42_sel_or, vitAcs_42_sel_ff, vitAcs_42_sel_we,
                   vitAcs_42_pmOut, vitAcs_42_pmOut_or, vitAcs_42_pmOut_ff, vitAcs_42_pmOut_we,
                   vitAcs_42_sb, vitAcs_42_sb_ir, vitAcs_42_sb_fe, vitAcs_42_sb_re, 
                   vitAcs_42_pmIn0, vitAcs_42_pmIn0_ir, vitAcs_42_pmIn0_fe, vitAcs_42_pmIn0_re, 
                   vitAcs_42_pmIn1, vitAcs_42_pmIn1_ir, vitAcs_42_pmIn1_fe, vitAcs_42_pmIn1_re, 
                   vitAcs_42_run1, 
                   regBus, regWe, regRe, vitAcs_42_regWe, vitAcs_42_regRe, clk, clk2, reset);


//==============================================================================
